/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.redhat.cloud.notifications.avro.AvroInit;
import com.redhat.cloud.notifications.avro.Iso8601Conversion;
import com.redhat.cloud.notifications.avro.Iso8601Factory;
import com.redhat.cloud.notifications.avro.JsonObjectConversion;
import com.redhat.cloud.notifications.avro.JsonObjectFactory;
import com.redhat.cloud.notifications.ingress.Event;
import com.redhat.cloud.notifications.ingress.Recipient;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Action
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4154590066934436165L;
    public static final Schema SCHEMA$;
    private static final SpecificData MODEL$;
    private static final BinaryMessageEncoder<Action> ENCODER;
    private static final BinaryMessageDecoder<Action> DECODER;
    private String bundle;
    private String application;
    private String event_type;
    private LocalDateTime timestamp;
    private String account_id;
    private Map context;
    private List<Event> events;
    private String version;
    private List<Recipient> recipients;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<Action> WRITER$;
    private static final DatumReader<Action> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Action> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Action> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Action> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Action fromByteBuffer(ByteBuffer b) throws IOException {
        return (Action)((Object)DECODER.decode(b));
    }

    public Action() {
    }

    public Action(String bundle, String application, String event_type, LocalDateTime timestamp, String account_id, Map context, List<Event> events, String version, List<Recipient> recipients) {
        this.bundle = bundle;
        this.application = application;
        this.event_type = event_type;
        this.timestamp = timestamp;
        this.account_id = account_id;
        this.context = context;
        this.events = events;
        this.version = version;
        this.recipients = recipients;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.bundle;
            }
            case 1: {
                return this.application;
            }
            case 2: {
                return this.event_type;
            }
            case 3: {
                return this.timestamp;
            }
            case 4: {
                return this.account_id;
            }
            case 5: {
                return this.context;
            }
            case 6: {
                return this.events;
            }
            case 7: {
                return this.version;
            }
            case 8: {
                return this.recipients;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.bundle = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.application = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.event_type = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.timestamp = (LocalDateTime)value$;
                break;
            }
            case 4: {
                this.account_id = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.context = (Map)value$;
                break;
            }
            case 6: {
                this.events = (List)value$;
                break;
            }
            case 7: {
                this.version = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.recipients = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String value) {
        this.bundle = value;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String value) {
        this.application = value;
    }

    public String getEventType() {
        return this.event_type;
    }

    public void setEventType(String value) {
        this.event_type = value;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime value) {
        this.timestamp = value;
    }

    public String getAccountId() {
        return this.account_id;
    }

    public void setAccountId(String value) {
        this.account_id = value;
    }

    public Map getContext() {
        return this.context;
    }

    public void setContext(Map value) {
        this.context = value;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> value) {
        this.events = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<Recipient> value) {
        this.recipients = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Action other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        if (SCHEMA$ != null) {
            throw new RuntimeException("Application was not able to update before initializing the SCHEMA");
        }
        AvroInit.init();
        LogicalTypes.register((String)"iso-8601", (LogicalTypes.LogicalTypeFactory)new Iso8601Factory());
        LogicalTypes.register((String)"json-object", (LogicalTypes.LogicalTypeFactory)new JsonObjectFactory());
        SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Action\",\"namespace\":\"com.redhat.cloud.notifications.ingress\",\"fields\":[{\"name\":\"bundle\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"application\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"event_type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"timestamp\",\"type\":{\"type\":\"string\",\"logicalType\":\"iso-8601\"}},{\"name\":\"account_id\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"context\",\"type\":{\"type\":\"string\",\"logicalType\":\"json-object\"}},{\"name\":\"events\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Event\",\"fields\":[{\"name\":\"metadata\",\"type\":{\"type\":\"record\",\"name\":\"Metadata\",\"fields\":[]}},{\"name\":\"payload\",\"type\":{\"type\":\"string\",\"logicalType\":\"json-object\"},\"default\":\"{}\"}]}}},{\"name\":\"version\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"default\":\"v1.0.0\"},{\"name\":\"recipients\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Recipient\",\"fields\":[{\"name\":\"only_admins\",\"type\":\"boolean\"},{\"name\":\"ignore_user_preferences\",\"type\":\"boolean\"},{\"name\":\"users\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"default\":[]}]}},\"default\":[]}]}");
        MODEL$ = new SpecificData();
        MODEL$.addLogicalTypeConversion((Conversion)new JsonObjectConversion());
        MODEL$.addLogicalTypeConversion((Conversion)new Iso8601Conversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        conversions = new Conversion[]{null, null, null, new Iso8601Conversion(), null, new JsonObjectConversion(), null, null, null, null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Action>
    implements RecordBuilder<Action> {
        private String bundle;
        private String application;
        private String event_type;
        private LocalDateTime timestamp;
        private String account_id;
        private Map context;
        private List<Event> events;
        private String version;
        private List<Recipient> recipients;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.bundle)) {
                this.bundle = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.bundle);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.application)) {
                this.application = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.application);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.event_type)) {
                this.event_type = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.event_type);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.timestamp)) {
                this.timestamp = (LocalDateTime)this.data().deepCopy(this.fields()[3].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.account_id)) {
                this.account_id = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.account_id);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.context)) {
                this.context = (Map)this.data().deepCopy(this.fields()[5].schema(), (Object)other.context);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], other.events)) {
                this.events = (List)this.data().deepCopy(this.fields()[6].schema(), other.events);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.version)) {
                this.version = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.version);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], other.recipients)) {
                this.recipients = (List)this.data().deepCopy(this.fields()[8].schema(), other.recipients);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(Action other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.bundle)) {
                this.bundle = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.bundle);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.application)) {
                this.application = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.application);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.event_type)) {
                this.event_type = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.event_type);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.timestamp)) {
                this.timestamp = (LocalDateTime)this.data().deepCopy(this.fields()[3].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.account_id)) {
                this.account_id = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.account_id);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.context)) {
                this.context = (Map)this.data().deepCopy(this.fields()[5].schema(), (Object)other.context);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], other.events)) {
                this.events = (List)this.data().deepCopy(this.fields()[6].schema(), other.events);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.version)) {
                this.version = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.version);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], other.recipients)) {
                this.recipients = (List)this.data().deepCopy(this.fields()[8].schema(), other.recipients);
                this.fieldSetFlags()[8] = true;
            }
        }

        public String getBundle() {
            return this.bundle;
        }

        public Builder setBundle(String value) {
            this.validate(this.fields()[0], value);
            this.bundle = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasBundle() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearBundle() {
            this.bundle = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getApplication() {
            return this.application;
        }

        public Builder setApplication(String value) {
            this.validate(this.fields()[1], value);
            this.application = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasApplication() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearApplication() {
            this.application = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getEventType() {
            return this.event_type;
        }

        public Builder setEventType(String value) {
            this.validate(this.fields()[2], value);
            this.event_type = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasEventType() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearEventType() {
            this.event_type = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        public Builder setTimestamp(LocalDateTime value) {
            this.validate(this.fields()[3], value);
            this.timestamp = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasTimestamp() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearTimestamp() {
            this.timestamp = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getAccountId() {
            return this.account_id;
        }

        public Builder setAccountId(String value) {
            this.validate(this.fields()[4], value);
            this.account_id = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAccountId() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearAccountId() {
            this.account_id = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Map getContext() {
            return this.context;
        }

        public Builder setContext(Map value) {
            this.validate(this.fields()[5], value);
            this.context = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasContext() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearContext() {
            this.context = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public Builder setEvents(List<Event> value) {
            this.validate(this.fields()[6], value);
            this.events = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasEvents() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearEvents() {
            this.events = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setVersion(String value) {
            this.validate(this.fields()[7], value);
            this.version = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public List<Recipient> getRecipients() {
            return this.recipients;
        }

        public Builder setRecipients(List<Recipient> value) {
            this.validate(this.fields()[8], value);
            this.recipients = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasRecipients() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearRecipients() {
            this.recipients = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Action build() {
            try {
                Action record = new Action();
                record.bundle = this.fieldSetFlags()[0] ? this.bundle : (String)this.defaultValue(this.fields()[0]);
                record.application = this.fieldSetFlags()[1] ? this.application : (String)this.defaultValue(this.fields()[1]);
                record.event_type = this.fieldSetFlags()[2] ? this.event_type : (String)this.defaultValue(this.fields()[2]);
                record.timestamp = this.fieldSetFlags()[3] ? this.timestamp : (LocalDateTime)this.defaultValue(this.fields()[3]);
                record.account_id = this.fieldSetFlags()[4] ? this.account_id : (String)this.defaultValue(this.fields()[4]);
                record.context = this.fieldSetFlags()[5] ? this.context : (Map)this.defaultValue(this.fields()[5]);
                record.events = this.fieldSetFlags()[6] ? this.events : (List)this.defaultValue(this.fields()[6]);
                record.version = this.fieldSetFlags()[7] ? this.version : (String)this.defaultValue(this.fields()[7]);
                record.recipients = this.fieldSetFlags()[8] ? this.recipients : (List)this.defaultValue(this.fields()[8]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

