/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;

public class Registry {
    private final Map<String, Schema> avroSchemas = new HashMap<String, Schema>();

    public Schema getSchema(String version) {
        return this.avroSchemas.computeIfAbsent(version, s -> {
            Schema schema;
            block9: {
                InputStream avroInputStream = this.getClass().getResourceAsStream(String.format("/avro/action-%s.avsc", version));
                try {
                    if (avroInputStream == null) {
                        throw new RuntimeException(String.format("Version %s not found", version));
                    }
                    schema = new Schema.Parser().parse(avroInputStream);
                    if (avroInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (avroInputStream != null) {
                            try {
                                avroInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioException) {
                        throw new RuntimeException(String.format("Unable to load version %s", version), ioException);
                    }
                }
                avroInputStream.close();
            }
            return schema;
        });
    }
}

