
package com.redhat.cloud.notifications.ingress;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Notification message
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "version",
    "bundle",
    "application",
    "event_type",
    "timestamp",
    "account_id",
    "org_id",
    "context",
    "events",
    "recipients"
})
@Generated("jsonschema2pojo")
public class Action {

    /**
     * Version of the notification schema
     * <p>
     * 
     * 
     */
    @JsonProperty("version")
    private String version = "2.0.0";
    /**
     * Bundle name
     * <p>
     * Bundle name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("bundle")
    @JsonPropertyDescription("Bundle name as used during application registration")
    private String bundle;
    /**
     * Application name
     * <p>
     * Application name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("application")
    @JsonPropertyDescription("Application name as used during application registration")
    private String application;
    /**
     * Event type name
     * <p>
     * Event type name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("event_type")
    @JsonPropertyDescription("Event type name as used during application registration")
    private String eventType;
    /**
     * Sent timestamp
     * <p>
     * ISO-8601 formatted date (per platform convention) when the message was sent in UTC. Dates with timezones/offsets are rejected.
     * (Required)
     * 
     */
    @JsonProperty("timestamp")
    @JsonPropertyDescription("ISO-8601 formatted date (per platform convention) when the message was sent in UTC. Dates with timezones/offsets are rejected.")
    private LocalDateTime timestamp;
    /**
     * Account id
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("account_id")
    private String accountId;
    /**
     * Organization id
     * <p>
     * 
     * 
     */
    @JsonProperty("org_id")
    private String orgId;
    /**
     * Context
     * <p>
     * Extra information common to all events sent.
     * 
     */
    @JsonProperty("context")
    @JsonPropertyDescription("Extra information common to all events sent.")
    private Context context;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("events")
    private List<Event> events = new ArrayList<Event>();
    /**
     * Applications can add extra email recipients by adding entries to this array. This setting extends whatever the Administrators configured in their Notifications settings. This won't override notification's administrator settings - this will extend the settings.
     * 
     */
    @JsonProperty("recipients")
    @JsonPropertyDescription("Applications can add extra email recipients by adding entries to this array. This setting extends whatever the Administrators configured in their Notifications settings. This won't override notification's administrator settings - this will extend the settings.")
    private List<Recipient> recipients = new ArrayList<Recipient>();

    /**
     * Version of the notification schema
     * <p>
     * 
     * 
     */
    @JsonProperty("version")
    public String getVersion() {
        return version;
    }

    /**
     * Version of the notification schema
     * <p>
     * 
     * 
     */
    @JsonProperty("version")
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * Bundle name
     * <p>
     * Bundle name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("bundle")
    public String getBundle() {
        return bundle;
    }

    /**
     * Bundle name
     * <p>
     * Bundle name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("bundle")
    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    /**
     * Application name
     * <p>
     * Application name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("application")
    public String getApplication() {
        return application;
    }

    /**
     * Application name
     * <p>
     * Application name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("application")
    public void setApplication(String application) {
        this.application = application;
    }

    /**
     * Event type name
     * <p>
     * Event type name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("event_type")
    public String getEventType() {
        return eventType;
    }

    /**
     * Event type name
     * <p>
     * Event type name as used during application registration
     * (Required)
     * 
     */
    @JsonProperty("event_type")
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    /**
     * Sent timestamp
     * <p>
     * ISO-8601 formatted date (per platform convention) when the message was sent in UTC. Dates with timezones/offsets are rejected.
     * (Required)
     * 
     */
    @JsonProperty("timestamp")
    public LocalDateTime getTimestamp() {
        return timestamp;
    }

    /**
     * Sent timestamp
     * <p>
     * ISO-8601 formatted date (per platform convention) when the message was sent in UTC. Dates with timezones/offsets are rejected.
     * (Required)
     * 
     */
    @JsonProperty("timestamp")
    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * Account id
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    /**
     * Account id
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("account_id")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * Organization id
     * <p>
     * 
     * 
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    /**
     * Organization id
     * <p>
     * 
     * 
     */
    @JsonProperty("org_id")
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    /**
     * Context
     * <p>
     * Extra information common to all events sent.
     * 
     */
    @JsonProperty("context")
    public Context getContext() {
        return context;
    }

    /**
     * Context
     * <p>
     * Extra information common to all events sent.
     * 
     */
    @JsonProperty("context")
    public void setContext(Context context) {
        this.context = context;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("events")
    public List<Event> getEvents() {
        return events;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("events")
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    /**
     * Applications can add extra email recipients by adding entries to this array. This setting extends whatever the Administrators configured in their Notifications settings. This won't override notification's administrator settings - this will extend the settings.
     * 
     */
    @JsonProperty("recipients")
    public List<Recipient> getRecipients() {
        return recipients;
    }

    /**
     * Applications can add extra email recipients by adding entries to this array. This setting extends whatever the Administrators configured in their Notifications settings. This won't override notification's administrator settings - this will extend the settings.
     * 
     */
    @JsonProperty("recipients")
    public void setRecipients(List<Recipient> recipients) {
        this.recipients = recipients;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Action.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("bundle");
        sb.append('=');
        sb.append(((this.bundle == null)?"<null>":this.bundle));
        sb.append(',');
        sb.append("application");
        sb.append('=');
        sb.append(((this.application == null)?"<null>":this.application));
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(((this.eventType == null)?"<null>":this.eventType));
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(((this.timestamp == null)?"<null>":this.timestamp));
        sb.append(',');
        sb.append("accountId");
        sb.append('=');
        sb.append(((this.accountId == null)?"<null>":this.accountId));
        sb.append(',');
        sb.append("orgId");
        sb.append('=');
        sb.append(((this.orgId == null)?"<null>":this.orgId));
        sb.append(',');
        sb.append("context");
        sb.append('=');
        sb.append(((this.context == null)?"<null>":this.context));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("recipients");
        sb.append('=');
        sb.append(((this.recipients == null)?"<null>":this.recipients));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.accountId == null)? 0 :this.accountId.hashCode()));
        result = ((result* 31)+((this.application == null)? 0 :this.application.hashCode()));
        result = ((result* 31)+((this.recipients == null)? 0 :this.recipients.hashCode()));
        result = ((result* 31)+((this.context == null)? 0 :this.context.hashCode()));
        result = ((result* 31)+((this.eventType == null)? 0 :this.eventType.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        result = ((result* 31)+((this.bundle == null)? 0 :this.bundle.hashCode()));
        result = ((result* 31)+((this.orgId == null)? 0 :this.orgId.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.timestamp == null)? 0 :this.timestamp.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Action) == false) {
            return false;
        }
        Action rhs = ((Action) other);
        return (((((((((((this.accountId == rhs.accountId)||((this.accountId!= null)&&this.accountId.equals(rhs.accountId)))&&((this.application == rhs.application)||((this.application!= null)&&this.application.equals(rhs.application))))&&((this.recipients == rhs.recipients)||((this.recipients!= null)&&this.recipients.equals(rhs.recipients))))&&((this.context == rhs.context)||((this.context!= null)&&this.context.equals(rhs.context))))&&((this.eventType == rhs.eventType)||((this.eventType!= null)&&this.eventType.equals(rhs.eventType))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))))&&((this.bundle == rhs.bundle)||((this.bundle!= null)&&this.bundle.equals(rhs.bundle))))&&((this.orgId == rhs.orgId)||((this.orgId!= null)&&this.orgId.equals(rhs.orgId))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.timestamp == rhs.timestamp)||((this.timestamp!= null)&&this.timestamp.equals(rhs.timestamp))));
    }

    public static class ActionBuilder
        extends Action.ActionBuilderBase<Action>
    {


        public ActionBuilder() {
            super();
        }

    }

    public static abstract class ActionBuilderBase<T extends Action >{

        protected T instance;

        @SuppressWarnings("unchecked")
        public ActionBuilderBase() {
            // Skip initialization when called from subclass
            if (this.getClass().equals(Action.ActionBuilder.class)) {
                this.instance = ((T) new Action());
            }
        }

        public T build() {
            T result;
            result = this.instance;
            this.instance = null;
            return result;
        }

        public Action.ActionBuilderBase withVersion(String version) {
            ((Action) this.instance).version = version;
            return this;
        }

        public Action.ActionBuilderBase withBundle(String bundle) {
            ((Action) this.instance).bundle = bundle;
            return this;
        }

        public Action.ActionBuilderBase withApplication(String application) {
            ((Action) this.instance).application = application;
            return this;
        }

        public Action.ActionBuilderBase withEventType(String eventType) {
            ((Action) this.instance).eventType = eventType;
            return this;
        }

        public Action.ActionBuilderBase withTimestamp(LocalDateTime timestamp) {
            ((Action) this.instance).timestamp = timestamp;
            return this;
        }

        public Action.ActionBuilderBase withAccountId(String accountId) {
            ((Action) this.instance).accountId = accountId;
            return this;
        }

        public Action.ActionBuilderBase withOrgId(String orgId) {
            ((Action) this.instance).orgId = orgId;
            return this;
        }

        public Action.ActionBuilderBase withContext(Context context) {
            ((Action) this.instance).context = context;
            return this;
        }

        public Action.ActionBuilderBase withEvents(List<Event> events) {
            ((Action) this.instance).events = events;
            return this;
        }

        public Action.ActionBuilderBase withRecipients(List<Recipient> recipients) {
            ((Action) this.instance).recipients = recipients;
            return this;
        }

    }

}
