
package com.redhat.cloud.notifications.ingress;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "only_admins",
    "ignore_user_preferences",
    "users",
    "groups"
})
@Generated("jsonschema2pojo")
public class Recipient {

    /**
     * Only admins
     * <p>
     * Setting to true sends an email to the administrators of the account. Setting to false sends an email to all users of the account. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("only_admins")
    @JsonPropertyDescription("Setting to true sends an email to the administrators of the account. Setting to false sends an email to all users of the account. Note that this does not ignore the user preferences.")
    private Boolean onlyAdmins = false;
    /**
     * Ignore user preferences
     * <p>
     * Setting to true ignores all the user preferences on this Recipient setting (It doesn't affect other configuration that an Administrator sets on their Notification settings). Setting to false (default) honors the user preferences.
     * 
     */
    @JsonProperty("ignore_user_preferences")
    @JsonPropertyDescription("Setting to true ignores all the user preferences on this Recipient setting (It doesn't affect other configuration that an Administrator sets on their Notification settings). Setting to false (default) honors the user preferences.")
    private Boolean ignoreUserPreferences = false;
    /**
     * Users
     * <p>
     * List of users to direct the notification to. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("users")
    @JsonPropertyDescription("List of users to direct the notification to. Note that this does not ignore the user preferences.")
    private List<String> users = new ArrayList<String>();
    /**
     * Groups
     * <p>
     * List of group ids to direct the notification to. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("groups")
    @JsonPropertyDescription("List of group ids to direct the notification to. Note that this does not ignore the user preferences.")
    private List<String> groups = new ArrayList<String>();

    /**
     * Only admins
     * <p>
     * Setting to true sends an email to the administrators of the account. Setting to false sends an email to all users of the account. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("only_admins")
    public Boolean getOnlyAdmins() {
        return onlyAdmins;
    }

    /**
     * Only admins
     * <p>
     * Setting to true sends an email to the administrators of the account. Setting to false sends an email to all users of the account. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("only_admins")
    public void setOnlyAdmins(Boolean onlyAdmins) {
        this.onlyAdmins = onlyAdmins;
    }

    /**
     * Ignore user preferences
     * <p>
     * Setting to true ignores all the user preferences on this Recipient setting (It doesn't affect other configuration that an Administrator sets on their Notification settings). Setting to false (default) honors the user preferences.
     * 
     */
    @JsonProperty("ignore_user_preferences")
    public Boolean getIgnoreUserPreferences() {
        return ignoreUserPreferences;
    }

    /**
     * Ignore user preferences
     * <p>
     * Setting to true ignores all the user preferences on this Recipient setting (It doesn't affect other configuration that an Administrator sets on their Notification settings). Setting to false (default) honors the user preferences.
     * 
     */
    @JsonProperty("ignore_user_preferences")
    public void setIgnoreUserPreferences(Boolean ignoreUserPreferences) {
        this.ignoreUserPreferences = ignoreUserPreferences;
    }

    /**
     * Users
     * <p>
     * List of users to direct the notification to. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("users")
    public List<String> getUsers() {
        return users;
    }

    /**
     * Users
     * <p>
     * List of users to direct the notification to. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("users")
    public void setUsers(List<String> users) {
        this.users = users;
    }

    /**
     * Groups
     * <p>
     * List of group ids to direct the notification to. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("groups")
    public List<String> getGroups() {
        return groups;
    }

    /**
     * Groups
     * <p>
     * List of group ids to direct the notification to. Note that this does not ignore the user preferences.
     * 
     */
    @JsonProperty("groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Recipient.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("onlyAdmins");
        sb.append('=');
        sb.append(((this.onlyAdmins == null)?"<null>":this.onlyAdmins));
        sb.append(',');
        sb.append("ignoreUserPreferences");
        sb.append('=');
        sb.append(((this.ignoreUserPreferences == null)?"<null>":this.ignoreUserPreferences));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("groups");
        sb.append('=');
        sb.append(((this.groups == null)?"<null>":this.groups));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.onlyAdmins == null)? 0 :this.onlyAdmins.hashCode()));
        result = ((result* 31)+((this.groups == null)? 0 :this.groups.hashCode()));
        result = ((result* 31)+((this.ignoreUserPreferences == null)? 0 :this.ignoreUserPreferences.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Recipient) == false) {
            return false;
        }
        Recipient rhs = ((Recipient) other);
        return (((((this.onlyAdmins == rhs.onlyAdmins)||((this.onlyAdmins!= null)&&this.onlyAdmins.equals(rhs.onlyAdmins)))&&((this.groups == rhs.groups)||((this.groups!= null)&&this.groups.equals(rhs.groups))))&&((this.ignoreUserPreferences == rhs.ignoreUserPreferences)||((this.ignoreUserPreferences!= null)&&this.ignoreUserPreferences.equals(rhs.ignoreUserPreferences))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))));
    }

    public static class RecipientBuilder
        extends Recipient.RecipientBuilderBase<Recipient>
    {


        public RecipientBuilder() {
            super();
        }

    }

    public static abstract class RecipientBuilderBase<T extends Recipient >{

        protected T instance;

        @SuppressWarnings("unchecked")
        public RecipientBuilderBase() {
            // Skip initialization when called from subclass
            if (this.getClass().equals(Recipient.RecipientBuilder.class)) {
                this.instance = ((T) new Recipient());
            }
        }

        public T build() {
            T result;
            result = this.instance;
            this.instance = null;
            return result;
        }

        public Recipient.RecipientBuilderBase withOnlyAdmins(Boolean onlyAdmins) {
            ((Recipient) this.instance).onlyAdmins = onlyAdmins;
            return this;
        }

        public Recipient.RecipientBuilderBase withIgnoreUserPreferences(Boolean ignoreUserPreferences) {
            ((Recipient) this.instance).ignoreUserPreferences = ignoreUserPreferences;
            return this;
        }

        public Recipient.RecipientBuilderBase withUsers(List<String> users) {
            ((Recipient) this.instance).users = users;
            return this;
        }

        public Recipient.RecipientBuilderBase withGroups(List<String> groups) {
            ((Recipient) this.instance).groups = groups;
            return this;
        }

    }

}
