/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.event.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.networknt.schema.ApplyDefaultsStrategy;
import com.networknt.schema.Format;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.NonValidationKeyword;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.uri.URIFactory;
import com.networknt.schema.uri.URLFactory;
import com.redhat.cloud.event.core.v1.RHELSystem;
import com.redhat.cloud.event.parser.ConsoleCloudEvent;
import com.redhat.cloud.event.parser.GenericConsoleCloudEvent;
import com.redhat.cloud.event.parser.exceptions.ConsoleCloudEventParsingException;
import com.redhat.cloud.event.parser.exceptions.ConsoleCloudEventValidationException;
import com.redhat.cloud.event.parser.modules.LocalDateTimeModule;
import com.redhat.cloud.event.parser.modules.OffsetDateTimeModule;
import com.redhat.cloud.event.parser.validators.LocalDateTimeValidator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;

public class ConsoleCloudEventParser {
    private static final String schemaPath = "/schemas/events/v1/events.json";
    ObjectMapper objectMapper;
    JsonSchema jsonSchema;

    public ConsoleCloudEventParser() {
        this(ConsoleCloudEventParser.buildObjectMapper());
    }

    public ConsoleCloudEventParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.jsonSchema = this.getJsonSchema();
    }

    public ConsoleCloudEvent fromJsonString(String cloudEventJson) {
        ConsoleCloudEvent consoleCloudEvent = this.fromJsonString(cloudEventJson, ConsoleCloudEvent.class);
        consoleCloudEvent.setObjectMapper(this.objectMapper);
        return consoleCloudEvent;
    }

    public void validate(String cloudEventJson) {
        try {
            JsonNode cloudEvent = this.objectMapper.readTree(cloudEventJson);
            ConsoleCloudEventParser.validate(cloudEvent, this.jsonSchema);
        }
        catch (JsonProcessingException jpe) {
            throw new ConsoleCloudEventParsingException("Cloud event validation failed for: " + cloudEventJson, jpe);
        }
    }

    public <T extends GenericConsoleCloudEvent<?>> T fromJsonString(String cloudEventJson, Class<T> consoleCloudEventClass) {
        try {
            JsonNode cloudEvent = this.objectMapper.readTree(cloudEventJson);
            ConsoleCloudEventParser.validate(cloudEvent, this.jsonSchema);
            GenericConsoleCloudEvent genericCloudEvent = (GenericConsoleCloudEvent)this.objectMapper.treeToValue((TreeNode)cloudEvent, consoleCloudEventClass);
            if (genericCloudEvent instanceof ConsoleCloudEvent) {
                ConsoleCloudEvent consoleCloudEvent = (ConsoleCloudEvent)genericCloudEvent;
                consoleCloudEvent.setObjectMapper(this.objectMapper);
            }
            return (T)genericCloudEvent;
        }
        catch (JsonProcessingException jpe) {
            throw new ConsoleCloudEventParsingException("Cloud event parsing failed for: " + cloudEventJson, jpe);
        }
    }

    public String toJson(GenericConsoleCloudEvent<?> consoleCloudEvent) {
        try {
            JsonNode node = this.objectMapper.valueToTree(consoleCloudEvent);
            ConsoleCloudEventParser.validate(node, this.jsonSchema);
            return this.objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException jpe) {
            throw new ConsoleCloudEventParsingException("Cloud event serialization failed consoleCloudEvent: " + consoleCloudEvent, jpe);
        }
    }

    public static ObjectMapper buildObjectMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new OffsetDateTimeModule()).registerModule((Module)new LocalDateTimeModule());
    }

    private JsonSchema getJsonSchema() {
        JsonSchema jsonSchema;
        block8: {
            SchemaValidatorsConfig schemaValidatorsConfig = new SchemaValidatorsConfig();
            schemaValidatorsConfig.setApplyDefaultsStrategy(new ApplyDefaultsStrategy(true, true, true));
            InputStream jsonSchemaStream = RHELSystem.class.getResourceAsStream(schemaPath);
            try {
                JsonNode schema = this.objectMapper.readTree(jsonSchemaStream);
                jsonSchema = ConsoleCloudEventParser.jsonSchemaFactory().getSchema(schema, schemaValidatorsConfig);
                if (jsonSchemaStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonSchemaStream != null) {
                        try {
                            jsonSchemaStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new JsonSchemaException((Throwable)ioe);
                }
            }
            jsonSchemaStream.close();
        }
        return jsonSchema;
    }

    private static void validate(JsonNode cloudEvent, JsonSchema jsonSchema) {
        ValidationResult result = jsonSchema.walk(cloudEvent, true);
        if (result.getValidationMessages().size() > 0) {
            throw new ConsoleCloudEventValidationException("Cloud event validation failed for: " + cloudEvent, result.getValidationMessages());
        }
    }

    private static JsonSchemaFactory jsonSchemaFactory() {
        String ID = "$id";
        JsonMetaSchema overrideDateTimeValidator = new JsonMetaSchema.Builder(JsonMetaSchema.getV7().getUri()).idKeyword(ID).addKeywords((Collection)ValidatorTypeCode.getNonFormatKeywords((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7)).addKeywords(List.of(new NonValidationKeyword("examples"), new NonValidationKeyword("$schema"), new NonValidationKeyword("definitions"), new NonValidationKeyword(ID), new NonValidationKeyword("title"), new NonValidationKeyword("description"), new NonValidationKeyword("contentEncoding"))).addFormats((Collection)JsonMetaSchema.COMMON_BUILTIN_FORMATS).addFormat((Format)new LocalDateTimeValidator()).build();
        return new JsonSchemaFactory.Builder().defaultMetaSchemaURI(overrideDateTimeValidator.getUri()).addMetaSchema(overrideDateTimeValidator).uriFactory((URIFactory)new CloudEventURIFactory(), new String[]{"https"}).build();
    }

    static class CloudEventURIFactory
    implements URIFactory {
        private static final String baseUrl = "https://console.redhat.com/api";
        private final URLFactory urlFactory = new URLFactory();
        private final String base;

        CloudEventURIFactory() {
            String fullPath = RHELSystem.class.getResource(ConsoleCloudEventParser.schemaPath).toString();
            this.base = fullPath.substring(0, fullPath.length() - ConsoleCloudEventParser.schemaPath.length());
        }

        public URI create(String uri) {
            return this.urlFactory.create(this.replaceBase(uri));
        }

        public URI create(URI baseURI, String segment) {
            return this.urlFactory.create(URI.create(this.replaceBase(baseURI.toString())), segment);
        }

        private String replaceBase(String uri) {
            if (((String)uri).startsWith(baseUrl)) {
                uri = this.base + ((String)uri).substring(baseUrl.length(), ((String)uri).length() - 1);
            }
            return uri;
        }
    }
}

