/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.event.parser.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.redhat.cloud.event.parser.modules.Constants;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class LocalDateTimeModule
extends SimpleModule {
    public LocalDateTimeModule() {
        this.addDeserializer(LocalDateTime.class, new LocalDateTimeDeserializer());
        this.addSerializer(LocalDateTime.class, new LocalDateTimeSerializer());
    }

    private static class LocalDateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        private LocalDateTimeDeserializer() {
        }

        public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasTokenId(6)) {
                return LocalDateTime.parse(jsonParser.getText(), Constants.dateTimeFormatterWriter);
            }
            return (LocalDateTime)deserializationContext.handleUnexpectedToken(LocalDateTime.class, jsonParser);
        }
    }

    private static class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
        }

        public void serialize(LocalDateTime dateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(dateTime.atZone(ZoneOffset.UTC).format(Constants.dateTimeFormatterReader));
        }
    }
}

