/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.event.parser.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.redhat.cloud.event.parser.modules.Constants;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class OffsetDateTimeModule
extends SimpleModule {
    public OffsetDateTimeModule() {
        this.addDeserializer(OffsetDateTime.class, new OffsetDateTimeDeserializer());
        this.addSerializer(OffsetDateTime.class, new OffsetDateTimeSerializer());
    }

    private static class OffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeDeserializer() {
        }

        public OffsetDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasTokenId(6)) {
                LocalDateTime localDateTime = LocalDateTime.parse(jsonParser.getText(), Constants.dateTimeFormatterWriter);
                return localDateTime.atOffset(ZoneOffset.UTC);
            }
            return (OffsetDateTime)deserializationContext.handleUnexpectedToken(OffsetDateTime.class, jsonParser);
        }
    }

    private static class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeSerializer() {
        }

        public void serialize(OffsetDateTime dateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(dateTime.format(Constants.dateTimeFormatterReader));
        }
    }
}

