/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.LicenseData;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class LicenseData_Usage_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private int repos;
    private int users;
    private int teams;
    private int scans;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    LicenseData_Usage_Builder() {
    }

    public static LicenseData.Usage.Builder from(LicenseData.Usage value) {
        return new LicenseData.Usage.Builder().mergeFrom(value);
    }

    @JsonProperty(value="repos")
    public LicenseData.Usage.Builder setRepos(int repos) {
        this.repos = repos;
        this._unsetProperties.remove((Object)Property.REPOS);
        return (LicenseData.Usage.Builder)this;
    }

    public LicenseData.Usage.Builder mapRepos(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setRepos((Integer)mapper.apply(this.getRepos()));
    }

    public int getRepos() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.REPOS) ? 1 : 0) != 0, (Object)"repos not set");
        return this.repos;
    }

    @JsonProperty(value="users")
    public LicenseData.Usage.Builder setUsers(int users) {
        this.users = users;
        this._unsetProperties.remove((Object)Property.USERS);
        return (LicenseData.Usage.Builder)this;
    }

    public LicenseData.Usage.Builder mapUsers(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setUsers((Integer)mapper.apply(this.getUsers()));
    }

    public int getUsers() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.USERS) ? 1 : 0) != 0, (Object)"users not set");
        return this.users;
    }

    @JsonProperty(value="teams")
    public LicenseData.Usage.Builder setTeams(int teams) {
        this.teams = teams;
        this._unsetProperties.remove((Object)Property.TEAMS);
        return (LicenseData.Usage.Builder)this;
    }

    public LicenseData.Usage.Builder mapTeams(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setTeams((Integer)mapper.apply(this.getTeams()));
    }

    public int getTeams() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TEAMS) ? 1 : 0) != 0, (Object)"teams not set");
        return this.teams;
    }

    @JsonProperty(value="scans")
    public LicenseData.Usage.Builder setScans(int scans) {
        this.scans = scans;
        this._unsetProperties.remove((Object)Property.SCANS);
        return (LicenseData.Usage.Builder)this;
    }

    public LicenseData.Usage.Builder mapScans(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setScans((Integer)mapper.apply(this.getScans()));
    }

    public int getScans() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SCANS) ? 1 : 0) != 0, (Object)"scans not set");
        return this.scans;
    }

    public LicenseData.Usage.Builder mergeFrom(LicenseData.Usage value) {
        LicenseData.Usage.Builder _defaults = new LicenseData.Usage.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.REPOS) || !Objects.equals(value.getRepos(), ((LicenseData_Usage_Builder)_defaults).getRepos())) {
            this.setRepos(value.getRepos());
        }
        if (_defaults._unsetProperties.contains((Object)Property.USERS) || !Objects.equals(value.getUsers(), ((LicenseData_Usage_Builder)_defaults).getUsers())) {
            this.setUsers(value.getUsers());
        }
        if (_defaults._unsetProperties.contains((Object)Property.TEAMS) || !Objects.equals(value.getTeams(), ((LicenseData_Usage_Builder)_defaults).getTeams())) {
            this.setTeams(value.getTeams());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SCANS) || !Objects.equals(value.getScans(), ((LicenseData_Usage_Builder)_defaults).getScans())) {
            this.setScans(value.getScans());
        }
        return (LicenseData.Usage.Builder)this;
    }

    public LicenseData.Usage.Builder mergeFrom(LicenseData.Usage.Builder template) {
        LicenseData.Usage.Builder base = template;
        LicenseData.Usage.Builder _defaults = new LicenseData.Usage.Builder();
        if (!(base._unsetProperties.contains((Object)Property.REPOS) || !_defaults._unsetProperties.contains((Object)Property.REPOS) && Objects.equals(template.getRepos(), ((LicenseData_Usage_Builder)_defaults).getRepos()))) {
            this.setRepos(template.getRepos());
        }
        if (!(base._unsetProperties.contains((Object)Property.USERS) || !_defaults._unsetProperties.contains((Object)Property.USERS) && Objects.equals(template.getUsers(), ((LicenseData_Usage_Builder)_defaults).getUsers()))) {
            this.setUsers(template.getUsers());
        }
        if (!(base._unsetProperties.contains((Object)Property.TEAMS) || !_defaults._unsetProperties.contains((Object)Property.TEAMS) && Objects.equals(template.getTeams(), ((LicenseData_Usage_Builder)_defaults).getTeams()))) {
            this.setTeams(template.getTeams());
        }
        if (!(base._unsetProperties.contains((Object)Property.SCANS) || !_defaults._unsetProperties.contains((Object)Property.SCANS) && Objects.equals(template.getScans(), ((LicenseData_Usage_Builder)_defaults).getScans()))) {
            this.setScans(template.getScans());
        }
        return (LicenseData.Usage.Builder)this;
    }

    public LicenseData.Usage.Builder clear() {
        LicenseData.Usage.Builder _defaults = new LicenseData.Usage.Builder();
        this.repos = _defaults.repos;
        this.users = _defaults.users;
        this.teams = _defaults.teams;
        this.scans = _defaults.scans;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (LicenseData.Usage.Builder)this;
    }

    public LicenseData.Usage build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public LicenseData.Usage buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends LicenseData.Usage {
        private final int repos;
        private final int users;
        private final int teams;
        private final int scans;
        private final EnumSet<Property> _unsetProperties;

        Partial(LicenseData_Usage_Builder builder) {
            this.repos = builder.repos;
            this.users = builder.users;
            this.teams = builder.teams;
            this.scans = builder.scans;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="repos")
        public int getRepos() {
            if (this._unsetProperties.contains((Object)Property.REPOS)) {
                throw new UnsupportedOperationException("repos not set");
            }
            return this.repos;
        }

        @Override
        @JsonProperty(value="users")
        public int getUsers() {
            if (this._unsetProperties.contains((Object)Property.USERS)) {
                throw new UnsupportedOperationException("users not set");
            }
            return this.users;
        }

        @Override
        @JsonProperty(value="teams")
        public int getTeams() {
            if (this._unsetProperties.contains((Object)Property.TEAMS)) {
                throw new UnsupportedOperationException("teams not set");
            }
            return this.teams;
        }

        @Override
        @JsonProperty(value="scans")
        public int getScans() {
            if (this._unsetProperties.contains((Object)Property.SCANS)) {
                throw new UnsupportedOperationException("scans not set");
            }
            return this.scans;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.repos, other.repos) && Objects.equals(this.users, other.users) && Objects.equals(this.teams, other.teams) && Objects.equals(this.scans, other.scans) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.repos, this.users, this.teams, this.scans, this._unsetProperties);
        }

        public String toString() {
            return "partial Usage{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.REPOS) ? "repos=" + this.repos : null), (Object)(!this._unsetProperties.contains((Object)Property.USERS) ? "users=" + this.users : null), new Object[]{!this._unsetProperties.contains((Object)Property.TEAMS) ? "teams=" + this.teams : null, !this._unsetProperties.contains((Object)Property.SCANS) ? "scans=" + this.scans : null}) + "}";
        }
    }

    private static final class Value
    extends LicenseData.Usage {
        private final int repos;
        private final int users;
        private final int teams;
        private final int scans;

        private Value(LicenseData_Usage_Builder builder) {
            this.repos = builder.repos;
            this.users = builder.users;
            this.teams = builder.teams;
            this.scans = builder.scans;
        }

        @Override
        @JsonProperty(value="repos")
        public int getRepos() {
            return this.repos;
        }

        @Override
        @JsonProperty(value="users")
        public int getUsers() {
            return this.users;
        }

        @Override
        @JsonProperty(value="teams")
        public int getTeams() {
            return this.teams;
        }

        @Override
        @JsonProperty(value="scans")
        public int getScans() {
            return this.scans;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.repos, other.repos) && Objects.equals(this.users, other.users) && Objects.equals(this.teams, other.teams) && Objects.equals(this.scans, other.scans);
        }

        public int hashCode() {
            return Objects.hash(this.repos, this.users, this.teams, this.scans);
        }

        public String toString() {
            return "Usage{repos=" + this.repos + ", users=" + this.users + ", teams=" + this.teams + ", scans=" + this.scans + "}";
        }
    }

    private static enum Property {
        REPOS("repos"),
        USERS("users"),
        TEAMS("teams"),
        SCANS("scans");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

