/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.analytics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.analytics.CollectorData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import javax.annotation.Nullable;

abstract class AgentRuntimeData_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private List<CollectorData> collectorsRun = ImmutableList.of();
    private List<CollectorData> unsupportedBuildSystems = ImmutableList.of();
    private String scanAttributesJSON;
    private String agentType;
    private String agentVersion;
    private String OS;
    private String OSVersion;
    private String JVMVersion;
    private boolean quickScan;
    private boolean recursiveScan;
    @Nullable
    private String scanErrorMessage = null;

    AgentRuntimeData_Builder() {
    }

    public static AgentRuntimeData.Builder from(AgentRuntimeData value) {
        return new AgentRuntimeData.Builder().mergeFrom(value);
    }

    public AgentRuntimeData.Builder addCollectorsRun(CollectorData element) {
        if (this.collectorsRun instanceof ImmutableList) {
            this.collectorsRun = new ArrayList<CollectorData>(this.collectorsRun);
        }
        this.collectorsRun.add((CollectorData)Preconditions.checkNotNull((Object)element));
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addCollectorsRun(CollectorData ... elements) {
        return this.addAllCollectorsRun(Arrays.asList(elements));
    }

    public AgentRuntimeData.Builder addAllCollectorsRun(Spliterator<? extends CollectorData> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.collectorsRun instanceof ImmutableList) {
                this.collectorsRun = new ArrayList<CollectorData>(this.collectorsRun);
            }
            ((ArrayList)this.collectorsRun).ensureCapacity(this.collectorsRun.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addCollectorsRun);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addAllCollectorsRun(BaseStream<? extends CollectorData, ?> elements) {
        return this.addAllCollectorsRun(elements.spliterator());
    }

    @JsonProperty(value="collectorsRun")
    public AgentRuntimeData.Builder addAllCollectorsRun(Iterable<? extends CollectorData> elements) {
        return this.addAllCollectorsRun(elements.spliterator());
    }

    public AgentRuntimeData.Builder mutateCollectorsRun(Consumer<? super List<CollectorData>> mutator) {
        if (this.collectorsRun instanceof ImmutableList) {
            this.collectorsRun = new ArrayList<CollectorData>(this.collectorsRun);
        }
        mutator.accept(this.collectorsRun);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder clearCollectorsRun() {
        if (this.collectorsRun instanceof ImmutableList) {
            this.collectorsRun = ImmutableList.of();
        } else {
            this.collectorsRun.clear();
        }
        return (AgentRuntimeData.Builder)this;
    }

    public List<CollectorData> getCollectorsRun() {
        if (this.collectorsRun instanceof ImmutableList) {
            this.collectorsRun = new ArrayList<CollectorData>(this.collectorsRun);
        }
        return Collections.unmodifiableList(this.collectorsRun);
    }

    public AgentRuntimeData.Builder addUnsupportedBuildSystems(CollectorData element) {
        if (this.unsupportedBuildSystems instanceof ImmutableList) {
            this.unsupportedBuildSystems = new ArrayList<CollectorData>(this.unsupportedBuildSystems);
        }
        this.unsupportedBuildSystems.add((CollectorData)Preconditions.checkNotNull((Object)element));
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addUnsupportedBuildSystems(CollectorData ... elements) {
        return this.addAllUnsupportedBuildSystems(Arrays.asList(elements));
    }

    public AgentRuntimeData.Builder addAllUnsupportedBuildSystems(Spliterator<? extends CollectorData> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.unsupportedBuildSystems instanceof ImmutableList) {
                this.unsupportedBuildSystems = new ArrayList<CollectorData>(this.unsupportedBuildSystems);
            }
            ((ArrayList)this.unsupportedBuildSystems).ensureCapacity(this.unsupportedBuildSystems.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addUnsupportedBuildSystems);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addAllUnsupportedBuildSystems(BaseStream<? extends CollectorData, ?> elements) {
        return this.addAllUnsupportedBuildSystems(elements.spliterator());
    }

    @JsonProperty(value="unsupportedBuildSystems")
    public AgentRuntimeData.Builder addAllUnsupportedBuildSystems(Iterable<? extends CollectorData> elements) {
        return this.addAllUnsupportedBuildSystems(elements.spliterator());
    }

    public AgentRuntimeData.Builder mutateUnsupportedBuildSystems(Consumer<? super List<CollectorData>> mutator) {
        if (this.unsupportedBuildSystems instanceof ImmutableList) {
            this.unsupportedBuildSystems = new ArrayList<CollectorData>(this.unsupportedBuildSystems);
        }
        mutator.accept(this.unsupportedBuildSystems);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder clearUnsupportedBuildSystems() {
        if (this.unsupportedBuildSystems instanceof ImmutableList) {
            this.unsupportedBuildSystems = ImmutableList.of();
        } else {
            this.unsupportedBuildSystems.clear();
        }
        return (AgentRuntimeData.Builder)this;
    }

    public List<CollectorData> getUnsupportedBuildSystems() {
        if (this.unsupportedBuildSystems instanceof ImmutableList) {
            this.unsupportedBuildSystems = new ArrayList<CollectorData>(this.unsupportedBuildSystems);
        }
        return Collections.unmodifiableList(this.unsupportedBuildSystems);
    }

    @JsonProperty(value="scanAttributesJSON")
    public AgentRuntimeData.Builder setScanAttributesJSON(String scanAttributesJSON) {
        this.scanAttributesJSON = (String)Preconditions.checkNotNull((Object)scanAttributesJSON);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapScanAttributesJSON(UnaryOperator<String> mapper) {
        return this.setScanAttributesJSON((String)mapper.apply(this.getScanAttributesJSON()));
    }

    public String getScanAttributesJSON() {
        return this.scanAttributesJSON;
    }

    @JsonProperty(value="agentType")
    public AgentRuntimeData.Builder setAgentType(String agentType) {
        this.agentType = (String)Preconditions.checkNotNull((Object)agentType);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapAgentType(UnaryOperator<String> mapper) {
        return this.setAgentType((String)mapper.apply(this.getAgentType()));
    }

    public String getAgentType() {
        return this.agentType;
    }

    @JsonProperty(value="agentVersion")
    public AgentRuntimeData.Builder setAgentVersion(String agentVersion) {
        this.agentVersion = (String)Preconditions.checkNotNull((Object)agentVersion);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapAgentVersion(UnaryOperator<String> mapper) {
        return this.setAgentVersion((String)mapper.apply(this.getAgentVersion()));
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    @JsonProperty(value="OS")
    public AgentRuntimeData.Builder setOS(String OS2) {
        this.OS = (String)Preconditions.checkNotNull((Object)OS2);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapOS(UnaryOperator<String> mapper) {
        return this.setOS((String)mapper.apply(this.getOS()));
    }

    public String getOS() {
        return this.OS;
    }

    @JsonProperty(value="OSVersion")
    public AgentRuntimeData.Builder setOSVersion(String OSVersion) {
        this.OSVersion = (String)Preconditions.checkNotNull((Object)OSVersion);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapOSVersion(UnaryOperator<String> mapper) {
        return this.setOSVersion((String)mapper.apply(this.getOSVersion()));
    }

    public String getOSVersion() {
        return this.OSVersion;
    }

    @JsonProperty(value="JVMVersion")
    public AgentRuntimeData.Builder setJVMVersion(String JVMVersion) {
        this.JVMVersion = (String)Preconditions.checkNotNull((Object)JVMVersion);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapJVMVersion(UnaryOperator<String> mapper) {
        return this.setJVMVersion((String)mapper.apply(this.getJVMVersion()));
    }

    public String getJVMVersion() {
        return this.JVMVersion;
    }

    @JsonProperty(value="quickScan")
    public AgentRuntimeData.Builder setQuickScan(boolean quickScan) {
        this.quickScan = quickScan;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapQuickScan(UnaryOperator<Boolean> mapper) {
        return this.setQuickScan((Boolean)mapper.apply(this.isQuickScan()));
    }

    public boolean isQuickScan() {
        return this.quickScan;
    }

    @JsonProperty(value="recursiveScan")
    public AgentRuntimeData.Builder setRecursiveScan(boolean recursiveScan) {
        this.recursiveScan = recursiveScan;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapRecursiveScan(UnaryOperator<Boolean> mapper) {
        return this.setRecursiveScan((Boolean)mapper.apply(this.isRecursiveScan()));
    }

    public boolean isRecursiveScan() {
        return this.recursiveScan;
    }

    @JsonProperty(value="scanErrorMessage")
    public AgentRuntimeData.Builder setScanErrorMessage(@Nullable String scanErrorMessage) {
        this.scanErrorMessage = scanErrorMessage;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapScanErrorMessage(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String scanErrorMessage = this.getScanErrorMessage();
        if (scanErrorMessage != null) {
            this.setScanErrorMessage((String)mapper.apply(scanErrorMessage));
        }
        return (AgentRuntimeData.Builder)this;
    }

    @Nullable
    public String getScanErrorMessage() {
        return this.scanErrorMessage;
    }

    public AgentRuntimeData.Builder mergeFrom(AgentRuntimeData value) {
        AgentRuntimeData.Builder _defaults = new AgentRuntimeData.Builder();
        if (value instanceof Value && this.collectorsRun == ImmutableList.of()) {
            this.collectorsRun = ImmutableList.copyOf(value.getCollectorsRun());
        } else {
            this.addAllCollectorsRun(value.getCollectorsRun());
        }
        if (value instanceof Value && this.unsupportedBuildSystems == ImmutableList.of()) {
            this.unsupportedBuildSystems = ImmutableList.copyOf(value.getUnsupportedBuildSystems());
        } else {
            this.addAllUnsupportedBuildSystems(value.getUnsupportedBuildSystems());
        }
        if (!Objects.equals(value.getScanAttributesJSON(), ((AgentRuntimeData_Builder)_defaults).getScanAttributesJSON())) {
            this.setScanAttributesJSON(value.getScanAttributesJSON());
        }
        if (!Objects.equals(value.getAgentType(), ((AgentRuntimeData_Builder)_defaults).getAgentType())) {
            this.setAgentType(value.getAgentType());
        }
        if (!Objects.equals(value.getAgentVersion(), ((AgentRuntimeData_Builder)_defaults).getAgentVersion())) {
            this.setAgentVersion(value.getAgentVersion());
        }
        if (!Objects.equals(value.getOS(), ((AgentRuntimeData_Builder)_defaults).getOS())) {
            this.setOS(value.getOS());
        }
        if (!Objects.equals(value.getOSVersion(), ((AgentRuntimeData_Builder)_defaults).getOSVersion())) {
            this.setOSVersion(value.getOSVersion());
        }
        if (!Objects.equals(value.getJVMVersion(), ((AgentRuntimeData_Builder)_defaults).getJVMVersion())) {
            this.setJVMVersion(value.getJVMVersion());
        }
        if (!Objects.equals(value.isQuickScan(), ((AgentRuntimeData_Builder)_defaults).isQuickScan())) {
            this.setQuickScan(value.isQuickScan());
        }
        if (!Objects.equals(value.isRecursiveScan(), ((AgentRuntimeData_Builder)_defaults).isRecursiveScan())) {
            this.setRecursiveScan(value.isRecursiveScan());
        }
        if (!Objects.equals(value.getScanErrorMessage(), ((AgentRuntimeData_Builder)_defaults).getScanErrorMessage())) {
            this.setScanErrorMessage(value.getScanErrorMessage());
        }
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mergeFrom(AgentRuntimeData.Builder template) {
        AgentRuntimeData.Builder base = template;
        AgentRuntimeData.Builder _defaults = new AgentRuntimeData.Builder();
        this.addAllCollectorsRun(base.collectorsRun);
        this.addAllUnsupportedBuildSystems(base.unsupportedBuildSystems);
        if (!Objects.equals(template.getScanAttributesJSON(), ((AgentRuntimeData_Builder)_defaults).getScanAttributesJSON())) {
            this.setScanAttributesJSON(template.getScanAttributesJSON());
        }
        if (!Objects.equals(template.getAgentType(), ((AgentRuntimeData_Builder)_defaults).getAgentType())) {
            this.setAgentType(template.getAgentType());
        }
        if (!Objects.equals(template.getAgentVersion(), ((AgentRuntimeData_Builder)_defaults).getAgentVersion())) {
            this.setAgentVersion(template.getAgentVersion());
        }
        if (!Objects.equals(template.getOS(), ((AgentRuntimeData_Builder)_defaults).getOS())) {
            this.setOS(template.getOS());
        }
        if (!Objects.equals(template.getOSVersion(), ((AgentRuntimeData_Builder)_defaults).getOSVersion())) {
            this.setOSVersion(template.getOSVersion());
        }
        if (!Objects.equals(template.getJVMVersion(), ((AgentRuntimeData_Builder)_defaults).getJVMVersion())) {
            this.setJVMVersion(template.getJVMVersion());
        }
        if (!Objects.equals(template.isQuickScan(), ((AgentRuntimeData_Builder)_defaults).isQuickScan())) {
            this.setQuickScan(template.isQuickScan());
        }
        if (!Objects.equals(template.isRecursiveScan(), ((AgentRuntimeData_Builder)_defaults).isRecursiveScan())) {
            this.setRecursiveScan(template.isRecursiveScan());
        }
        if (!Objects.equals(template.getScanErrorMessage(), ((AgentRuntimeData_Builder)_defaults).getScanErrorMessage())) {
            this.setScanErrorMessage(template.getScanErrorMessage());
        }
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder clear() {
        AgentRuntimeData.Builder _defaults = new AgentRuntimeData.Builder();
        this.clearCollectorsRun();
        this.clearUnsupportedBuildSystems();
        this.scanAttributesJSON = _defaults.scanAttributesJSON;
        this.agentType = _defaults.agentType;
        this.agentVersion = _defaults.agentVersion;
        this.OS = _defaults.OS;
        this.OSVersion = _defaults.OSVersion;
        this.JVMVersion = _defaults.JVMVersion;
        this.quickScan = _defaults.quickScan;
        this.recursiveScan = _defaults.recursiveScan;
        this.scanErrorMessage = _defaults.scanErrorMessage;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData build() {
        return new Value(this);
    }

    @VisibleForTesting
    public AgentRuntimeData buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements AgentRuntimeData {
        private final List<CollectorData> collectorsRun;
        private final List<CollectorData> unsupportedBuildSystems;
        private final String scanAttributesJSON;
        private final String agentType;
        private final String agentVersion;
        private final String OS;
        private final String OSVersion;
        private final String JVMVersion;
        private final boolean quickScan;
        private final boolean recursiveScan;
        @Nullable
        private final String scanErrorMessage;

        Partial(AgentRuntimeData_Builder builder) {
            this.collectorsRun = ImmutableList.copyOf((Collection)builder.collectorsRun);
            this.unsupportedBuildSystems = ImmutableList.copyOf((Collection)builder.unsupportedBuildSystems);
            this.scanAttributesJSON = builder.scanAttributesJSON;
            this.agentType = builder.agentType;
            this.agentVersion = builder.agentVersion;
            this.OS = builder.OS;
            this.OSVersion = builder.OSVersion;
            this.JVMVersion = builder.JVMVersion;
            this.quickScan = builder.quickScan;
            this.recursiveScan = builder.recursiveScan;
            this.scanErrorMessage = builder.scanErrorMessage;
        }

        @Override
        @JsonProperty(value="collectorsRun")
        public List<CollectorData> getCollectorsRun() {
            return this.collectorsRun;
        }

        @Override
        @JsonProperty(value="unsupportedBuildSystems")
        public List<CollectorData> getUnsupportedBuildSystems() {
            return this.unsupportedBuildSystems;
        }

        @Override
        @JsonProperty(value="scanAttributesJSON")
        public String getScanAttributesJSON() {
            return this.scanAttributesJSON;
        }

        @Override
        @JsonProperty(value="agentType")
        public String getAgentType() {
            return this.agentType;
        }

        @Override
        @JsonProperty(value="agentVersion")
        public String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        @JsonProperty(value="OS")
        public String getOS() {
            return this.OS;
        }

        @Override
        @JsonProperty(value="OSVersion")
        public String getOSVersion() {
            return this.OSVersion;
        }

        @Override
        @JsonProperty(value="JVMVersion")
        public String getJVMVersion() {
            return this.JVMVersion;
        }

        @Override
        @JsonProperty(value="quickScan")
        public boolean isQuickScan() {
            return this.quickScan;
        }

        @Override
        @JsonProperty(value="recursiveScan")
        public boolean isRecursiveScan() {
            return this.recursiveScan;
        }

        @Override
        @JsonProperty(value="scanErrorMessage")
        @Nullable
        public String getScanErrorMessage() {
            return this.scanErrorMessage;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.collectorsRun, other.collectorsRun) && Objects.equals(this.unsupportedBuildSystems, other.unsupportedBuildSystems) && Objects.equals(this.scanAttributesJSON, other.scanAttributesJSON) && Objects.equals(this.agentType, other.agentType) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.OS, other.OS) && Objects.equals(this.OSVersion, other.OSVersion) && Objects.equals(this.JVMVersion, other.JVMVersion) && Objects.equals(this.quickScan, other.quickScan) && Objects.equals(this.recursiveScan, other.recursiveScan) && Objects.equals(this.scanErrorMessage, other.scanErrorMessage);
        }

        public int hashCode() {
            return Objects.hash(this.collectorsRun, this.unsupportedBuildSystems, this.scanAttributesJSON, this.agentType, this.agentVersion, this.OS, this.OSVersion, this.JVMVersion, this.quickScan, this.recursiveScan, this.scanErrorMessage);
        }

        public String toString() {
            return "partial AgentRuntimeData{" + COMMA_JOINER.join((Object)("collectorsRun=" + this.collectorsRun), (Object)("unsupportedBuildSystems=" + this.unsupportedBuildSystems), new Object[]{"scanAttributesJSON=" + this.scanAttributesJSON, "agentType=" + this.agentType, "agentVersion=" + this.agentVersion, "OS=" + this.OS, "OSVersion=" + this.OSVersion, "JVMVersion=" + this.JVMVersion, "quickScan=" + this.quickScan, "recursiveScan=" + this.recursiveScan, this.scanErrorMessage != null ? "scanErrorMessage=" + this.scanErrorMessage : null}) + "}";
        }
    }

    private static final class Value
    implements AgentRuntimeData {
        private final List<CollectorData> collectorsRun;
        private final List<CollectorData> unsupportedBuildSystems;
        private final String scanAttributesJSON;
        private final String agentType;
        private final String agentVersion;
        private final String OS;
        private final String OSVersion;
        private final String JVMVersion;
        private final boolean quickScan;
        private final boolean recursiveScan;
        @Nullable
        private final String scanErrorMessage;

        private Value(AgentRuntimeData_Builder builder) {
            this.collectorsRun = ImmutableList.copyOf((Collection)builder.collectorsRun);
            this.unsupportedBuildSystems = ImmutableList.copyOf((Collection)builder.unsupportedBuildSystems);
            this.scanAttributesJSON = builder.scanAttributesJSON;
            this.agentType = builder.agentType;
            this.agentVersion = builder.agentVersion;
            this.OS = builder.OS;
            this.OSVersion = builder.OSVersion;
            this.JVMVersion = builder.JVMVersion;
            this.quickScan = builder.quickScan;
            this.recursiveScan = builder.recursiveScan;
            this.scanErrorMessage = builder.scanErrorMessage;
        }

        @Override
        @JsonProperty(value="collectorsRun")
        public List<CollectorData> getCollectorsRun() {
            return this.collectorsRun;
        }

        @Override
        @JsonProperty(value="unsupportedBuildSystems")
        public List<CollectorData> getUnsupportedBuildSystems() {
            return this.unsupportedBuildSystems;
        }

        @Override
        @JsonProperty(value="scanAttributesJSON")
        public String getScanAttributesJSON() {
            return this.scanAttributesJSON;
        }

        @Override
        @JsonProperty(value="agentType")
        public String getAgentType() {
            return this.agentType;
        }

        @Override
        @JsonProperty(value="agentVersion")
        public String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        @JsonProperty(value="OS")
        public String getOS() {
            return this.OS;
        }

        @Override
        @JsonProperty(value="OSVersion")
        public String getOSVersion() {
            return this.OSVersion;
        }

        @Override
        @JsonProperty(value="JVMVersion")
        public String getJVMVersion() {
            return this.JVMVersion;
        }

        @Override
        @JsonProperty(value="quickScan")
        public boolean isQuickScan() {
            return this.quickScan;
        }

        @Override
        @JsonProperty(value="recursiveScan")
        public boolean isRecursiveScan() {
            return this.recursiveScan;
        }

        @Override
        @JsonProperty(value="scanErrorMessage")
        @Nullable
        public String getScanErrorMessage() {
            return this.scanErrorMessage;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.collectorsRun, other.collectorsRun) && Objects.equals(this.unsupportedBuildSystems, other.unsupportedBuildSystems) && Objects.equals(this.scanAttributesJSON, other.scanAttributesJSON) && Objects.equals(this.agentType, other.agentType) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.OS, other.OS) && Objects.equals(this.OSVersion, other.OSVersion) && Objects.equals(this.JVMVersion, other.JVMVersion) && Objects.equals(this.quickScan, other.quickScan) && Objects.equals(this.recursiveScan, other.recursiveScan) && Objects.equals(this.scanErrorMessage, other.scanErrorMessage);
        }

        public int hashCode() {
            return Objects.hash(this.collectorsRun, this.unsupportedBuildSystems, this.scanAttributesJSON, this.agentType, this.agentVersion, this.OS, this.OSVersion, this.JVMVersion, this.quickScan, this.recursiveScan, this.scanErrorMessage);
        }

        public String toString() {
            return "AgentRuntimeData{" + COMMA_JOINER.join((Object)("collectorsRun=" + this.collectorsRun), (Object)("unsupportedBuildSystems=" + this.unsupportedBuildSystems), new Object[]{"scanAttributesJSON=" + this.scanAttributesJSON, "agentType=" + this.agentType, "agentVersion=" + this.agentVersion, "OS=" + this.OS, "OSVersion=" + this.OSVersion, "JVMVersion=" + this.JVMVersion, "quickScan=" + this.quickScan, "recursiveScan=" + this.recursiveScan, this.scanErrorMessage != null ? "scanErrorMessage=" + this.scanErrorMessage : null}) + "}";
        }
    }
}

