/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.diff.DiffQuery;
import com.sourceclear.api.data.diff.DiffResponse;
import com.sourceclear.api.data.diff.LibraryResourceModel;
import com.sourceclear.api.data.diff.LicenseIssueResourceModel;
import com.sourceclear.api.data.diff.LicenseResourceModel;
import com.sourceclear.api.data.diff.OutOfDateIssueResourceModel;
import com.sourceclear.api.data.diff.VulnIssueResourceModel;
import com.sourceclear.api.data.diff.VulnResourceModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class DiffResponse_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private DiffQuery diffQuery;
    private List<LibraryResourceModel> librariesAdded = ImmutableList.of();
    private List<LibraryResourceModel> librariesRemoved = ImmutableList.of();
    private List<VulnResourceModel> vulnerabilitiesAdded = ImmutableList.of();
    private List<VulnResourceModel> vulnerabilitiesRemoved = ImmutableList.of();
    private List<LicenseResourceModel> licensesAdded = ImmutableList.of();
    private List<LicenseResourceModel> licensesRemoved = ImmutableList.of();
    private List<LicenseIssueResourceModel> licenseIssuesFixed = ImmutableList.of();
    private List<LicenseIssueResourceModel> licenseIssuesIntroduced = ImmutableList.of();
    private List<OutOfDateIssueResourceModel> outOfDateIssuesFixed = ImmutableList.of();
    private List<OutOfDateIssueResourceModel> outOfDateIssuesIntroduced = ImmutableList.of();
    private List<VulnIssueResourceModel> vulnIssuesFixed = ImmutableList.of();
    private List<VulnIssueResourceModel> vulnIssuesIntroduced = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    DiffResponse_Builder() {
    }

    public static DiffResponse.Builder from(DiffResponse value) {
        return new DiffResponse.Builder().mergeFrom(value);
    }

    @JsonProperty(value="diffQuery")
    public DiffResponse.Builder setDiffQuery(DiffQuery diffQuery) {
        this.diffQuery = (DiffQuery)Preconditions.checkNotNull((Object)diffQuery);
        this._unsetProperties.remove((Object)Property.DIFF_QUERY);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder mapDiffQuery(UnaryOperator<DiffQuery> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setDiffQuery((DiffQuery)mapper.apply(this.getDiffQuery()));
    }

    public DiffQuery getDiffQuery() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.DIFF_QUERY) ? 1 : 0) != 0, (Object)"diffQuery not set");
        return this.diffQuery;
    }

    public DiffResponse.Builder addLibrariesAdded(LibraryResourceModel element) {
        if (this.librariesAdded instanceof ImmutableList) {
            this.librariesAdded = new ArrayList<LibraryResourceModel>(this.librariesAdded);
        }
        this.librariesAdded.add((LibraryResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addLibrariesAdded(LibraryResourceModel ... elements) {
        return this.addAllLibrariesAdded(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllLibrariesAdded(Spliterator<? extends LibraryResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.librariesAdded instanceof ImmutableList) {
                this.librariesAdded = new ArrayList<LibraryResourceModel>(this.librariesAdded);
            }
            ((ArrayList)this.librariesAdded).ensureCapacity(this.librariesAdded.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addLibrariesAdded);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllLibrariesAdded(BaseStream<? extends LibraryResourceModel, ?> elements) {
        return this.addAllLibrariesAdded(elements.spliterator());
    }

    @JsonProperty(value="librariesAdded")
    public DiffResponse.Builder addAllLibrariesAdded(Iterable<? extends LibraryResourceModel> elements) {
        return this.addAllLibrariesAdded(elements.spliterator());
    }

    public DiffResponse.Builder mutateLibrariesAdded(Consumer<? super List<LibraryResourceModel>> mutator) {
        if (this.librariesAdded instanceof ImmutableList) {
            this.librariesAdded = new ArrayList<LibraryResourceModel>(this.librariesAdded);
        }
        mutator.accept(this.librariesAdded);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearLibrariesAdded() {
        if (this.librariesAdded instanceof ImmutableList) {
            this.librariesAdded = ImmutableList.of();
        } else {
            this.librariesAdded.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<LibraryResourceModel> getLibrariesAdded() {
        if (this.librariesAdded instanceof ImmutableList) {
            this.librariesAdded = new ArrayList<LibraryResourceModel>(this.librariesAdded);
        }
        return Collections.unmodifiableList(this.librariesAdded);
    }

    public DiffResponse.Builder addLibrariesRemoved(LibraryResourceModel element) {
        if (this.librariesRemoved instanceof ImmutableList) {
            this.librariesRemoved = new ArrayList<LibraryResourceModel>(this.librariesRemoved);
        }
        this.librariesRemoved.add((LibraryResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addLibrariesRemoved(LibraryResourceModel ... elements) {
        return this.addAllLibrariesRemoved(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllLibrariesRemoved(Spliterator<? extends LibraryResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.librariesRemoved instanceof ImmutableList) {
                this.librariesRemoved = new ArrayList<LibraryResourceModel>(this.librariesRemoved);
            }
            ((ArrayList)this.librariesRemoved).ensureCapacity(this.librariesRemoved.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addLibrariesRemoved);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllLibrariesRemoved(BaseStream<? extends LibraryResourceModel, ?> elements) {
        return this.addAllLibrariesRemoved(elements.spliterator());
    }

    @JsonProperty(value="librariesRemoved")
    public DiffResponse.Builder addAllLibrariesRemoved(Iterable<? extends LibraryResourceModel> elements) {
        return this.addAllLibrariesRemoved(elements.spliterator());
    }

    public DiffResponse.Builder mutateLibrariesRemoved(Consumer<? super List<LibraryResourceModel>> mutator) {
        if (this.librariesRemoved instanceof ImmutableList) {
            this.librariesRemoved = new ArrayList<LibraryResourceModel>(this.librariesRemoved);
        }
        mutator.accept(this.librariesRemoved);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearLibrariesRemoved() {
        if (this.librariesRemoved instanceof ImmutableList) {
            this.librariesRemoved = ImmutableList.of();
        } else {
            this.librariesRemoved.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<LibraryResourceModel> getLibrariesRemoved() {
        if (this.librariesRemoved instanceof ImmutableList) {
            this.librariesRemoved = new ArrayList<LibraryResourceModel>(this.librariesRemoved);
        }
        return Collections.unmodifiableList(this.librariesRemoved);
    }

    public DiffResponse.Builder addVulnerabilitiesAdded(VulnResourceModel element) {
        if (this.vulnerabilitiesAdded instanceof ImmutableList) {
            this.vulnerabilitiesAdded = new ArrayList<VulnResourceModel>(this.vulnerabilitiesAdded);
        }
        this.vulnerabilitiesAdded.add((VulnResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addVulnerabilitiesAdded(VulnResourceModel ... elements) {
        return this.addAllVulnerabilitiesAdded(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllVulnerabilitiesAdded(Spliterator<? extends VulnResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.vulnerabilitiesAdded instanceof ImmutableList) {
                this.vulnerabilitiesAdded = new ArrayList<VulnResourceModel>(this.vulnerabilitiesAdded);
            }
            ((ArrayList)this.vulnerabilitiesAdded).ensureCapacity(this.vulnerabilitiesAdded.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addVulnerabilitiesAdded);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllVulnerabilitiesAdded(BaseStream<? extends VulnResourceModel, ?> elements) {
        return this.addAllVulnerabilitiesAdded(elements.spliterator());
    }

    @JsonProperty(value="vulnerabilitiesAdded")
    public DiffResponse.Builder addAllVulnerabilitiesAdded(Iterable<? extends VulnResourceModel> elements) {
        return this.addAllVulnerabilitiesAdded(elements.spliterator());
    }

    public DiffResponse.Builder mutateVulnerabilitiesAdded(Consumer<? super List<VulnResourceModel>> mutator) {
        if (this.vulnerabilitiesAdded instanceof ImmutableList) {
            this.vulnerabilitiesAdded = new ArrayList<VulnResourceModel>(this.vulnerabilitiesAdded);
        }
        mutator.accept(this.vulnerabilitiesAdded);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearVulnerabilitiesAdded() {
        if (this.vulnerabilitiesAdded instanceof ImmutableList) {
            this.vulnerabilitiesAdded = ImmutableList.of();
        } else {
            this.vulnerabilitiesAdded.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<VulnResourceModel> getVulnerabilitiesAdded() {
        if (this.vulnerabilitiesAdded instanceof ImmutableList) {
            this.vulnerabilitiesAdded = new ArrayList<VulnResourceModel>(this.vulnerabilitiesAdded);
        }
        return Collections.unmodifiableList(this.vulnerabilitiesAdded);
    }

    public DiffResponse.Builder addVulnerabilitiesRemoved(VulnResourceModel element) {
        if (this.vulnerabilitiesRemoved instanceof ImmutableList) {
            this.vulnerabilitiesRemoved = new ArrayList<VulnResourceModel>(this.vulnerabilitiesRemoved);
        }
        this.vulnerabilitiesRemoved.add((VulnResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addVulnerabilitiesRemoved(VulnResourceModel ... elements) {
        return this.addAllVulnerabilitiesRemoved(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllVulnerabilitiesRemoved(Spliterator<? extends VulnResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.vulnerabilitiesRemoved instanceof ImmutableList) {
                this.vulnerabilitiesRemoved = new ArrayList<VulnResourceModel>(this.vulnerabilitiesRemoved);
            }
            ((ArrayList)this.vulnerabilitiesRemoved).ensureCapacity(this.vulnerabilitiesRemoved.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addVulnerabilitiesRemoved);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllVulnerabilitiesRemoved(BaseStream<? extends VulnResourceModel, ?> elements) {
        return this.addAllVulnerabilitiesRemoved(elements.spliterator());
    }

    @JsonProperty(value="vulnerabilitiesRemoved")
    public DiffResponse.Builder addAllVulnerabilitiesRemoved(Iterable<? extends VulnResourceModel> elements) {
        return this.addAllVulnerabilitiesRemoved(elements.spliterator());
    }

    public DiffResponse.Builder mutateVulnerabilitiesRemoved(Consumer<? super List<VulnResourceModel>> mutator) {
        if (this.vulnerabilitiesRemoved instanceof ImmutableList) {
            this.vulnerabilitiesRemoved = new ArrayList<VulnResourceModel>(this.vulnerabilitiesRemoved);
        }
        mutator.accept(this.vulnerabilitiesRemoved);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearVulnerabilitiesRemoved() {
        if (this.vulnerabilitiesRemoved instanceof ImmutableList) {
            this.vulnerabilitiesRemoved = ImmutableList.of();
        } else {
            this.vulnerabilitiesRemoved.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<VulnResourceModel> getVulnerabilitiesRemoved() {
        if (this.vulnerabilitiesRemoved instanceof ImmutableList) {
            this.vulnerabilitiesRemoved = new ArrayList<VulnResourceModel>(this.vulnerabilitiesRemoved);
        }
        return Collections.unmodifiableList(this.vulnerabilitiesRemoved);
    }

    public DiffResponse.Builder addLicensesAdded(LicenseResourceModel element) {
        if (this.licensesAdded instanceof ImmutableList) {
            this.licensesAdded = new ArrayList<LicenseResourceModel>(this.licensesAdded);
        }
        this.licensesAdded.add((LicenseResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addLicensesAdded(LicenseResourceModel ... elements) {
        return this.addAllLicensesAdded(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllLicensesAdded(Spliterator<? extends LicenseResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.licensesAdded instanceof ImmutableList) {
                this.licensesAdded = new ArrayList<LicenseResourceModel>(this.licensesAdded);
            }
            ((ArrayList)this.licensesAdded).ensureCapacity(this.licensesAdded.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addLicensesAdded);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllLicensesAdded(BaseStream<? extends LicenseResourceModel, ?> elements) {
        return this.addAllLicensesAdded(elements.spliterator());
    }

    @JsonProperty(value="licensesAdded")
    public DiffResponse.Builder addAllLicensesAdded(Iterable<? extends LicenseResourceModel> elements) {
        return this.addAllLicensesAdded(elements.spliterator());
    }

    public DiffResponse.Builder mutateLicensesAdded(Consumer<? super List<LicenseResourceModel>> mutator) {
        if (this.licensesAdded instanceof ImmutableList) {
            this.licensesAdded = new ArrayList<LicenseResourceModel>(this.licensesAdded);
        }
        mutator.accept(this.licensesAdded);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearLicensesAdded() {
        if (this.licensesAdded instanceof ImmutableList) {
            this.licensesAdded = ImmutableList.of();
        } else {
            this.licensesAdded.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<LicenseResourceModel> getLicensesAdded() {
        if (this.licensesAdded instanceof ImmutableList) {
            this.licensesAdded = new ArrayList<LicenseResourceModel>(this.licensesAdded);
        }
        return Collections.unmodifiableList(this.licensesAdded);
    }

    public DiffResponse.Builder addLicensesRemoved(LicenseResourceModel element) {
        if (this.licensesRemoved instanceof ImmutableList) {
            this.licensesRemoved = new ArrayList<LicenseResourceModel>(this.licensesRemoved);
        }
        this.licensesRemoved.add((LicenseResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addLicensesRemoved(LicenseResourceModel ... elements) {
        return this.addAllLicensesRemoved(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllLicensesRemoved(Spliterator<? extends LicenseResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.licensesRemoved instanceof ImmutableList) {
                this.licensesRemoved = new ArrayList<LicenseResourceModel>(this.licensesRemoved);
            }
            ((ArrayList)this.licensesRemoved).ensureCapacity(this.licensesRemoved.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addLicensesRemoved);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllLicensesRemoved(BaseStream<? extends LicenseResourceModel, ?> elements) {
        return this.addAllLicensesRemoved(elements.spliterator());
    }

    @JsonProperty(value="licensesRemoved")
    public DiffResponse.Builder addAllLicensesRemoved(Iterable<? extends LicenseResourceModel> elements) {
        return this.addAllLicensesRemoved(elements.spliterator());
    }

    public DiffResponse.Builder mutateLicensesRemoved(Consumer<? super List<LicenseResourceModel>> mutator) {
        if (this.licensesRemoved instanceof ImmutableList) {
            this.licensesRemoved = new ArrayList<LicenseResourceModel>(this.licensesRemoved);
        }
        mutator.accept(this.licensesRemoved);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearLicensesRemoved() {
        if (this.licensesRemoved instanceof ImmutableList) {
            this.licensesRemoved = ImmutableList.of();
        } else {
            this.licensesRemoved.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<LicenseResourceModel> getLicensesRemoved() {
        if (this.licensesRemoved instanceof ImmutableList) {
            this.licensesRemoved = new ArrayList<LicenseResourceModel>(this.licensesRemoved);
        }
        return Collections.unmodifiableList(this.licensesRemoved);
    }

    public DiffResponse.Builder addLicenseIssuesFixed(LicenseIssueResourceModel element) {
        if (this.licenseIssuesFixed instanceof ImmutableList) {
            this.licenseIssuesFixed = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesFixed);
        }
        this.licenseIssuesFixed.add((LicenseIssueResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addLicenseIssuesFixed(LicenseIssueResourceModel ... elements) {
        return this.addAllLicenseIssuesFixed(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllLicenseIssuesFixed(Spliterator<? extends LicenseIssueResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.licenseIssuesFixed instanceof ImmutableList) {
                this.licenseIssuesFixed = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesFixed);
            }
            ((ArrayList)this.licenseIssuesFixed).ensureCapacity(this.licenseIssuesFixed.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addLicenseIssuesFixed);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllLicenseIssuesFixed(BaseStream<? extends LicenseIssueResourceModel, ?> elements) {
        return this.addAllLicenseIssuesFixed(elements.spliterator());
    }

    @JsonProperty(value="licenseIssuesFixed")
    public DiffResponse.Builder addAllLicenseIssuesFixed(Iterable<? extends LicenseIssueResourceModel> elements) {
        return this.addAllLicenseIssuesFixed(elements.spliterator());
    }

    public DiffResponse.Builder mutateLicenseIssuesFixed(Consumer<? super List<LicenseIssueResourceModel>> mutator) {
        if (this.licenseIssuesFixed instanceof ImmutableList) {
            this.licenseIssuesFixed = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesFixed);
        }
        mutator.accept(this.licenseIssuesFixed);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearLicenseIssuesFixed() {
        if (this.licenseIssuesFixed instanceof ImmutableList) {
            this.licenseIssuesFixed = ImmutableList.of();
        } else {
            this.licenseIssuesFixed.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<LicenseIssueResourceModel> getLicenseIssuesFixed() {
        if (this.licenseIssuesFixed instanceof ImmutableList) {
            this.licenseIssuesFixed = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesFixed);
        }
        return Collections.unmodifiableList(this.licenseIssuesFixed);
    }

    public DiffResponse.Builder addLicenseIssuesIntroduced(LicenseIssueResourceModel element) {
        if (this.licenseIssuesIntroduced instanceof ImmutableList) {
            this.licenseIssuesIntroduced = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesIntroduced);
        }
        this.licenseIssuesIntroduced.add((LicenseIssueResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addLicenseIssuesIntroduced(LicenseIssueResourceModel ... elements) {
        return this.addAllLicenseIssuesIntroduced(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllLicenseIssuesIntroduced(Spliterator<? extends LicenseIssueResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.licenseIssuesIntroduced instanceof ImmutableList) {
                this.licenseIssuesIntroduced = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesIntroduced);
            }
            ((ArrayList)this.licenseIssuesIntroduced).ensureCapacity(this.licenseIssuesIntroduced.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addLicenseIssuesIntroduced);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllLicenseIssuesIntroduced(BaseStream<? extends LicenseIssueResourceModel, ?> elements) {
        return this.addAllLicenseIssuesIntroduced(elements.spliterator());
    }

    @JsonProperty(value="licenseIssuesIntroduced")
    public DiffResponse.Builder addAllLicenseIssuesIntroduced(Iterable<? extends LicenseIssueResourceModel> elements) {
        return this.addAllLicenseIssuesIntroduced(elements.spliterator());
    }

    public DiffResponse.Builder mutateLicenseIssuesIntroduced(Consumer<? super List<LicenseIssueResourceModel>> mutator) {
        if (this.licenseIssuesIntroduced instanceof ImmutableList) {
            this.licenseIssuesIntroduced = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesIntroduced);
        }
        mutator.accept(this.licenseIssuesIntroduced);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearLicenseIssuesIntroduced() {
        if (this.licenseIssuesIntroduced instanceof ImmutableList) {
            this.licenseIssuesIntroduced = ImmutableList.of();
        } else {
            this.licenseIssuesIntroduced.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<LicenseIssueResourceModel> getLicenseIssuesIntroduced() {
        if (this.licenseIssuesIntroduced instanceof ImmutableList) {
            this.licenseIssuesIntroduced = new ArrayList<LicenseIssueResourceModel>(this.licenseIssuesIntroduced);
        }
        return Collections.unmodifiableList(this.licenseIssuesIntroduced);
    }

    public DiffResponse.Builder addOutOfDateIssuesFixed(OutOfDateIssueResourceModel element) {
        if (this.outOfDateIssuesFixed instanceof ImmutableList) {
            this.outOfDateIssuesFixed = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesFixed);
        }
        this.outOfDateIssuesFixed.add((OutOfDateIssueResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addOutOfDateIssuesFixed(OutOfDateIssueResourceModel ... elements) {
        return this.addAllOutOfDateIssuesFixed(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllOutOfDateIssuesFixed(Spliterator<? extends OutOfDateIssueResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.outOfDateIssuesFixed instanceof ImmutableList) {
                this.outOfDateIssuesFixed = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesFixed);
            }
            ((ArrayList)this.outOfDateIssuesFixed).ensureCapacity(this.outOfDateIssuesFixed.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addOutOfDateIssuesFixed);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllOutOfDateIssuesFixed(BaseStream<? extends OutOfDateIssueResourceModel, ?> elements) {
        return this.addAllOutOfDateIssuesFixed(elements.spliterator());
    }

    @JsonProperty(value="outOfDateIssuesFixed")
    public DiffResponse.Builder addAllOutOfDateIssuesFixed(Iterable<? extends OutOfDateIssueResourceModel> elements) {
        return this.addAllOutOfDateIssuesFixed(elements.spliterator());
    }

    public DiffResponse.Builder mutateOutOfDateIssuesFixed(Consumer<? super List<OutOfDateIssueResourceModel>> mutator) {
        if (this.outOfDateIssuesFixed instanceof ImmutableList) {
            this.outOfDateIssuesFixed = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesFixed);
        }
        mutator.accept(this.outOfDateIssuesFixed);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearOutOfDateIssuesFixed() {
        if (this.outOfDateIssuesFixed instanceof ImmutableList) {
            this.outOfDateIssuesFixed = ImmutableList.of();
        } else {
            this.outOfDateIssuesFixed.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<OutOfDateIssueResourceModel> getOutOfDateIssuesFixed() {
        if (this.outOfDateIssuesFixed instanceof ImmutableList) {
            this.outOfDateIssuesFixed = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesFixed);
        }
        return Collections.unmodifiableList(this.outOfDateIssuesFixed);
    }

    public DiffResponse.Builder addOutOfDateIssuesIntroduced(OutOfDateIssueResourceModel element) {
        if (this.outOfDateIssuesIntroduced instanceof ImmutableList) {
            this.outOfDateIssuesIntroduced = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesIntroduced);
        }
        this.outOfDateIssuesIntroduced.add((OutOfDateIssueResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addOutOfDateIssuesIntroduced(OutOfDateIssueResourceModel ... elements) {
        return this.addAllOutOfDateIssuesIntroduced(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllOutOfDateIssuesIntroduced(Spliterator<? extends OutOfDateIssueResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.outOfDateIssuesIntroduced instanceof ImmutableList) {
                this.outOfDateIssuesIntroduced = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesIntroduced);
            }
            ((ArrayList)this.outOfDateIssuesIntroduced).ensureCapacity(this.outOfDateIssuesIntroduced.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addOutOfDateIssuesIntroduced);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllOutOfDateIssuesIntroduced(BaseStream<? extends OutOfDateIssueResourceModel, ?> elements) {
        return this.addAllOutOfDateIssuesIntroduced(elements.spliterator());
    }

    @JsonProperty(value="outOfDateIssuesIntroduced")
    public DiffResponse.Builder addAllOutOfDateIssuesIntroduced(Iterable<? extends OutOfDateIssueResourceModel> elements) {
        return this.addAllOutOfDateIssuesIntroduced(elements.spliterator());
    }

    public DiffResponse.Builder mutateOutOfDateIssuesIntroduced(Consumer<? super List<OutOfDateIssueResourceModel>> mutator) {
        if (this.outOfDateIssuesIntroduced instanceof ImmutableList) {
            this.outOfDateIssuesIntroduced = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesIntroduced);
        }
        mutator.accept(this.outOfDateIssuesIntroduced);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearOutOfDateIssuesIntroduced() {
        if (this.outOfDateIssuesIntroduced instanceof ImmutableList) {
            this.outOfDateIssuesIntroduced = ImmutableList.of();
        } else {
            this.outOfDateIssuesIntroduced.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<OutOfDateIssueResourceModel> getOutOfDateIssuesIntroduced() {
        if (this.outOfDateIssuesIntroduced instanceof ImmutableList) {
            this.outOfDateIssuesIntroduced = new ArrayList<OutOfDateIssueResourceModel>(this.outOfDateIssuesIntroduced);
        }
        return Collections.unmodifiableList(this.outOfDateIssuesIntroduced);
    }

    public DiffResponse.Builder addVulnIssuesFixed(VulnIssueResourceModel element) {
        if (this.vulnIssuesFixed instanceof ImmutableList) {
            this.vulnIssuesFixed = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesFixed);
        }
        this.vulnIssuesFixed.add((VulnIssueResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addVulnIssuesFixed(VulnIssueResourceModel ... elements) {
        return this.addAllVulnIssuesFixed(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllVulnIssuesFixed(Spliterator<? extends VulnIssueResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.vulnIssuesFixed instanceof ImmutableList) {
                this.vulnIssuesFixed = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesFixed);
            }
            ((ArrayList)this.vulnIssuesFixed).ensureCapacity(this.vulnIssuesFixed.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addVulnIssuesFixed);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllVulnIssuesFixed(BaseStream<? extends VulnIssueResourceModel, ?> elements) {
        return this.addAllVulnIssuesFixed(elements.spliterator());
    }

    @JsonProperty(value="vulnIssuesFixed")
    public DiffResponse.Builder addAllVulnIssuesFixed(Iterable<? extends VulnIssueResourceModel> elements) {
        return this.addAllVulnIssuesFixed(elements.spliterator());
    }

    public DiffResponse.Builder mutateVulnIssuesFixed(Consumer<? super List<VulnIssueResourceModel>> mutator) {
        if (this.vulnIssuesFixed instanceof ImmutableList) {
            this.vulnIssuesFixed = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesFixed);
        }
        mutator.accept(this.vulnIssuesFixed);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearVulnIssuesFixed() {
        if (this.vulnIssuesFixed instanceof ImmutableList) {
            this.vulnIssuesFixed = ImmutableList.of();
        } else {
            this.vulnIssuesFixed.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<VulnIssueResourceModel> getVulnIssuesFixed() {
        if (this.vulnIssuesFixed instanceof ImmutableList) {
            this.vulnIssuesFixed = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesFixed);
        }
        return Collections.unmodifiableList(this.vulnIssuesFixed);
    }

    public DiffResponse.Builder addVulnIssuesIntroduced(VulnIssueResourceModel element) {
        if (this.vulnIssuesIntroduced instanceof ImmutableList) {
            this.vulnIssuesIntroduced = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesIntroduced);
        }
        this.vulnIssuesIntroduced.add((VulnIssueResourceModel)Preconditions.checkNotNull((Object)element));
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addVulnIssuesIntroduced(VulnIssueResourceModel ... elements) {
        return this.addAllVulnIssuesIntroduced(Arrays.asList(elements));
    }

    public DiffResponse.Builder addAllVulnIssuesIntroduced(Spliterator<? extends VulnIssueResourceModel> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.vulnIssuesIntroduced instanceof ImmutableList) {
                this.vulnIssuesIntroduced = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesIntroduced);
            }
            ((ArrayList)this.vulnIssuesIntroduced).ensureCapacity(this.vulnIssuesIntroduced.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addVulnIssuesIntroduced);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder addAllVulnIssuesIntroduced(BaseStream<? extends VulnIssueResourceModel, ?> elements) {
        return this.addAllVulnIssuesIntroduced(elements.spliterator());
    }

    @JsonProperty(value="vulnIssuesIntroduced")
    public DiffResponse.Builder addAllVulnIssuesIntroduced(Iterable<? extends VulnIssueResourceModel> elements) {
        return this.addAllVulnIssuesIntroduced(elements.spliterator());
    }

    public DiffResponse.Builder mutateVulnIssuesIntroduced(Consumer<? super List<VulnIssueResourceModel>> mutator) {
        if (this.vulnIssuesIntroduced instanceof ImmutableList) {
            this.vulnIssuesIntroduced = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesIntroduced);
        }
        mutator.accept(this.vulnIssuesIntroduced);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clearVulnIssuesIntroduced() {
        if (this.vulnIssuesIntroduced instanceof ImmutableList) {
            this.vulnIssuesIntroduced = ImmutableList.of();
        } else {
            this.vulnIssuesIntroduced.clear();
        }
        return (DiffResponse.Builder)this;
    }

    public List<VulnIssueResourceModel> getVulnIssuesIntroduced() {
        if (this.vulnIssuesIntroduced instanceof ImmutableList) {
            this.vulnIssuesIntroduced = new ArrayList<VulnIssueResourceModel>(this.vulnIssuesIntroduced);
        }
        return Collections.unmodifiableList(this.vulnIssuesIntroduced);
    }

    public DiffResponse.Builder mergeFrom(DiffResponse value) {
        DiffResponse.Builder _defaults = new DiffResponse.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.DIFF_QUERY) || !Objects.equals(value.getDiffQuery(), ((DiffResponse_Builder)_defaults).getDiffQuery())) {
            this.setDiffQuery(value.getDiffQuery());
        }
        if (value instanceof Value && this.librariesAdded == ImmutableList.of()) {
            this.librariesAdded = ImmutableList.copyOf(value.getLibrariesAdded());
        } else {
            this.addAllLibrariesAdded(value.getLibrariesAdded());
        }
        if (value instanceof Value && this.librariesRemoved == ImmutableList.of()) {
            this.librariesRemoved = ImmutableList.copyOf(value.getLibrariesRemoved());
        } else {
            this.addAllLibrariesRemoved(value.getLibrariesRemoved());
        }
        if (value instanceof Value && this.vulnerabilitiesAdded == ImmutableList.of()) {
            this.vulnerabilitiesAdded = ImmutableList.copyOf(value.getVulnerabilitiesAdded());
        } else {
            this.addAllVulnerabilitiesAdded(value.getVulnerabilitiesAdded());
        }
        if (value instanceof Value && this.vulnerabilitiesRemoved == ImmutableList.of()) {
            this.vulnerabilitiesRemoved = ImmutableList.copyOf(value.getVulnerabilitiesRemoved());
        } else {
            this.addAllVulnerabilitiesRemoved(value.getVulnerabilitiesRemoved());
        }
        if (value instanceof Value && this.licensesAdded == ImmutableList.of()) {
            this.licensesAdded = ImmutableList.copyOf(value.getLicensesAdded());
        } else {
            this.addAllLicensesAdded(value.getLicensesAdded());
        }
        if (value instanceof Value && this.licensesRemoved == ImmutableList.of()) {
            this.licensesRemoved = ImmutableList.copyOf(value.getLicensesRemoved());
        } else {
            this.addAllLicensesRemoved(value.getLicensesRemoved());
        }
        if (value instanceof Value && this.licenseIssuesFixed == ImmutableList.of()) {
            this.licenseIssuesFixed = ImmutableList.copyOf(value.getLicenseIssuesFixed());
        } else {
            this.addAllLicenseIssuesFixed(value.getLicenseIssuesFixed());
        }
        if (value instanceof Value && this.licenseIssuesIntroduced == ImmutableList.of()) {
            this.licenseIssuesIntroduced = ImmutableList.copyOf(value.getLicenseIssuesIntroduced());
        } else {
            this.addAllLicenseIssuesIntroduced(value.getLicenseIssuesIntroduced());
        }
        if (value instanceof Value && this.outOfDateIssuesFixed == ImmutableList.of()) {
            this.outOfDateIssuesFixed = ImmutableList.copyOf(value.getOutOfDateIssuesFixed());
        } else {
            this.addAllOutOfDateIssuesFixed(value.getOutOfDateIssuesFixed());
        }
        if (value instanceof Value && this.outOfDateIssuesIntroduced == ImmutableList.of()) {
            this.outOfDateIssuesIntroduced = ImmutableList.copyOf(value.getOutOfDateIssuesIntroduced());
        } else {
            this.addAllOutOfDateIssuesIntroduced(value.getOutOfDateIssuesIntroduced());
        }
        if (value instanceof Value && this.vulnIssuesFixed == ImmutableList.of()) {
            this.vulnIssuesFixed = ImmutableList.copyOf(value.getVulnIssuesFixed());
        } else {
            this.addAllVulnIssuesFixed(value.getVulnIssuesFixed());
        }
        if (value instanceof Value && this.vulnIssuesIntroduced == ImmutableList.of()) {
            this.vulnIssuesIntroduced = ImmutableList.copyOf(value.getVulnIssuesIntroduced());
        } else {
            this.addAllVulnIssuesIntroduced(value.getVulnIssuesIntroduced());
        }
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder mergeFrom(DiffResponse.Builder template) {
        DiffResponse.Builder base = template;
        DiffResponse.Builder _defaults = new DiffResponse.Builder();
        if (!(base._unsetProperties.contains((Object)Property.DIFF_QUERY) || !_defaults._unsetProperties.contains((Object)Property.DIFF_QUERY) && Objects.equals(template.getDiffQuery(), ((DiffResponse_Builder)_defaults).getDiffQuery()))) {
            this.setDiffQuery(template.getDiffQuery());
        }
        this.addAllLibrariesAdded(base.librariesAdded);
        this.addAllLibrariesRemoved(base.librariesRemoved);
        this.addAllVulnerabilitiesAdded(base.vulnerabilitiesAdded);
        this.addAllVulnerabilitiesRemoved(base.vulnerabilitiesRemoved);
        this.addAllLicensesAdded(base.licensesAdded);
        this.addAllLicensesRemoved(base.licensesRemoved);
        this.addAllLicenseIssuesFixed(base.licenseIssuesFixed);
        this.addAllLicenseIssuesIntroduced(base.licenseIssuesIntroduced);
        this.addAllOutOfDateIssuesFixed(base.outOfDateIssuesFixed);
        this.addAllOutOfDateIssuesIntroduced(base.outOfDateIssuesIntroduced);
        this.addAllVulnIssuesFixed(base.vulnIssuesFixed);
        this.addAllVulnIssuesIntroduced(base.vulnIssuesIntroduced);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse.Builder clear() {
        DiffResponse.Builder _defaults = new DiffResponse.Builder();
        this.diffQuery = _defaults.diffQuery;
        this.clearLibrariesAdded();
        this.clearLibrariesRemoved();
        this.clearVulnerabilitiesAdded();
        this.clearVulnerabilitiesRemoved();
        this.clearLicensesAdded();
        this.clearLicensesRemoved();
        this.clearLicenseIssuesFixed();
        this.clearLicenseIssuesIntroduced();
        this.clearOutOfDateIssuesFixed();
        this.clearOutOfDateIssuesIntroduced();
        this.clearVulnIssuesFixed();
        this.clearVulnIssuesIntroduced();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (DiffResponse.Builder)this;
    }

    public DiffResponse build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public DiffResponse buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements DiffResponse {
        private final DiffQuery diffQuery;
        private final Collection<LibraryResourceModel> librariesAdded;
        private final Collection<LibraryResourceModel> librariesRemoved;
        private final Collection<VulnResourceModel> vulnerabilitiesAdded;
        private final Collection<VulnResourceModel> vulnerabilitiesRemoved;
        private final Collection<LicenseResourceModel> licensesAdded;
        private final Collection<LicenseResourceModel> licensesRemoved;
        private final Collection<LicenseIssueResourceModel> licenseIssuesFixed;
        private final Collection<LicenseIssueResourceModel> licenseIssuesIntroduced;
        private final Collection<OutOfDateIssueResourceModel> outOfDateIssuesFixed;
        private final Collection<OutOfDateIssueResourceModel> outOfDateIssuesIntroduced;
        private final Collection<VulnIssueResourceModel> vulnIssuesFixed;
        private final Collection<VulnIssueResourceModel> vulnIssuesIntroduced;
        private final EnumSet<Property> _unsetProperties;

        Partial(DiffResponse_Builder builder) {
            this.diffQuery = builder.diffQuery;
            this.librariesAdded = ImmutableList.copyOf((Collection)builder.librariesAdded);
            this.librariesRemoved = ImmutableList.copyOf((Collection)builder.librariesRemoved);
            this.vulnerabilitiesAdded = ImmutableList.copyOf((Collection)builder.vulnerabilitiesAdded);
            this.vulnerabilitiesRemoved = ImmutableList.copyOf((Collection)builder.vulnerabilitiesRemoved);
            this.licensesAdded = ImmutableList.copyOf((Collection)builder.licensesAdded);
            this.licensesRemoved = ImmutableList.copyOf((Collection)builder.licensesRemoved);
            this.licenseIssuesFixed = ImmutableList.copyOf((Collection)builder.licenseIssuesFixed);
            this.licenseIssuesIntroduced = ImmutableList.copyOf((Collection)builder.licenseIssuesIntroduced);
            this.outOfDateIssuesFixed = ImmutableList.copyOf((Collection)builder.outOfDateIssuesFixed);
            this.outOfDateIssuesIntroduced = ImmutableList.copyOf((Collection)builder.outOfDateIssuesIntroduced);
            this.vulnIssuesFixed = ImmutableList.copyOf((Collection)builder.vulnIssuesFixed);
            this.vulnIssuesIntroduced = ImmutableList.copyOf((Collection)builder.vulnIssuesIntroduced);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="diffQuery")
        public DiffQuery getDiffQuery() {
            if (this._unsetProperties.contains((Object)Property.DIFF_QUERY)) {
                throw new UnsupportedOperationException("diffQuery not set");
            }
            return this.diffQuery;
        }

        @Override
        @JsonProperty(value="librariesAdded")
        public Collection<LibraryResourceModel> getLibrariesAdded() {
            return this.librariesAdded;
        }

        @Override
        @JsonProperty(value="librariesRemoved")
        public Collection<LibraryResourceModel> getLibrariesRemoved() {
            return this.librariesRemoved;
        }

        @Override
        @JsonProperty(value="vulnerabilitiesAdded")
        public Collection<VulnResourceModel> getVulnerabilitiesAdded() {
            return this.vulnerabilitiesAdded;
        }

        @Override
        @JsonProperty(value="vulnerabilitiesRemoved")
        public Collection<VulnResourceModel> getVulnerabilitiesRemoved() {
            return this.vulnerabilitiesRemoved;
        }

        @Override
        @JsonProperty(value="licensesAdded")
        public Collection<LicenseResourceModel> getLicensesAdded() {
            return this.licensesAdded;
        }

        @Override
        @JsonProperty(value="licensesRemoved")
        public Collection<LicenseResourceModel> getLicensesRemoved() {
            return this.licensesRemoved;
        }

        @Override
        @JsonProperty(value="licenseIssuesFixed")
        public Collection<LicenseIssueResourceModel> getLicenseIssuesFixed() {
            return this.licenseIssuesFixed;
        }

        @Override
        @JsonProperty(value="licenseIssuesIntroduced")
        public Collection<LicenseIssueResourceModel> getLicenseIssuesIntroduced() {
            return this.licenseIssuesIntroduced;
        }

        @Override
        @JsonProperty(value="outOfDateIssuesFixed")
        public Collection<OutOfDateIssueResourceModel> getOutOfDateIssuesFixed() {
            return this.outOfDateIssuesFixed;
        }

        @Override
        @JsonProperty(value="outOfDateIssuesIntroduced")
        public Collection<OutOfDateIssueResourceModel> getOutOfDateIssuesIntroduced() {
            return this.outOfDateIssuesIntroduced;
        }

        @Override
        @JsonProperty(value="vulnIssuesFixed")
        public Collection<VulnIssueResourceModel> getVulnIssuesFixed() {
            return this.vulnIssuesFixed;
        }

        @Override
        @JsonProperty(value="vulnIssuesIntroduced")
        public Collection<VulnIssueResourceModel> getVulnIssuesIntroduced() {
            return this.vulnIssuesIntroduced;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.diffQuery, other.diffQuery) && Objects.equals(this.librariesAdded, other.librariesAdded) && Objects.equals(this.librariesRemoved, other.librariesRemoved) && Objects.equals(this.vulnerabilitiesAdded, other.vulnerabilitiesAdded) && Objects.equals(this.vulnerabilitiesRemoved, other.vulnerabilitiesRemoved) && Objects.equals(this.licensesAdded, other.licensesAdded) && Objects.equals(this.licensesRemoved, other.licensesRemoved) && Objects.equals(this.licenseIssuesFixed, other.licenseIssuesFixed) && Objects.equals(this.licenseIssuesIntroduced, other.licenseIssuesIntroduced) && Objects.equals(this.outOfDateIssuesFixed, other.outOfDateIssuesFixed) && Objects.equals(this.outOfDateIssuesIntroduced, other.outOfDateIssuesIntroduced) && Objects.equals(this.vulnIssuesFixed, other.vulnIssuesFixed) && Objects.equals(this.vulnIssuesIntroduced, other.vulnIssuesIntroduced) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.diffQuery, this.librariesAdded, this.librariesRemoved, this.vulnerabilitiesAdded, this.vulnerabilitiesRemoved, this.licensesAdded, this.licensesRemoved, this.licenseIssuesFixed, this.licenseIssuesIntroduced, this.outOfDateIssuesFixed, this.outOfDateIssuesIntroduced, this.vulnIssuesFixed, this.vulnIssuesIntroduced, this._unsetProperties);
        }

        public String toString() {
            return "partial DiffResponse{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.DIFF_QUERY) ? "diffQuery=" + this.diffQuery : null), (Object)("librariesAdded=" + this.librariesAdded), new Object[]{"librariesRemoved=" + this.librariesRemoved, "vulnerabilitiesAdded=" + this.vulnerabilitiesAdded, "vulnerabilitiesRemoved=" + this.vulnerabilitiesRemoved, "licensesAdded=" + this.licensesAdded, "licensesRemoved=" + this.licensesRemoved, "licenseIssuesFixed=" + this.licenseIssuesFixed, "licenseIssuesIntroduced=" + this.licenseIssuesIntroduced, "outOfDateIssuesFixed=" + this.outOfDateIssuesFixed, "outOfDateIssuesIntroduced=" + this.outOfDateIssuesIntroduced, "vulnIssuesFixed=" + this.vulnIssuesFixed, "vulnIssuesIntroduced=" + this.vulnIssuesIntroduced}) + "}";
        }
    }

    private static final class Value
    implements DiffResponse {
        private final DiffQuery diffQuery;
        private final Collection<LibraryResourceModel> librariesAdded;
        private final Collection<LibraryResourceModel> librariesRemoved;
        private final Collection<VulnResourceModel> vulnerabilitiesAdded;
        private final Collection<VulnResourceModel> vulnerabilitiesRemoved;
        private final Collection<LicenseResourceModel> licensesAdded;
        private final Collection<LicenseResourceModel> licensesRemoved;
        private final Collection<LicenseIssueResourceModel> licenseIssuesFixed;
        private final Collection<LicenseIssueResourceModel> licenseIssuesIntroduced;
        private final Collection<OutOfDateIssueResourceModel> outOfDateIssuesFixed;
        private final Collection<OutOfDateIssueResourceModel> outOfDateIssuesIntroduced;
        private final Collection<VulnIssueResourceModel> vulnIssuesFixed;
        private final Collection<VulnIssueResourceModel> vulnIssuesIntroduced;

        private Value(DiffResponse_Builder builder) {
            this.diffQuery = builder.diffQuery;
            this.librariesAdded = ImmutableList.copyOf((Collection)builder.librariesAdded);
            this.librariesRemoved = ImmutableList.copyOf((Collection)builder.librariesRemoved);
            this.vulnerabilitiesAdded = ImmutableList.copyOf((Collection)builder.vulnerabilitiesAdded);
            this.vulnerabilitiesRemoved = ImmutableList.copyOf((Collection)builder.vulnerabilitiesRemoved);
            this.licensesAdded = ImmutableList.copyOf((Collection)builder.licensesAdded);
            this.licensesRemoved = ImmutableList.copyOf((Collection)builder.licensesRemoved);
            this.licenseIssuesFixed = ImmutableList.copyOf((Collection)builder.licenseIssuesFixed);
            this.licenseIssuesIntroduced = ImmutableList.copyOf((Collection)builder.licenseIssuesIntroduced);
            this.outOfDateIssuesFixed = ImmutableList.copyOf((Collection)builder.outOfDateIssuesFixed);
            this.outOfDateIssuesIntroduced = ImmutableList.copyOf((Collection)builder.outOfDateIssuesIntroduced);
            this.vulnIssuesFixed = ImmutableList.copyOf((Collection)builder.vulnIssuesFixed);
            this.vulnIssuesIntroduced = ImmutableList.copyOf((Collection)builder.vulnIssuesIntroduced);
        }

        @Override
        @JsonProperty(value="diffQuery")
        public DiffQuery getDiffQuery() {
            return this.diffQuery;
        }

        @Override
        @JsonProperty(value="librariesAdded")
        public Collection<LibraryResourceModel> getLibrariesAdded() {
            return this.librariesAdded;
        }

        @Override
        @JsonProperty(value="librariesRemoved")
        public Collection<LibraryResourceModel> getLibrariesRemoved() {
            return this.librariesRemoved;
        }

        @Override
        @JsonProperty(value="vulnerabilitiesAdded")
        public Collection<VulnResourceModel> getVulnerabilitiesAdded() {
            return this.vulnerabilitiesAdded;
        }

        @Override
        @JsonProperty(value="vulnerabilitiesRemoved")
        public Collection<VulnResourceModel> getVulnerabilitiesRemoved() {
            return this.vulnerabilitiesRemoved;
        }

        @Override
        @JsonProperty(value="licensesAdded")
        public Collection<LicenseResourceModel> getLicensesAdded() {
            return this.licensesAdded;
        }

        @Override
        @JsonProperty(value="licensesRemoved")
        public Collection<LicenseResourceModel> getLicensesRemoved() {
            return this.licensesRemoved;
        }

        @Override
        @JsonProperty(value="licenseIssuesFixed")
        public Collection<LicenseIssueResourceModel> getLicenseIssuesFixed() {
            return this.licenseIssuesFixed;
        }

        @Override
        @JsonProperty(value="licenseIssuesIntroduced")
        public Collection<LicenseIssueResourceModel> getLicenseIssuesIntroduced() {
            return this.licenseIssuesIntroduced;
        }

        @Override
        @JsonProperty(value="outOfDateIssuesFixed")
        public Collection<OutOfDateIssueResourceModel> getOutOfDateIssuesFixed() {
            return this.outOfDateIssuesFixed;
        }

        @Override
        @JsonProperty(value="outOfDateIssuesIntroduced")
        public Collection<OutOfDateIssueResourceModel> getOutOfDateIssuesIntroduced() {
            return this.outOfDateIssuesIntroduced;
        }

        @Override
        @JsonProperty(value="vulnIssuesFixed")
        public Collection<VulnIssueResourceModel> getVulnIssuesFixed() {
            return this.vulnIssuesFixed;
        }

        @Override
        @JsonProperty(value="vulnIssuesIntroduced")
        public Collection<VulnIssueResourceModel> getVulnIssuesIntroduced() {
            return this.vulnIssuesIntroduced;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.diffQuery, other.diffQuery) && Objects.equals(this.librariesAdded, other.librariesAdded) && Objects.equals(this.librariesRemoved, other.librariesRemoved) && Objects.equals(this.vulnerabilitiesAdded, other.vulnerabilitiesAdded) && Objects.equals(this.vulnerabilitiesRemoved, other.vulnerabilitiesRemoved) && Objects.equals(this.licensesAdded, other.licensesAdded) && Objects.equals(this.licensesRemoved, other.licensesRemoved) && Objects.equals(this.licenseIssuesFixed, other.licenseIssuesFixed) && Objects.equals(this.licenseIssuesIntroduced, other.licenseIssuesIntroduced) && Objects.equals(this.outOfDateIssuesFixed, other.outOfDateIssuesFixed) && Objects.equals(this.outOfDateIssuesIntroduced, other.outOfDateIssuesIntroduced) && Objects.equals(this.vulnIssuesFixed, other.vulnIssuesFixed) && Objects.equals(this.vulnIssuesIntroduced, other.vulnIssuesIntroduced);
        }

        public int hashCode() {
            return Objects.hash(this.diffQuery, this.librariesAdded, this.librariesRemoved, this.vulnerabilitiesAdded, this.vulnerabilitiesRemoved, this.licensesAdded, this.licensesRemoved, this.licenseIssuesFixed, this.licenseIssuesIntroduced, this.outOfDateIssuesFixed, this.outOfDateIssuesIntroduced, this.vulnIssuesFixed, this.vulnIssuesIntroduced);
        }

        public String toString() {
            return "DiffResponse{diffQuery=" + this.diffQuery + ", librariesAdded=" + this.librariesAdded + ", librariesRemoved=" + this.librariesRemoved + ", vulnerabilitiesAdded=" + this.vulnerabilitiesAdded + ", vulnerabilitiesRemoved=" + this.vulnerabilitiesRemoved + ", licensesAdded=" + this.licensesAdded + ", licensesRemoved=" + this.licensesRemoved + ", licenseIssuesFixed=" + this.licenseIssuesFixed + ", licenseIssuesIntroduced=" + this.licenseIssuesIntroduced + ", outOfDateIssuesFixed=" + this.outOfDateIssuesFixed + ", outOfDateIssuesIntroduced=" + this.outOfDateIssuesIntroduced + ", vulnIssuesFixed=" + this.vulnIssuesFixed + ", vulnIssuesIntroduced=" + this.vulnIssuesIntroduced + "}";
        }
    }

    private static enum Property {
        DIFF_QUERY("diffQuery");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

