/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.diff.IssueLibraryDependencyMode;
import com.sourceclear.api.data.diff.IssueStatus;
import com.sourceclear.api.data.diff.IssueType;
import com.sourceclear.api.data.diff.LicenseIssueResourceModel;
import com.sourceclear.api.data.evidence.CoordinateType;
import java.util.Date;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class LicenseIssueResourceModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private IssueStatus status;
    private IssueType type;
    private IssueLibraryDependencyMode dependencyMode;
    @Nullable
    private Float issueSeverity = null;
    @Nullable
    private String libraryName = null;
    @Nullable
    private String libraryVersion = null;
    @Nullable
    private Date libraryReleaseDate = null;
    @Nullable
    private CoordinateType coordinateType = null;
    @Nullable
    private String coord1 = null;
    @Nullable
    private String coord2 = null;
    @Nullable
    private String latestVersion = null;
    @Nullable
    private Date latestReleaseDate = null;
    @Nullable
    private String commitHash = null;
    private String license;
    private short licenseCount;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    LicenseIssueResourceModel_Builder() {
    }

    public static LicenseIssueResourceModel.Builder from(LicenseIssueResourceModel value) {
        return new LicenseIssueResourceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="status")
    public LicenseIssueResourceModel.Builder setStatus(IssueStatus status) {
        this.status = (IssueStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this._unsetProperties.remove((Object)Property.STATUS);
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapStatus(UnaryOperator<IssueStatus> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setStatus((IssueStatus)((Object)mapper.apply(this.getStatus())));
    }

    public IssueStatus getStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.STATUS) ? 1 : 0) != 0, (Object)"status not set");
        return this.status;
    }

    @JsonProperty(value="type")
    public LicenseIssueResourceModel.Builder setType(IssueType type) {
        this.type = (IssueType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this._unsetProperties.remove((Object)Property.TYPE);
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapType(UnaryOperator<IssueType> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setType((IssueType)((Object)mapper.apply(this.getType())));
    }

    public IssueType getType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TYPE) ? 1 : 0) != 0, (Object)"type not set");
        return this.type;
    }

    @JsonProperty(value="dependencyMode")
    public LicenseIssueResourceModel.Builder setDependencyMode(IssueLibraryDependencyMode dependencyMode) {
        this.dependencyMode = (IssueLibraryDependencyMode)((Object)Preconditions.checkNotNull((Object)((Object)dependencyMode)));
        this._unsetProperties.remove((Object)Property.DEPENDENCY_MODE);
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapDependencyMode(UnaryOperator<IssueLibraryDependencyMode> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setDependencyMode((IssueLibraryDependencyMode)((Object)mapper.apply(this.getDependencyMode())));
    }

    public IssueLibraryDependencyMode getDependencyMode() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? 1 : 0) != 0, (Object)"dependencyMode not set");
        return this.dependencyMode;
    }

    @JsonProperty(value="issueSeverity")
    public LicenseIssueResourceModel.Builder setIssueSeverity(@Nullable Float issueSeverity) {
        this.issueSeverity = issueSeverity;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapIssueSeverity(UnaryOperator<Float> mapper) {
        Preconditions.checkNotNull(mapper);
        Float issueSeverity = this.getIssueSeverity();
        if (issueSeverity != null) {
            this.setIssueSeverity((Float)mapper.apply(issueSeverity));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public Float getIssueSeverity() {
        return this.issueSeverity;
    }

    @JsonProperty(value="libraryName")
    public LicenseIssueResourceModel.Builder setLibraryName(@Nullable String libraryName) {
        this.libraryName = libraryName;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapLibraryName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String libraryName = this.getLibraryName();
        if (libraryName != null) {
            this.setLibraryName((String)mapper.apply(libraryName));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getLibraryName() {
        return this.libraryName;
    }

    @JsonProperty(value="libraryVersion")
    public LicenseIssueResourceModel.Builder setLibraryVersion(@Nullable String libraryVersion) {
        this.libraryVersion = libraryVersion;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapLibraryVersion(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String libraryVersion = this.getLibraryVersion();
        if (libraryVersion != null) {
            this.setLibraryVersion((String)mapper.apply(libraryVersion));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    @JsonProperty(value="libraryReleaseDate")
    public LicenseIssueResourceModel.Builder setLibraryReleaseDate(@Nullable Date libraryReleaseDate) {
        this.libraryReleaseDate = libraryReleaseDate;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapLibraryReleaseDate(UnaryOperator<Date> mapper) {
        Preconditions.checkNotNull(mapper);
        Date libraryReleaseDate = this.getLibraryReleaseDate();
        if (libraryReleaseDate != null) {
            this.setLibraryReleaseDate((Date)mapper.apply(libraryReleaseDate));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public Date getLibraryReleaseDate() {
        return this.libraryReleaseDate;
    }

    @JsonProperty(value="coordinateType")
    public LicenseIssueResourceModel.Builder setCoordinateType(@Nullable CoordinateType coordinateType) {
        this.coordinateType = coordinateType;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapCoordinateType(UnaryOperator<CoordinateType> mapper) {
        Preconditions.checkNotNull(mapper);
        CoordinateType coordinateType = this.getCoordinateType();
        if (coordinateType != null) {
            this.setCoordinateType((CoordinateType)((Object)mapper.apply(coordinateType)));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public CoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    @JsonProperty(value="coord1")
    public LicenseIssueResourceModel.Builder setCoord1(@Nullable String coord1) {
        this.coord1 = coord1;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapCoord1(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String coord1 = this.getCoord1();
        if (coord1 != null) {
            this.setCoord1((String)mapper.apply(coord1));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getCoord1() {
        return this.coord1;
    }

    @JsonProperty(value="coord2")
    public LicenseIssueResourceModel.Builder setCoord2(@Nullable String coord2) {
        this.coord2 = coord2;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapCoord2(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String coord2 = this.getCoord2();
        if (coord2 != null) {
            this.setCoord2((String)mapper.apply(coord2));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getCoord2() {
        return this.coord2;
    }

    @JsonProperty(value="latestVersion")
    public LicenseIssueResourceModel.Builder setLatestVersion(@Nullable String latestVersion) {
        this.latestVersion = latestVersion;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapLatestVersion(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String latestVersion = this.getLatestVersion();
        if (latestVersion != null) {
            this.setLatestVersion((String)mapper.apply(latestVersion));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @JsonProperty(value="latestReleaseDate")
    public LicenseIssueResourceModel.Builder setLatestReleaseDate(@Nullable Date latestReleaseDate) {
        this.latestReleaseDate = latestReleaseDate;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapLatestReleaseDate(UnaryOperator<Date> mapper) {
        Preconditions.checkNotNull(mapper);
        Date latestReleaseDate = this.getLatestReleaseDate();
        if (latestReleaseDate != null) {
            this.setLatestReleaseDate((Date)mapper.apply(latestReleaseDate));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public Date getLatestReleaseDate() {
        return this.latestReleaseDate;
    }

    @JsonProperty(value="commitHash")
    public LicenseIssueResourceModel.Builder setCommitHash(@Nullable String commitHash) {
        this.commitHash = commitHash;
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapCommitHash(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String commitHash = this.getCommitHash();
        if (commitHash != null) {
            this.setCommitHash((String)mapper.apply(commitHash));
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getCommitHash() {
        return this.commitHash;
    }

    @JsonProperty(value="license")
    public LicenseIssueResourceModel.Builder setLicense(String license) {
        this.license = (String)Preconditions.checkNotNull((Object)license);
        this._unsetProperties.remove((Object)Property.LICENSE);
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapLicense(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setLicense((String)mapper.apply(this.getLicense()));
    }

    public String getLicense() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LICENSE) ? 1 : 0) != 0, (Object)"license not set");
        return this.license;
    }

    @JsonProperty(value="licenseCount")
    public LicenseIssueResourceModel.Builder setLicenseCount(short licenseCount) {
        this.licenseCount = licenseCount;
        this._unsetProperties.remove((Object)Property.LICENSE_COUNT);
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mapLicenseCount(UnaryOperator<Short> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setLicenseCount((Short)mapper.apply(this.getLicenseCount()));
    }

    public short getLicenseCount() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LICENSE_COUNT) ? 1 : 0) != 0, (Object)"licenseCount not set");
        return this.licenseCount;
    }

    public LicenseIssueResourceModel.Builder mergeFrom(LicenseIssueResourceModel value) {
        LicenseIssueResourceModel.Builder _defaults = new LicenseIssueResourceModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.STATUS) || !Objects.equals((Object)value.getStatus(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getStatus())) {
            this.setStatus(value.getStatus());
        }
        if (_defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals((Object)value.getType(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getType())) {
            this.setType(value.getType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !Objects.equals((Object)value.getDependencyMode(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getDependencyMode())) {
            this.setDependencyMode(value.getDependencyMode());
        }
        if (!Objects.equals(value.getIssueSeverity(), ((LicenseIssueResourceModel_Builder)_defaults).getIssueSeverity())) {
            this.setIssueSeverity(value.getIssueSeverity());
        }
        if (!Objects.equals(value.getLibraryName(), ((LicenseIssueResourceModel_Builder)_defaults).getLibraryName())) {
            this.setLibraryName(value.getLibraryName());
        }
        if (!Objects.equals(value.getLibraryVersion(), ((LicenseIssueResourceModel_Builder)_defaults).getLibraryVersion())) {
            this.setLibraryVersion(value.getLibraryVersion());
        }
        if (!Objects.equals(value.getLibraryReleaseDate(), ((LicenseIssueResourceModel_Builder)_defaults).getLibraryReleaseDate())) {
            this.setLibraryReleaseDate(value.getLibraryReleaseDate());
        }
        if (!Objects.equals((Object)value.getCoordinateType(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getCoordinateType())) {
            this.setCoordinateType(value.getCoordinateType());
        }
        if (!Objects.equals(value.getCoord1(), ((LicenseIssueResourceModel_Builder)_defaults).getCoord1())) {
            this.setCoord1(value.getCoord1());
        }
        if (!Objects.equals(value.getCoord2(), ((LicenseIssueResourceModel_Builder)_defaults).getCoord2())) {
            this.setCoord2(value.getCoord2());
        }
        if (!Objects.equals(value.getLatestVersion(), ((LicenseIssueResourceModel_Builder)_defaults).getLatestVersion())) {
            this.setLatestVersion(value.getLatestVersion());
        }
        if (!Objects.equals(value.getLatestReleaseDate(), ((LicenseIssueResourceModel_Builder)_defaults).getLatestReleaseDate())) {
            this.setLatestReleaseDate(value.getLatestReleaseDate());
        }
        if (!Objects.equals(value.getCommitHash(), ((LicenseIssueResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(value.getCommitHash());
        }
        if (_defaults._unsetProperties.contains((Object)Property.LICENSE) || !Objects.equals(value.getLicense(), ((LicenseIssueResourceModel_Builder)_defaults).getLicense())) {
            this.setLicense(value.getLicense());
        }
        if (_defaults._unsetProperties.contains((Object)Property.LICENSE_COUNT) || !Objects.equals(value.getLicenseCount(), ((LicenseIssueResourceModel_Builder)_defaults).getLicenseCount())) {
            this.setLicenseCount(value.getLicenseCount());
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder mergeFrom(LicenseIssueResourceModel.Builder template) {
        LicenseIssueResourceModel.Builder base = template;
        LicenseIssueResourceModel.Builder _defaults = new LicenseIssueResourceModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.STATUS) || !_defaults._unsetProperties.contains((Object)Property.STATUS) && Objects.equals((Object)template.getStatus(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getStatus()))) {
            this.setStatus(template.getStatus());
        }
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !_defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals((Object)template.getType(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getType()))) {
            this.setType(template.getType());
        }
        if (!(base._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) && Objects.equals((Object)template.getDependencyMode(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getDependencyMode()))) {
            this.setDependencyMode(template.getDependencyMode());
        }
        if (!Objects.equals(template.getIssueSeverity(), ((LicenseIssueResourceModel_Builder)_defaults).getIssueSeverity())) {
            this.setIssueSeverity(template.getIssueSeverity());
        }
        if (!Objects.equals(template.getLibraryName(), ((LicenseIssueResourceModel_Builder)_defaults).getLibraryName())) {
            this.setLibraryName(template.getLibraryName());
        }
        if (!Objects.equals(template.getLibraryVersion(), ((LicenseIssueResourceModel_Builder)_defaults).getLibraryVersion())) {
            this.setLibraryVersion(template.getLibraryVersion());
        }
        if (!Objects.equals(template.getLibraryReleaseDate(), ((LicenseIssueResourceModel_Builder)_defaults).getLibraryReleaseDate())) {
            this.setLibraryReleaseDate(template.getLibraryReleaseDate());
        }
        if (!Objects.equals((Object)template.getCoordinateType(), (Object)((LicenseIssueResourceModel_Builder)_defaults).getCoordinateType())) {
            this.setCoordinateType(template.getCoordinateType());
        }
        if (!Objects.equals(template.getCoord1(), ((LicenseIssueResourceModel_Builder)_defaults).getCoord1())) {
            this.setCoord1(template.getCoord1());
        }
        if (!Objects.equals(template.getCoord2(), ((LicenseIssueResourceModel_Builder)_defaults).getCoord2())) {
            this.setCoord2(template.getCoord2());
        }
        if (!Objects.equals(template.getLatestVersion(), ((LicenseIssueResourceModel_Builder)_defaults).getLatestVersion())) {
            this.setLatestVersion(template.getLatestVersion());
        }
        if (!Objects.equals(template.getLatestReleaseDate(), ((LicenseIssueResourceModel_Builder)_defaults).getLatestReleaseDate())) {
            this.setLatestReleaseDate(template.getLatestReleaseDate());
        }
        if (!Objects.equals(template.getCommitHash(), ((LicenseIssueResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(template.getCommitHash());
        }
        if (!(base._unsetProperties.contains((Object)Property.LICENSE) || !_defaults._unsetProperties.contains((Object)Property.LICENSE) && Objects.equals(template.getLicense(), ((LicenseIssueResourceModel_Builder)_defaults).getLicense()))) {
            this.setLicense(template.getLicense());
        }
        if (!(base._unsetProperties.contains((Object)Property.LICENSE_COUNT) || !_defaults._unsetProperties.contains((Object)Property.LICENSE_COUNT) && Objects.equals(template.getLicenseCount(), ((LicenseIssueResourceModel_Builder)_defaults).getLicenseCount()))) {
            this.setLicenseCount(template.getLicenseCount());
        }
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel.Builder clear() {
        LicenseIssueResourceModel.Builder _defaults = new LicenseIssueResourceModel.Builder();
        this.status = _defaults.status;
        this.type = _defaults.type;
        this.dependencyMode = _defaults.dependencyMode;
        this.issueSeverity = _defaults.issueSeverity;
        this.libraryName = _defaults.libraryName;
        this.libraryVersion = _defaults.libraryVersion;
        this.libraryReleaseDate = _defaults.libraryReleaseDate;
        this.coordinateType = _defaults.coordinateType;
        this.coord1 = _defaults.coord1;
        this.coord2 = _defaults.coord2;
        this.latestVersion = _defaults.latestVersion;
        this.latestReleaseDate = _defaults.latestReleaseDate;
        this.commitHash = _defaults.commitHash;
        this.license = _defaults.license;
        this.licenseCount = _defaults.licenseCount;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (LicenseIssueResourceModel.Builder)this;
    }

    public LicenseIssueResourceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public LicenseIssueResourceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements LicenseIssueResourceModel {
        private final IssueStatus status;
        private final IssueType type;
        private final IssueLibraryDependencyMode dependencyMode;
        @Nullable
        private final Float issueSeverity;
        @Nullable
        private final String libraryName;
        @Nullable
        private final String libraryVersion;
        @Nullable
        private final Date libraryReleaseDate;
        @Nullable
        private final CoordinateType coordinateType;
        @Nullable
        private final String coord1;
        @Nullable
        private final String coord2;
        @Nullable
        private final String latestVersion;
        @Nullable
        private final Date latestReleaseDate;
        @Nullable
        private final String commitHash;
        private final String license;
        private final short licenseCount;
        private final EnumSet<Property> _unsetProperties;

        Partial(LicenseIssueResourceModel_Builder builder) {
            this.status = builder.status;
            this.type = builder.type;
            this.dependencyMode = builder.dependencyMode;
            this.issueSeverity = builder.issueSeverity;
            this.libraryName = builder.libraryName;
            this.libraryVersion = builder.libraryVersion;
            this.libraryReleaseDate = builder.libraryReleaseDate;
            this.coordinateType = builder.coordinateType;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.latestVersion = builder.latestVersion;
            this.latestReleaseDate = builder.latestReleaseDate;
            this.commitHash = builder.commitHash;
            this.license = builder.license;
            this.licenseCount = builder.licenseCount;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="status")
        public IssueStatus getStatus() {
            if (this._unsetProperties.contains((Object)Property.STATUS)) {
                throw new UnsupportedOperationException("status not set");
            }
            return this.status;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            if (this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE)) {
                throw new UnsupportedOperationException("dependencyMode not set");
            }
            return this.dependencyMode;
        }

        @Override
        @JsonProperty(value="issueSeverity")
        @Nullable
        public Float getIssueSeverity() {
            return this.issueSeverity;
        }

        @Override
        @JsonProperty(value="libraryName")
        @Nullable
        public String getLibraryName() {
            return this.libraryName;
        }

        @Override
        @JsonProperty(value="libraryVersion")
        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        @Override
        @JsonProperty(value="libraryReleaseDate")
        @Nullable
        public Date getLibraryReleaseDate() {
            return this.libraryReleaseDate;
        }

        @Override
        @JsonProperty(value="coordinateType")
        @Nullable
        public CoordinateType getCoordinateType() {
            return this.coordinateType;
        }

        @Override
        @JsonProperty(value="coord1")
        @Nullable
        public String getCoord1() {
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        @Nullable
        public String getCoord2() {
            return this.coord2;
        }

        @Override
        @JsonProperty(value="latestVersion")
        @Nullable
        public String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        @JsonProperty(value="latestReleaseDate")
        @Nullable
        public Date getLatestReleaseDate() {
            return this.latestReleaseDate;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="license")
        public String getLicense() {
            if (this._unsetProperties.contains((Object)Property.LICENSE)) {
                throw new UnsupportedOperationException("license not set");
            }
            return this.license;
        }

        @Override
        @JsonProperty(value="licenseCount")
        public short getLicenseCount() {
            if (this._unsetProperties.contains((Object)Property.LICENSE_COUNT)) {
                throw new UnsupportedOperationException("licenseCount not set");
            }
            return this.licenseCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode) && Objects.equals(this.issueSeverity, other.issueSeverity) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.libraryReleaseDate, other.libraryReleaseDate) && Objects.equals((Object)this.coordinateType, (Object)other.coordinateType) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals(this.latestVersion, other.latestVersion) && Objects.equals(this.latestReleaseDate, other.latestReleaseDate) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals(this.license, other.license) && Objects.equals(this.licenseCount, other.licenseCount) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.type, this.dependencyMode, this.issueSeverity, this.libraryName, this.libraryVersion, this.libraryReleaseDate, this.coordinateType, this.coord1, this.coord2, this.latestVersion, this.latestReleaseDate, this.commitHash, this.license, this.licenseCount, this._unsetProperties});
        }

        public String toString() {
            return "partial LicenseIssueResourceModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.STATUS) ? "status=" + (Object)((Object)this.status) : null), (Object)(!this._unsetProperties.contains((Object)Property.TYPE) ? "type=" + (Object)((Object)this.type) : null), new Object[]{!this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? "dependencyMode=" + (Object)((Object)this.dependencyMode) : null, this.issueSeverity != null ? "issueSeverity=" + this.issueSeverity : null, this.libraryName != null ? "libraryName=" + this.libraryName : null, this.libraryVersion != null ? "libraryVersion=" + this.libraryVersion : null, this.libraryReleaseDate != null ? "libraryReleaseDate=" + this.libraryReleaseDate : null, this.coordinateType != null ? "coordinateType=" + (Object)((Object)this.coordinateType) : null, this.coord1 != null ? "coord1=" + this.coord1 : null, this.coord2 != null ? "coord2=" + this.coord2 : null, this.latestVersion != null ? "latestVersion=" + this.latestVersion : null, this.latestReleaseDate != null ? "latestReleaseDate=" + this.latestReleaseDate : null, this.commitHash != null ? "commitHash=" + this.commitHash : null, !this._unsetProperties.contains((Object)Property.LICENSE) ? "license=" + this.license : null, !this._unsetProperties.contains((Object)Property.LICENSE_COUNT) ? "licenseCount=" + this.licenseCount : null}) + "}";
        }
    }

    private static final class Value
    implements LicenseIssueResourceModel {
        private final IssueStatus status;
        private final IssueType type;
        private final IssueLibraryDependencyMode dependencyMode;
        @Nullable
        private final Float issueSeverity;
        @Nullable
        private final String libraryName;
        @Nullable
        private final String libraryVersion;
        @Nullable
        private final Date libraryReleaseDate;
        @Nullable
        private final CoordinateType coordinateType;
        @Nullable
        private final String coord1;
        @Nullable
        private final String coord2;
        @Nullable
        private final String latestVersion;
        @Nullable
        private final Date latestReleaseDate;
        @Nullable
        private final String commitHash;
        private final String license;
        private final short licenseCount;

        private Value(LicenseIssueResourceModel_Builder builder) {
            this.status = builder.status;
            this.type = builder.type;
            this.dependencyMode = builder.dependencyMode;
            this.issueSeverity = builder.issueSeverity;
            this.libraryName = builder.libraryName;
            this.libraryVersion = builder.libraryVersion;
            this.libraryReleaseDate = builder.libraryReleaseDate;
            this.coordinateType = builder.coordinateType;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.latestVersion = builder.latestVersion;
            this.latestReleaseDate = builder.latestReleaseDate;
            this.commitHash = builder.commitHash;
            this.license = builder.license;
            this.licenseCount = builder.licenseCount;
        }

        @Override
        @JsonProperty(value="status")
        public IssueStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            return this.dependencyMode;
        }

        @Override
        @JsonProperty(value="issueSeverity")
        @Nullable
        public Float getIssueSeverity() {
            return this.issueSeverity;
        }

        @Override
        @JsonProperty(value="libraryName")
        @Nullable
        public String getLibraryName() {
            return this.libraryName;
        }

        @Override
        @JsonProperty(value="libraryVersion")
        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        @Override
        @JsonProperty(value="libraryReleaseDate")
        @Nullable
        public Date getLibraryReleaseDate() {
            return this.libraryReleaseDate;
        }

        @Override
        @JsonProperty(value="coordinateType")
        @Nullable
        public CoordinateType getCoordinateType() {
            return this.coordinateType;
        }

        @Override
        @JsonProperty(value="coord1")
        @Nullable
        public String getCoord1() {
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        @Nullable
        public String getCoord2() {
            return this.coord2;
        }

        @Override
        @JsonProperty(value="latestVersion")
        @Nullable
        public String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        @JsonProperty(value="latestReleaseDate")
        @Nullable
        public Date getLatestReleaseDate() {
            return this.latestReleaseDate;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="license")
        public String getLicense() {
            return this.license;
        }

        @Override
        @JsonProperty(value="licenseCount")
        public short getLicenseCount() {
            return this.licenseCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode) && Objects.equals(this.issueSeverity, other.issueSeverity) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.libraryReleaseDate, other.libraryReleaseDate) && Objects.equals((Object)this.coordinateType, (Object)other.coordinateType) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals(this.latestVersion, other.latestVersion) && Objects.equals(this.latestReleaseDate, other.latestReleaseDate) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals(this.license, other.license) && Objects.equals(this.licenseCount, other.licenseCount);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.type, this.dependencyMode, this.issueSeverity, this.libraryName, this.libraryVersion, this.libraryReleaseDate, this.coordinateType, this.coord1, this.coord2, this.latestVersion, this.latestReleaseDate, this.commitHash, this.license, this.licenseCount});
        }

        public String toString() {
            return "LicenseIssueResourceModel{" + COMMA_JOINER.join((Object)("status=" + (Object)((Object)this.status)), (Object)("type=" + (Object)((Object)this.type)), new Object[]{"dependencyMode=" + (Object)((Object)this.dependencyMode), this.issueSeverity != null ? "issueSeverity=" + this.issueSeverity : null, this.libraryName != null ? "libraryName=" + this.libraryName : null, this.libraryVersion != null ? "libraryVersion=" + this.libraryVersion : null, this.libraryReleaseDate != null ? "libraryReleaseDate=" + this.libraryReleaseDate : null, this.coordinateType != null ? "coordinateType=" + (Object)((Object)this.coordinateType) : null, this.coord1 != null ? "coord1=" + this.coord1 : null, this.coord2 != null ? "coord2=" + this.coord2 : null, this.latestVersion != null ? "latestVersion=" + this.latestVersion : null, this.latestReleaseDate != null ? "latestReleaseDate=" + this.latestReleaseDate : null, this.commitHash != null ? "commitHash=" + this.commitHash : null, "license=" + this.license, "licenseCount=" + this.licenseCount}) + "}";
        }
    }

    private static enum Property {
        STATUS("status"),
        TYPE("type"),
        DEPENDENCY_MODE("dependencyMode"),
        LICENSE("license"),
        LICENSE_COUNT("licenseCount");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

