/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.diff.LicenseResourceModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class LicenseResourceModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private String name;
    private boolean gpl;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    LicenseResourceModel_Builder() {
    }

    public static LicenseResourceModel.Builder from(LicenseResourceModel value) {
        return new LicenseResourceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="name")
    public LicenseResourceModel.Builder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (LicenseResourceModel.Builder)this;
    }

    public LicenseResourceModel.Builder mapName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    @JsonProperty(value="gpl")
    public LicenseResourceModel.Builder setGpl(boolean gpl) {
        this.gpl = gpl;
        this._unsetProperties.remove((Object)Property.GPL);
        return (LicenseResourceModel.Builder)this;
    }

    public LicenseResourceModel.Builder mapGpl(UnaryOperator<Boolean> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setGpl((Boolean)mapper.apply(this.isGpl()));
    }

    public boolean isGpl() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.GPL) ? 1 : 0) != 0, (Object)"gpl not set");
        return this.gpl;
    }

    public LicenseResourceModel.Builder mergeFrom(LicenseResourceModel value) {
        LicenseResourceModel.Builder _defaults = new LicenseResourceModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((LicenseResourceModel_Builder)_defaults).getName())) {
            this.setName(value.getName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.GPL) || !Objects.equals(value.isGpl(), ((LicenseResourceModel_Builder)_defaults).isGpl())) {
            this.setGpl(value.isGpl());
        }
        return (LicenseResourceModel.Builder)this;
    }

    public LicenseResourceModel.Builder mergeFrom(LicenseResourceModel.Builder template) {
        LicenseResourceModel.Builder base = template;
        LicenseResourceModel.Builder _defaults = new LicenseResourceModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((LicenseResourceModel_Builder)_defaults).getName()))) {
            this.setName(template.getName());
        }
        if (!(base._unsetProperties.contains((Object)Property.GPL) || !_defaults._unsetProperties.contains((Object)Property.GPL) && Objects.equals(template.isGpl(), ((LicenseResourceModel_Builder)_defaults).isGpl()))) {
            this.setGpl(template.isGpl());
        }
        return (LicenseResourceModel.Builder)this;
    }

    public LicenseResourceModel.Builder clear() {
        LicenseResourceModel.Builder _defaults = new LicenseResourceModel.Builder();
        this.name = _defaults.name;
        this.gpl = _defaults.gpl;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (LicenseResourceModel.Builder)this;
    }

    public LicenseResourceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public LicenseResourceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements LicenseResourceModel {
        private final String name;
        private final boolean gpl;
        private final EnumSet<Property> _unsetProperties;

        Partial(LicenseResourceModel_Builder builder) {
            this.name = builder.name;
            this.gpl = builder.gpl;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        @JsonProperty(value="gpl")
        public boolean isGpl() {
            if (this._unsetProperties.contains((Object)Property.GPL)) {
                throw new UnsupportedOperationException("gpl not set");
            }
            return this.gpl;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.gpl, other.gpl) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.gpl, this._unsetProperties);
        }

        public String toString() {
            return "partial LicenseResourceModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null), !this._unsetProperties.contains((Object)Property.GPL) ? "gpl=" + this.gpl : null, new Object[0]) + "}";
        }
    }

    private static final class Value
    implements LicenseResourceModel {
        private final String name;
        private final boolean gpl;

        private Value(LicenseResourceModel_Builder builder) {
            this.name = builder.name;
            this.gpl = builder.gpl;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @JsonProperty(value="gpl")
        public boolean isGpl() {
            return this.gpl;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.gpl, other.gpl);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.gpl);
        }

        public String toString() {
            return "LicenseResourceModel{name=" + this.name + ", gpl=" + this.gpl + "}";
        }
    }

    private static enum Property {
        NAME("name"),
        GPL("gpl");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

