/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.RepoModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class RepoModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private long id;
    private String name;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    RepoModel_Builder() {
    }

    public static RepoModel.Builder from(RepoModel value) {
        return new RepoModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public RepoModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder mapId(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setId((Long)mapper.apply(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="name")
    public RepoModel.Builder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder mapName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    public RepoModel.Builder mergeFrom(RepoModel value) {
        RepoModel.Builder _defaults = new RepoModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.ID) || !Objects.equals(value.getId(), ((RepoModel_Builder)_defaults).getId())) {
            this.setId(value.getId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((RepoModel_Builder)_defaults).getName())) {
            this.setName(value.getName());
        }
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder mergeFrom(RepoModel.Builder template) {
        RepoModel.Builder base = template;
        RepoModel.Builder _defaults = new RepoModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.ID) || !_defaults._unsetProperties.contains((Object)Property.ID) && Objects.equals(template.getId(), ((RepoModel_Builder)_defaults).getId()))) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((RepoModel_Builder)_defaults).getName()))) {
            this.setName(template.getName());
        }
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder clear() {
        RepoModel.Builder _defaults = new RepoModel.Builder();
        this.id = _defaults.id;
        this.name = _defaults.name;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (RepoModel.Builder)this;
    }

    public RepoModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public RepoModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements RepoModel {
        private final long id;
        private final String name;
        private final EnumSet<Property> _unsetProperties;

        Partial(RepoModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this._unsetProperties);
        }

        public String toString() {
            return "partial RepoModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.ID) ? "id=" + this.id : null), !this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null, new Object[0]) + "}";
        }
    }

    private static final class Value
    implements RepoModel {
        private final long id;
        private final String name;

        private Value(RepoModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "RepoModel{id=" + this.id + ", name=" + this.name + "}";
        }
    }

    private static enum Property {
        ID("id"),
        NAME("name");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

