/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.sourceclear.api.data.methods.CallChainModelHelper;
import com.sourceclear.api.data.methods.CallSiteModel;
import com.sourceclear.api.data.methods.MethodModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(using=CallChainModelHelper.CallChainSerializer.class)
@JsonDeserialize(using=CallChainModelHelper.CallChainDeserializer.class)
public class CallChainModel
implements Iterable<CallSiteModel> {
    private Collection<CallSiteModel> callSites;

    public void addCallSite(CallSiteModel callSite) {
        if (this.callSites == null) {
            this.callSites = new ArrayList<CallSiteModel>();
        }
        this.callSites.add(callSite);
    }

    @JsonIgnore
    public MethodModel getTargetMethod() {
        if (this.callSites == null || this.callSites.isEmpty()) {
            return null;
        }
        return ((CallSiteModel)Iterables.getLast(this.callSites)).getCallee();
    }

    @Override
    public Iterator<CallSiteModel> iterator() {
        return this.callSites != null ? Iterators.unmodifiableIterator(this.callSites.iterator()) : Collections.emptyIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallChainModel that = (CallChainModel)o;
        return Objects.equals(this.callSites, that.callSites);
    }

    public int hashCode() {
        return Objects.hash(this.callSites);
    }

    Collection<CallSiteModel> getCallSites() {
        return Collections.unmodifiableCollection(this.callSites);
    }

    void setCallSites(Collection<CallSiteModel> callSites) {
        this.callSites = new ArrayList<CallSiteModel>(callSites);
    }

    public int size() {
        return this.callSites != null ? this.callSites.size() : 0;
    }
}

