/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common.clone;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloneManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloneManager.class);
    private final Map<String, CloneEntry> futures = Maps.newConcurrentMap();
    private final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);

    public void shutdown() {
        this.service.shutdown();
        for (Map.Entry entry : Sets.newHashSet(this.futures.entrySet())) {
            ((CloneEntry)entry.getValue()).future.cancel(false);
            this.deleteNow((String)entry.getKey());
        }
        try {
            this.service.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.info("Couldn't await executor shutdown.", (Throwable)ex);
        }
    }

    public void scheduleDeletion(String id, final Path path, long duration) {
        ScheduledFuture<Void> future = this.service.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FileUtils.deleteQuietly((File)path.toFile());
                return null;
            }
        }, duration, TimeUnit.MILLISECONDS);
        this.futures.put(id, new CloneEntry(path, future));
    }

    public Path cancelDeletion(String id) {
        CloneEntry entry = this.futures.remove(id);
        if (entry != null) {
            LOGGER.info("Canceling scheduled deletion for {} - {}.", (Object)id, (Object)entry.path);
            entry.future.cancel(false);
            return entry.path;
        }
        LOGGER.debug("Ignoring cancellation request for non-existent scan {}.", (Object)id);
        return null;
    }

    public void deleteNow(String id) {
        CloneEntry entry = this.futures.get(id);
        this.cancelDeletion(id);
        if (entry != null) {
            FileUtils.deleteQuietly((File)entry.path.toFile());
            LOGGER.info("Immediately deleting {} - {}.", (Object)id, (Object)entry.path);
        } else {
            LOGGER.debug("Ignoring deletion request for non-existent clone {}.", (Object)id);
        }
    }

    private static class CloneEntry {
        private final Path path;
        private final ScheduledFuture<Void> future;

        private CloneEntry(Path path, ScheduledFuture<Void> future) {
            this.path = path;
            this.future = future;
        }
    }
}

