/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.util.io.EvidenceUtils;
import com.srcclr.sdk.LibraryGraphContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionResult {
    private final LibraryGraphContainer graphs;
    private final ImmutableMap<String, Object> scanAttributes;
    private final ImmutableSet<Evidence> evidence;
    private final int filesScanned;
    private final boolean methodsSupported;
    private final Long lineCount;
    private final AgentRuntimeData agentRuntimeData;
    private final List<Advice> advice;

    private CollectionResult(Builder builder) {
        this.graphs = builder.graphs;
        this.scanAttributes = builder.scanAttributes;
        this.evidence = ImmutableSet.copyOf((Collection)builder.evidence);
        this.filesScanned = builder.filesScanned;
        this.methodsSupported = builder.methodsSupported;
        this.lineCount = builder.lineCount;
        this.agentRuntimeData = builder.agentRuntimeData;
        this.advice = builder.advice;
    }

    public ImmutableSet<Evidence> getEvidence() {
        return this.evidence;
    }

    public ImmutableMap<String, Object> getScanAttributes() {
        return this.scanAttributes;
    }

    public int getFilesScanned() {
        return this.filesScanned;
    }

    public boolean isMethodsSupported() {
        return this.methodsSupported;
    }

    public Long getLineCount() {
        return this.lineCount;
    }

    public LibraryGraphContainer getGraphs() {
        return this.graphs;
    }

    @Nullable
    public AgentRuntimeData getAgentRuntimeData() {
        return this.agentRuntimeData;
    }

    public List<Advice> getAdvice() {
        return this.advice;
    }

    public static class Builder {
        private Set<Evidence> evidence = Sets.newHashSet();
        private LibraryGraphContainer graphs = null;
        private int filesScanned = 0;
        private boolean methodsSupported = false;
        private Long lineCount;
        private ImmutableMap<String, Object> scanAttributes = ImmutableMap.of();
        private AgentRuntimeData agentRuntimeData;
        private List<Advice> advice = new ArrayList<Advice>();

        @Deprecated
        public Builder withEvidence(Evidence e) {
            this.evidence.add(e);
            return this;
        }

        public Builder withScanAttributes(ImmutableMap<String, Object> scanAttributes) {
            this.scanAttributes = scanAttributes;
            return this;
        }

        public Builder withGraphs(LibraryGraphContainer graphs) {
            this.graphs = graphs;
            this.evidence = ImmutableSet.copyOf(EvidenceUtils.evidenceFromLibraryGraphs(graphs.getGraphs()));
            return this;
        }

        public Builder withFilesScanned(int filesScanned) {
            this.filesScanned += filesScanned;
            return this;
        }

        public Builder withLineCount(long lineCount) {
            this.lineCount = this.lineCount == null ? lineCount : this.lineCount + lineCount;
            return this;
        }

        public Builder withMethodsSupported(boolean methodsSupported) {
            this.methodsSupported = methodsSupported;
            return this;
        }

        public Builder withAgentRuntimeData(AgentRuntimeData agentRuntimeData) {
            this.agentRuntimeData = agentRuntimeData;
            return this;
        }

        public Builder withAdvice(@Nonnull List<Advice> advice) {
            this.advice = advice;
            return this;
        }

        public CollectionResult build() {
            return new CollectionResult(this);
        }
    }

    public static class Advice {
        private final String collectorName;
        private final String advice;

        public Advice(String name, String advice) {
            this.collectorName = name;
            this.advice = advice;
        }

        public String getCollectorName() {
            return this.collectorName;
        }

        public String getAdvice() {
            return this.advice;
        }
    }
}

