/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.evidence.BuildType;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.api.data.evidence.LanguageType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.NoopLogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.ComponentEngine;
import com.sourceclear.engine.component.NativeLocalEngine;
import com.sourceclear.engine.component.QuickscanEngine;
import com.sourceclear.engine.component.RecursiveEngine;
import com.sourceclear.engine.component.collectors.AntNativeCollector;
import com.sourceclear.engine.component.collectors.AutotoolsNativeCollector;
import com.sourceclear.engine.component.collectors.BoostBuildNativeCollector;
import com.sourceclear.engine.component.collectors.BootNativeCollector;
import com.sourceclear.engine.component.collectors.BowerNativeCollector;
import com.sourceclear.engine.component.collectors.BuckNativeCollector;
import com.sourceclear.engine.component.collectors.BuildrNativeCollector;
import com.sourceclear.engine.component.collectors.CMakeNativeCollector;
import com.sourceclear.engine.component.collectors.CocoaPodsNativeCollector;
import com.sourceclear.engine.component.collectors.ComposerNativeCollector;
import com.sourceclear.engine.component.collectors.DLLNativeCollector;
import com.sourceclear.engine.component.collectors.GYPNativeCollector;
import com.sourceclear.engine.component.collectors.GemNativeCollector;
import com.sourceclear.engine.component.collectors.GlideNativeCollector;
import com.sourceclear.engine.component.collectors.GoGetNativeCollector;
import com.sourceclear.engine.component.collectors.GodepNativeCollector;
import com.sourceclear.engine.component.collectors.GolangDepNativeCollector;
import com.sourceclear.engine.component.collectors.GovendorNativeCollector;
import com.sourceclear.engine.component.collectors.GradleNativeCollector;
import com.sourceclear.engine.component.collectors.JarNativeCollector;
import com.sourceclear.engine.component.collectors.LeiningenNativeCollector;
import com.sourceclear.engine.component.collectors.MSBuildDotNetNativeCollector;
import com.sourceclear.engine.component.collectors.MSBuildNativeCollector;
import com.sourceclear.engine.component.collectors.MakefileNativeCollector;
import com.sourceclear.engine.component.collectors.MavenNativeCollector;
import com.sourceclear.engine.component.collectors.NAntNativeCollector;
import com.sourceclear.engine.component.collectors.NPMNativeCollector;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.collectors.PIPNativeCollector;
import com.sourceclear.engine.component.collectors.PantsNativeCollector;
import com.sourceclear.engine.component.collectors.PipenvNativeCollector;
import com.sourceclear.engine.component.collectors.QMakeNativeCollector;
import com.sourceclear.engine.component.collectors.RakeNativeCollector;
import com.sourceclear.engine.component.collectors.SConsNativeCollector;
import com.sourceclear.engine.component.collectors.SOFileNativeCollector;
import com.sourceclear.engine.component.collectors.SbtNativeCollector;
import com.sourceclear.engine.component.collectors.TrashNativeCollector;
import com.sourceclear.engine.component.collectors.YarnNativeCollector;
import com.srcclr.sdk.Directives;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ComponentEngineBuilder {
    public static final String COMPILE_FIRST = "COMPILE_FIRST";
    public static final String INSTALL_FIRST = "INSTALL_FIRST";
    public static final String FORCE_BUNDLE_INSTALL = "FORCE_BUNDLE_INSTALL";
    public static final String CUSTOM_MAVEN_COMMAND = "CUSTOM_MAVEN_COMMAND";
    public static final String CUSTOM_MAVEN_EXEC = "CUSTOM_MAVEN_EXEC";
    public static final String CUSTOM_GRADLE_EXEC = "CUSTOM_GRADLE_EXEC";
    public static final String CUSTOM_ANT_EXEC = "CUSTOM_ANT_EXEC";
    public static final String ANT_BUILD_STEPS = "ANT_BUILD_STEPS";
    public static final String ALLOW_ROOT = "ALLOW_ROOT";
    public static final String ANT_SKIP_BUILD = "ANT_SKIP_BUILD";
    public static final String ANT_LIB_DIR = "ANT_LIB_DIR";
    public static final String IVY_SETTINGS_FILENAME = "IVY_SETTINGS_FILENAME";
    public static final String DISABLE_ANT = "DISABLE_ANT";
    public static final String CLONE_DEPTH = "CLONE_DEPTH";
    public static final String PIP_REQUIREMENTS_FILE = "PIP_REQUIREMENTS_FILE";
    public static final String PIP_EXTRA_FLAGS = "PIP_EXTRA_FLAGS";
    public static final String SYSTEM_SITE_PACKAGES = "SYSTEM_SITE_PACKAGES";
    public static final String USE_SYSTEM_PIP = "USE_SYSTEM_PIP";
    public static final String API_BASE_URI = "API_BASE_URI";
    public static final String GRADLE_LOCATION = "GRADLE_LOCATION";
    public static final String GRADLE_TASKS = "GRADLE_TASKS";
    public static final String GRADLE_FILTER_TASK = "GRADLE_FILTER_TASK";
    public static final String SCOPE = "SCOPE";
    public static final String ENV_VARS = "ENV_VARS";
    public static final String FAIL_ON = "FAIL_ON";
    public static final String PR_ON = "PR_ON";
    public static final String NO_BREAKING_UPDATES = "NO_BREAKING_UPDATES";
    public static final String IGNORE_CLOSED_PRS = "IGNORE_CLOSED_PRS";
    public static final String SBT_PLUGIN_VERSION = "SBT_PLUGIN_VERSION";
    public static final String SCAN_COLLECTORS = "SCAN_COLLECTORS";
    public static final String SKIP_COLLECTORS = "SKIP_COLLECTORS";
    public static final String VULN_METHODS_IGNORED_DIRECTORIES = "VULN_METHODS_IGNORED_DIRECTORIES";
    public static final String VULN_METHODS_EXTRA_IGNORED_DIRECTORIES = "VULN_METHODS_EXTRA_IGNORED_DIRECTORIES";
    public static final String FORCE_GO_INSTALL = "FORCE_GO_INSTALL";
    public static final String IGNORE_GO_DIRS = "IGNORE_GO_DIRS";
    public static final String REPO_URL = "REPO_URL";
    public static final String SKIP_NPM_INSTALL = "SKIP_NPM_INSTALL";
    public static final String SKIP_COMPOSER_INSTALL = "SKIP_COMPOSER_INSTALL";
    public static final String SKIP_PIPENV_INSTALL = "SKIP_PIPENV_INSTALL";
    public static final String MAKE_BUILD_TARGET = "MAKE_BUILD_TARGET";
    public static final String MAKE_CLEAN_TARGET = "MAKE_CLEAN_TARGET";
    public static final String MAKE_OUTPUT_FILE = "MAKE_OUTPUT_FILE";
    public static final String MAX_DEPTH = "MAX_DEPTH";
    public static final String IGNORE_FOLDERS = "IGNORE_FOLDERS";
    public static final String SKIP_DOTNET_RESTORE = "SKIP_DOTNET_RESTORE";
    public static final String USE_DOTNET_EXEC = "USE_DOTNET_EXEC";
    public static final String ENV_VAR_DIRECTIVES_PREFIX = "SRCCLR_";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ComponentEngineBuilder.class.getName());
    private static final int DEFAULT_MAX_PATHS = 5;
    public static final String DIRECTIVES_FILE = "srcclr.yml";
    private LogStream logStream = new NoopLogStream();
    private File projectPath;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private int maxPaths = 5;
    private EngineType engineType = EngineType.NATIVE;
    private boolean recursive = false;

    public static String getDirectivesFile() {
        return String.copyValueOf(DIRECTIVES_FILE.toCharArray());
    }

    private static Map<String, Object> mergeAttributesWithDirectivesFileAndEnvVars(Map<String, Object> attributes, File projectFolder) throws CollectionException {
        Map directives = Collections.emptyMap();
        try {
            File directivesFile = new File(projectFolder, DIRECTIVES_FILE);
            if (directivesFile.exists()) {
                directives = Directives.parseDirectives((InputStream)new FileInputStream(directivesFile));
            }
        }
        catch (IOException | RuntimeException e) {
            String fatalMessage = String.format("Couldn't parse %s.  Please make sure it's readable and is valid YAML.", DIRECTIVES_FILE);
            LOGGER.warn(fatalMessage, (Throwable)e);
            throw new CollectionException(CollectionErrorType.IO, fatalMessage);
        }
        HashMap uppercased = new HashMap();
        for (Map.Entry entry : directives.entrySet()) {
            uppercased.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
        }
        String str = (String)uppercased.get(IGNORE_FOLDERS);
        if (str != null) {
            uppercased.put(IGNORE_FOLDERS, ComponentEngineBuilder.parseCommaValues(str));
        }
        HashMap<String, Object> attributesCopy = new HashMap<String, Object>();
        attributesCopy.putAll(attributes);
        attributesCopy.putAll(uppercased);
        attributesCopy.putAll(ComponentEngineBuilder.getEnvVarDirectives());
        return attributesCopy;
    }

    private static Map<String, Object> getEnvVarDirectives() {
        HashMap<String, Object> directivesFound = new HashMap<String, Object>();
        Map<String, String> envVars = System.getenv();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            if (!entry.getKey().toUpperCase().startsWith(ENV_VAR_DIRECTIVES_PREFIX)) continue;
            String key = entry.getKey().toUpperCase().replace(ENV_VAR_DIRECTIVES_PREFIX, "").trim();
            if (Strings.isNullOrEmpty((String)key)) {
                LOGGER.debug("Ignoring " + entry.getKey() + " because it is an empty string after stripping of prefix.");
                continue;
            }
            if (key.equals(IGNORE_FOLDERS)) {
                directivesFound.put(key, ComponentEngineBuilder.parseCommaValues(entry.getValue()));
                continue;
            }
            directivesFound.put(key, entry.getValue());
        }
        return directivesFound;
    }

    public static Set<String> parseCommaValues(String commaString) {
        HashSet<String> scanBuilds = new HashSet<String>();
        for (String token : commaString.split(",")) {
            if (token.trim().isEmpty()) continue;
            scanBuilds.add(token.trim());
        }
        return scanBuilds;
    }

    public static Set<String> getCollectorsSetUpperCase(String buildsString) {
        Set<String> temp = ComponentEngineBuilder.parseCommaValues(buildsString);
        HashSet<String> scanBuilds = new HashSet<String>();
        for (String str : temp) {
            scanBuilds.add(str.toUpperCase());
        }
        return scanBuilds;
    }

    private static Set<NativeCollector> allNativeCollectors(ImmutableMap<String, Object> attr, LogStream logStream, boolean recursive) {
        return Sets.newHashSet((Object[])new NativeCollector[]{new AntNativeCollector(logStream, attr), new MavenNativeCollector(logStream, attr), new GradleNativeCollector(logStream, attr), new JarNativeCollector(logStream, attr, recursive), new BowerNativeCollector(logStream, attr), new CocoaPodsNativeCollector(logStream, attr), new GemNativeCollector(logStream, attr), new NPMNativeCollector(logStream, attr), new PIPNativeCollector(logStream, attr), new PipenvNativeCollector(logStream, attr), new SbtNativeCollector(logStream, attr), new GlideNativeCollector(logStream, attr), new GodepNativeCollector(logStream, attr), new GovendorNativeCollector(logStream, attr), new TrashNativeCollector(logStream, attr), new GoGetNativeCollector(logStream, attr), new GolangDepNativeCollector(logStream, attr), new YarnNativeCollector(logStream, attr), new ComposerNativeCollector(logStream, attr), new MakefileNativeCollector(logStream, attr), new SOFileNativeCollector(logStream, attr), new MSBuildDotNetNativeCollector(logStream, attr), new DLLNativeCollector(logStream, attr, recursive), new AutotoolsNativeCollector(logStream, attr), new BoostBuildNativeCollector(logStream, attr), new BootNativeCollector(logStream, attr), new BuckNativeCollector(logStream, attr), new BuildrNativeCollector(logStream, attr), new CMakeNativeCollector(logStream, attr), new GYPNativeCollector(logStream, attr), new LeiningenNativeCollector(logStream, attr), new MSBuildNativeCollector(logStream, attr), new NAntNativeCollector(logStream, attr), new PantsNativeCollector(logStream, attr), new QMakeNativeCollector(logStream, attr), new RakeNativeCollector(logStream, attr), new SConsNativeCollector(logStream, attr)});
    }

    static ImmutableSet<NativeCollector> resolveNativeCollectors(ImmutableMap<String, Object> attr, @Nullable File projectPath, LogStream logStream, boolean recursive) {
        Set<NativeCollector> defaultCollectors = ComponentEngineBuilder.allNativeCollectors(attr, logStream, recursive);
        Set<String> collectorsToRun = ComponentEngineBuilder.getCollectorsSetUpperCase(Strings.nullToEmpty((String)((String)attr.get((Object)SCAN_COLLECTORS))));
        LOGGER.debug("collectorsToRun: {}", collectorsToRun);
        HashSet<NativeCollector> toRun = new HashSet<NativeCollector>();
        if (collectorsToRun.isEmpty()) {
            toRun.addAll(defaultCollectors);
        } else {
            for (NativeCollector nativeCollector : defaultCollectors) {
                if (!collectorsToRun.contains(nativeCollector.getName().toUpperCase())) continue;
                toRun.add(nativeCollector);
            }
        }
        Set<String> collectorsToSkip = ComponentEngineBuilder.getCollectorsSetUpperCase(Strings.nullToEmpty((String)((String)attr.get((Object)SKIP_COLLECTORS))));
        LOGGER.debug("collectorsToSkip: {}", collectorsToSkip);
        HashSet<NativeCollector> toSkip = new HashSet<NativeCollector>();
        if (!collectorsToSkip.isEmpty()) {
            for (NativeCollector nativeCollector : defaultCollectors) {
                if (!collectorsToSkip.contains(nativeCollector.getName().toUpperCase())) continue;
                toSkip.add(nativeCollector);
            }
        }
        toRun.removeAll(toSkip);
        ImmutableSet.Builder immutableSetBuilder = new ImmutableSet.Builder();
        boolean antCollectorPresent = false;
        boolean jarCollectorPresent = false;
        boolean soFileCollectorPresent = false;
        boolean makefileCollectorPresent = false;
        for (NativeCollector nativeCollector : toRun) {
            if (projectPath != null && !nativeCollector.supports(projectPath)) continue;
            immutableSetBuilder.add((Object)nativeCollector);
            if (nativeCollector instanceof AntNativeCollector) {
                antCollectorPresent = true;
                continue;
            }
            if (nativeCollector instanceof JarNativeCollector) {
                jarCollectorPresent = true;
                continue;
            }
            if (nativeCollector instanceof SOFileNativeCollector) {
                soFileCollectorPresent = true;
                continue;
            }
            if (!(nativeCollector instanceof MakefileNativeCollector)) continue;
            makefileCollectorPresent = true;
        }
        HashSet<Class<? extends NativeCollector>> collectorsToRemove = new HashSet<Class<? extends NativeCollector>>();
        if (collectorsToRun.isEmpty()) {
            if (antCollectorPresent && jarCollectorPresent) {
                collectorsToRemove.add(JarNativeCollector.class);
            }
            if (makefileCollectorPresent && soFileCollectorPresent) {
                collectorsToRemove.add(SOFileNativeCollector.class);
            }
        }
        return ComponentEngineBuilder.setWithCollectorsRemoved((ImmutableSet<NativeCollector>)immutableSetBuilder.build(), collectorsToRemove);
    }

    static ImmutableSet<NativeCollector> setWithCollectorsRemoved(ImmutableSet<NativeCollector> collectors, Set<Class<? extends NativeCollector>> toRemove) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (NativeCollector collector : collectors) {
            if (toRemove.contains(collector.getClass())) continue;
            builder.add((Object)collector);
        }
        return builder.build();
    }

    public ComponentEngineBuilder withRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public ComponentEngineBuilder withEngineType(EngineType engineType) {
        this.engineType = engineType;
        return this;
    }

    public ComponentEngineBuilder withLogStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    @Deprecated
    public ComponentEngineBuilder withLanguageType(@Nullable LanguageType languageType) {
        return this;
    }

    @Deprecated
    public ComponentEngineBuilder withLanguageTypes(List<LanguageType> languageTypes) {
        return this;
    }

    @Deprecated
    public ComponentEngineBuilder withBuildType(BuildType buildType) {
        return this;
    }

    @Deprecated
    public ComponentEngineBuilder withProjectPath(String projectUrl) {
        this.projectPath = new File(projectUrl);
        return this;
    }

    public ComponentEngineBuilder withProjectPath(File projectUrl) {
        this.projectPath = projectUrl;
        return this;
    }

    public ComponentEngineBuilder withMaxPaths(int maxPaths) {
        this.maxPaths = maxPaths;
        return this;
    }

    public ComponentEngineBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public ComponentEngineBuilder withEnvironment(@Nonnull Map<String, String> envVars) {
        this.attributes.put(ENV_VARS, Collections.unmodifiableMap(envVars));
        return this;
    }

    public ComponentEngine build() throws CollectionException {
        ComponentEngine engine;
        File projectFolder = this.projectPath.isDirectory() ? this.projectPath : this.projectPath.getParentFile();
        ImmutableMap finalizedAttributes = ImmutableMap.copyOf(ComponentEngineBuilder.mergeAttributesWithDirectivesFileAndEnvVars((Map<String, Object>)ImmutableMap.copyOf(this.attributes), projectFolder));
        if (this.engineType == EngineType.QUICKSCAN) {
            return new QuickscanEngine(this.projectPath, (ImmutableMap<String, Object>)finalizedAttributes, this.logStream);
        }
        if (!projectFolder.isDirectory() || !projectFolder.canRead()) {
            String fatalMessage = String.format("Project path %s is invalid.  Please make sure it is a directory that is readable.", this.projectPath);
            LOGGER.warn(fatalMessage);
            throw new CollectionException(CollectionErrorType.SYSTEM, fatalMessage).withScanAttributes((ImmutableMap<String, Object>)finalizedAttributes);
        }
        if (this.recursive) {
            ImmutableSet<NativeCollector> collectors = ComponentEngineBuilder.resolveNativeCollectors((ImmutableMap<String, Object>)finalizedAttributes, null, this.logStream, true);
            engine = new RecursiveEngine(this.projectPath, collectors, this.logStream, (ImmutableMap<String, Object>)finalizedAttributes);
        } else {
            ImmutableSet<NativeCollector> collectors = ComponentEngineBuilder.resolveNativeCollectors((ImmutableMap<String, Object>)finalizedAttributes, this.projectPath, this.logStream, false);
            if (collectors.isEmpty()) {
                String msg = "No supported build system found. Please see our list of supported systems at https://www.sourceclear.com/docs/frequently-asked-questions.";
                throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "No supported build system found. Please see our list of supported systems at https://www.sourceclear.com/docs/frequently-asked-questions.").withScanAttributes((ImmutableMap<String, Object>)finalizedAttributes);
            }
            boolean ok = true;
            for (NativeCollector collector : collectors) {
                if (collector.systemIsReady(projectFolder)) continue;
                ok = false;
            }
            if (!ok) {
                this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, "Error while configuring engine");
                String helpfulMsg = "SourceClear is unable to continue with scanning the project because at least one\nof the build systems we found for your project is not ready for build.\nWe suggest you scan the project again after reviewing and correcting the errors.";
                throw new CollectionException(CollectionErrorType.SYSTEM, "SourceClear is unable to continue with scanning the project because at least one\nof the build systems we found for your project is not ready for build.\nWe suggest you scan the project again after reviewing and correcting the errors.").withScanAttributes((ImmutableMap<String, Object>)finalizedAttributes);
            }
            engine = new NativeLocalEngine(this.projectPath, collectors, this.logStream, (ImmutableMap<String, Object>)finalizedAttributes);
        }
        this.logStream.log("com.srcclr.engineconfig.end", Stage.ENGINE_CONFIGURATION, "SourceClear scanning engine ready");
        return engine;
    }

    public static enum EngineType {
        NATIVE,
        QUICKSCAN;

    }
}

