/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.CollectionResult;
import com.sourceclear.engine.component.ComponentEngine;
import com.sourceclear.engine.component.quickscancollectors.ComposerLockQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.GemfileDotLockQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.GlideLockQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.GodepQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.GolangDepQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.GovendorQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.JarQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.NPMQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.PipfileLockQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.PodfileDotLockQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.TrashQuickscanCollector;
import com.sourceclear.engine.component.quickscancollectors.YarnDotLockQuickscanCollector;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickscanEngine
implements ComponentEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuickscanEngine.class);
    private final File target;
    private final ImmutableSet<QuickscanCollector> collectors;
    private final ImmutableMap<String, Object> attributes;
    private final LogStream logStream;

    QuickscanEngine(File target, ImmutableMap<String, Object> attributes, LogStream logStream) {
        this.target = target;
        this.attributes = attributes;
        this.logStream = logStream;
        this.collectors = this.buildCollectors(target);
    }

    private ImmutableSet<QuickscanCollector> collectors() {
        return ImmutableSet.of((Object)new YarnDotLockQuickscanCollector(this.logStream), (Object)new GemfileDotLockQuickscanCollector(), (Object)new NPMQuickscanCollector(), (Object)new JarQuickscanCollector(this.logStream), (Object)new ComposerLockQuickscanCollector(), (Object)new GlideLockQuickscanCollector(), (Object[])new QuickscanCollector[]{new TrashQuickscanCollector(), new GovendorQuickscanCollector(), new GodepQuickscanCollector(), new GolangDepQuickscanCollector(this.attributes), new PipfileLockQuickscanCollector(), new PodfileDotLockQuickscanCollector()});
    }

    @Override
    public String getName() {
        return "Quickscan Engine";
    }

    @Override
    public CollectionResult collect() throws CollectionException {
        CollectionResult.Builder builder = new CollectionResult.Builder().withScanAttributes(this.attributes).withMethodsSupported(false);
        LibraryGraphContainer.Builder graphBuilder = new LibraryGraphContainer.Builder();
        AgentRuntimeData.Builder agentRuntimeDataBuilder = new AgentRuntimeData.Builder();
        for (QuickscanCollector c : this.collectors) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOGGER.debug("Collector \"{}\" started", (Object)c.getName());
            try {
                graphBuilder.withGraphs((Collection)c.collect(this.target, this.attributes).getGraphs());
            }
            catch (CollectionException ex) {
                this.logStream.log("com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION, "Couldn't scan with " + c.getName() + ": " + ex.getMessage());
                agentRuntimeDataBuilder.addCollectorsRun(c.getCollectorData());
                ex.withAgentRuntimeData(agentRuntimeDataBuilder.build()).withScanAttributes(this.attributes);
                throw ex;
            }
            LOGGER.debug("Collector \"{}\" completed in {}.{}s", new Object[]{c.getName(), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS) / 100L % 10L});
            agentRuntimeDataBuilder.addCollectorsRun(c.getCollectorData());
        }
        builder.withGraphs(graphBuilder.build());
        builder.withAgentRuntimeData(agentRuntimeDataBuilder.build());
        return builder.build();
    }

    @Override
    public List<String> getCollectorsList() {
        HashSet<String> set = new HashSet<String>();
        for (QuickscanCollector c : this.collectors) {
            set.add(c.getName());
        }
        return new ArrayList<String>(set);
    }

    private ImmutableSet<QuickscanCollector> buildCollectors(File target) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (QuickscanCollector c : this.collectors()) {
            if (!c.supports(target)) continue;
            builder.add((Object)c);
        }
        return builder.build();
    }
}

