/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.cocoapods;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sourceclear.engine.component.cocoapods.Dependency;
import com.sourceclear.engine.component.cocoapods.PodDeserializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(using=PodDeserializer.class)
public class Pod {
    private final String name;
    private final String version;
    private final int lineNumber;
    private final List<Dependency> dependencies;

    Pod(String name, String version, int lineNumber, List<Dependency> dependencies) {
        this.name = name;
        this.version = version;
        this.lineNumber = lineNumber;
        this.dependencies = dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pod pod = (Pod)o;
        return Objects.equals(this.name, pod.name) && Objects.equals(this.version, pod.version) && Objects.equals(this.dependencies, pod.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.dependencies);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pod{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", dependencies ='").append(this.dependencies).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public static class Builder {
        private String name;
        private String version;
        private int lineNumber;
        private List<Dependency> dependencies = new ArrayList<Dependency>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder withDependency(Dependency dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Pod build() {
            return new Pod(this.name, this.version, this.lineNumber, this.dependencies);
        }
    }
}

