/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.ComponentEngineBuilder;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.srcclr.sdk.LibraryGraphContainer;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AntNativeCollector
implements NativeCollector {
    private static final String DEFAULT_BUILD_FILE_NAME = "build.xml";
    private static final String DEFAULT_SCAN_TASKDEF_NAME = "SourceClearScanTaskDef";
    private static final String DEFAULT_SCAN_TARGET_NAME = "SourceClearScan";
    private static final String SOURCECLEAR_SCAN_CLASSNAME = "com.sourceclear.plugins.ScanAntTask";
    private static final Logger LOGGER = LoggerFactory.getLogger(AntNativeCollector.class);
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;
    private final boolean enabled;
    public static final String SRCCLR_ANT_PLUGIN_JAR = "srcclr-ant-plugin.jar";

    public AntNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
        this.enabled = Boolean.valueOf(String.valueOf(attributes.get((Object)"DISABLE_ANT"))) == false;
    }

    @Override
    public boolean supports(File projectPath) {
        if (!this.enabled) {
            return false;
        }
        return CollectorUtils.fileExistsWithinFolder(projectPath, DEFAULT_BUILD_FILE_NAME);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(DEFAULT_BUILD_FILE_NAME);
    }

    private String getBuildFile(File projectPath) {
        return Paths.get(projectPath.getAbsolutePath(), DEFAULT_BUILD_FILE_NAME).toString();
    }

    @Override
    public String getName() {
        return "Ant";
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        try {
            FileTypeVisitor visitor = ClassFileVisitor.getVisitor();
            Files.walkFileTree(Paths.get(projectRoot.getCanonicalPath(), new String[0]), visitor);
            return !visitor.getFiles().isEmpty();
        }
        catch (Exception ex) {
            this.logStream.log("com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION, "Unable to determine vulnerable methods support, skipping.");
            LOGGER.error("Couldn't scan for class files in AntNativeCollector.", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        if (!this.enabled) {
            LOGGER.debug("Skipping Ant because currently disabled");
            return false;
        }
        LOGGER.debug("Checking whether Ant system is ready.");
        try {
            this.resolveAntExeOrThrow();
            LOGGER.debug("Able to resolve Ant exe.");
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        File antExe = this.resolveAntExeOrThrow();
        LOGGER.debug("Using antExe: " + antExe.getAbsolutePath());
        File buildFile = new File(this.getBuildFile(projectRoot));
        if (!buildFile.exists()) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, buildFile.getAbsolutePath() + " does not exist.");
        }
        if (!buildFile.isFile()) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, buildFile.getAbsolutePath() + " is not a file.");
        }
        LOGGER.debug("Using buildFile: " + buildFile.getAbsolutePath());
        String scanTargetName = DEFAULT_SCAN_TARGET_NAME;
        String buildSteps = Strings.nullToEmpty((String)((String)this.attributes.get((Object)"ANT_BUILD_STEPS"))).trim();
        LOGGER.debug("buildSteps: " + buildSteps);
        boolean skipBuild = buildSteps.isEmpty();
        LOGGER.debug("skipBuild: " + skipBuild);
        File tmpJarFile = this.createTmpJarFile();
        File tempBuildFile = this.createBuildFileWithScanTarget(buildFile, scanTargetName, tmpJarFile, buildSteps);
        String customIvySettingsXmlFilename = (String)this.attributes.get((Object)"IVY_SETTINGS_FILENAME");
        LOGGER.debug("customIvySettingsXmlFilename: {}", (Object)customIvySettingsXmlFilename);
        return this.launchAntProcessAndGetLibraryGraphContainer(projectRoot, antExe, tempBuildFile, scanTargetName, skipBuild, customIvySettingsXmlFilename);
    }

    private File createTmpJarFile() throws CollectionException {
        File tmpJarFile = null;
        try {
            tmpJarFile = File.createTempFile("srcclr-tmp-ant-plugin", ".jar");
            tmpJarFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error while creating tmp Jar file: " + e.getMessage()).initCause(e);
        }
        LOGGER.debug("tmp file for jar created: " + tmpJarFile.getAbsolutePath());
        try (InputStream inputStream = AntNativeCollector.class.getResourceAsStream("/srcclr-ant-plugin.jar");){
            Files.copy(inputStream, tmpJarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error while writing tmp Jar file: " + e.getMessage()).initCause(e);
        }
        LOGGER.debug("tmp jar file written");
        return tmpJarFile;
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).build();
    }

    private File createBuildFileWithScanTarget(File buildFile, String scanTargetName, File jarFile, String buildSteps) throws CollectionException {
        File buildFileDirectory = new File(FilenameUtils.getFullPath((String)buildFile.getAbsolutePath()));
        LOGGER.debug("buildFileDirectory: " + buildFileDirectory.getAbsolutePath());
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(buildFile);
            doc.getDocumentElement().normalize();
            Element projectNode = doc.getDocumentElement();
            Element taskDefElement = doc.createElement("taskdef");
            taskDefElement.setAttribute("name", DEFAULT_SCAN_TASKDEF_NAME);
            taskDefElement.setAttribute("classname", SOURCECLEAR_SCAN_CLASSNAME);
            taskDefElement.setAttribute("classpath", jarFile.getAbsolutePath());
            projectNode.appendChild(taskDefElement);
            Element targetElement = doc.createElement("target");
            targetElement.setAttribute("name", scanTargetName);
            targetElement.setAttribute("description", "Scan target created by SourceClear");
            if (!Strings.isNullOrEmpty((String)buildSteps)) {
                targetElement.setAttribute("depends", buildSteps);
            }
            Element taskElement = doc.createElement(DEFAULT_SCAN_TASKDEF_NAME);
            targetElement.appendChild(taskElement);
            projectNode.appendChild(targetElement);
            File tempBuildFile = File.createTempFile("srcclr", ".build.xml", buildFileDirectory);
            tempBuildFile.deleteOnExit();
            LOGGER.debug("tempBuildFile created: " + tempBuildFile);
            DOMSource source = new DOMSource(doc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult result = new StreamResult(tempBuildFile);
            transformer.transform(source, result);
            return tempBuildFile;
        }
        catch (ParserConfigurationException e) {
            throw new CollectionException(CollectionErrorType.PARSE, "Error while parsing buildFile: " + e.getMessage()).initCause(e);
        }
        catch (SAXException e) {
            throw new CollectionException(CollectionErrorType.PARSE, "SAXException while parsing buildFile: " + e.getMessage()).initCause(e);
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "IOException while parsing buildFile: " + e.getMessage()).initCause(e);
        }
        catch (TransformerException e) {
            throw new CollectionException(CollectionErrorType.PARSE, "Unable to write modified xml DOM into new build file: " + e.getMessage()).initCause(e);
        }
    }

    private LibraryGraphContainer launchAntProcessAndGetLibraryGraphContainer(File projectRoot, File antExe, File tempBuildFile, String scanTargetName, Boolean skipBuild, @Nullable String ivySettingsFilename) throws CollectionException {
        Set graphs;
        Process antProcess;
        File graphFile;
        try {
            graphFile = File.createTempFile("graph-", ".json");
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error while creating temp graph file: " + e.getMessage());
        }
        LOGGER.debug("Temp graph file: " + graphFile.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        CollectorUtils.populateEnvVars(this.attributes, pb);
        Map<String, String> additionalEnvVars = pb.environment();
        if (additionalEnvVars == null) {
            additionalEnvVars = new HashMap<String, String>();
        }
        additionalEnvVars.put("HEADLESS_OUTPUT_FILE", graphFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)ivySettingsFilename)) {
            additionalEnvVars.put("IVY_SETTINGS_FILENAME", ivySettingsFilename);
        }
        if (skipBuild.booleanValue()) {
            additionalEnvVars.put("ANT_SKIP_BUILD", skipBuild.toString());
            String antLibDir = (String)this.attributes.get((Object)"ANT_LIB_DIR");
            if (Strings.isNullOrEmpty((String)antLibDir)) {
                antLibDir = projectRoot.getAbsolutePath();
            } else {
                LOGGER.debug("antLibDir before process: " + antLibDir);
                String[] tokens = antLibDir.split(",");
                ArrayList<String> processedTokens = new ArrayList<String>(tokens.length);
                for (String token : tokens) {
                    if (Strings.isNullOrEmpty((String)token.trim())) continue;
                    processedTokens.add(Paths.get(projectRoot.getAbsolutePath(), token.trim()).normalize().toAbsolutePath().toString());
                }
                antLibDir = Joiner.on((String)",").join(processedTokens);
                LOGGER.debug("antLibDir after process: " + antLibDir);
            }
            additionalEnvVars.put("ANT_LIB_DIR", antLibDir);
        }
        pb.directory(projectRoot);
        pb.redirectErrorStream(true);
        ArrayList commands = Lists.newArrayList((Object[])new String[]{antExe.getAbsolutePath()});
        commands.add("-v");
        if (tempBuildFile != null) {
            LOGGER.debug("Using temp build file generated: " + tempBuildFile.getAbsolutePath());
            commands.add("-buildfile");
            commands.add(tempBuildFile.getAbsolutePath());
        }
        commands.add(scanTargetName);
        pb.command(commands);
        try {
            antProcess = pb.start();
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error while running Ant target: " + e.getMessage());
        }
        IOUtils.closeQuietly((OutputStream)antProcess.getOutputStream());
        Future<String> outputFuture = CollectorUtils.readAsync(antProcess.getInputStream(), this.logStream, LOGGER, "com.srcclr.evidence.compilation", Stage.EVIDENCE_COLLECTION);
        CollectorUtils.readAsync(antProcess.getErrorStream(), this.logStream, LOGGER, "com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION);
        try {
            int result = antProcess.waitFor();
            String output = outputFuture.get();
            if (result != 0) {
                String errorMessage = "Encountered errors while collecting component information for Ant project.";
                if (output.contains("Please define the appengine.sdk property")) {
                    errorMessage = "Please set the environmental variable 'appengine.sdk' to point to your App Engine SDK folder";
                }
                LOGGER.error(errorMessage);
                throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", output);
            }
        }
        catch (InterruptedException e) {
            throw new CollectionException(CollectionErrorType.UNKNOWN, "InterruptedException while getting result code and output from antProcess: " + e.getMessage());
        }
        catch (ExecutionException e) {
            throw new CollectionException(CollectionErrorType.UNKNOWN, "ExecutionException while getting result code and output from antProcess: " + e.getMessage());
        }
        try (FileInputStream is = new FileInputStream(graphFile);){
            graphs = LibraryGraphSerializer.read((InputStream)is).getGraphs();
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "Couldn't read generated graph file: " + ex.getMessage()).initCause(ex);
        }
        return new LibraryGraphContainer.Builder().withGraphs((Collection)graphs).build();
    }

    private File resolveAntExeOrThrow() throws CollectionException {
        String exeName = "ant";
        String antPath = (String)this.attributes.get((Object)"CUSTOM_ANT_EXEC");
        if (!Strings.isNullOrEmpty((String)antPath)) {
            LOGGER.debug("User specified CUSTOM_ANT_EXEC");
            try {
                return CollectorUtils.ensureExistsAndExecutable(new File(antPath), "");
            }
            catch (CollectionException e) {
                String msg = "\nPlease ensure that the value of CUSTOM_ANT_EXEC in " + ComponentEngineBuilder.getDirectivesFile() + " is specified correctly\nand is executable.";
                throw new CollectionException(e.getExceptionType(), e.getMessage() + msg, e.getErrorLog());
            }
        }
        LOGGER.debug("User did not specify CUSTOM_ANT_EXEC");
        return CollectorUtils.resolveExeOrThrow("ant");
    }
}

