/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.StubNativeCollector;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;

abstract class FileBasedStubNativeCollector
extends StubNativeCollector {
    private final String[] triggerFilenames;

    FileBasedStubNativeCollector(LogStream logStream, String ... triggerFilenames) {
        super(logStream);
        this.triggerFilenames = triggerFilenames;
    }

    @Override
    public boolean supports(File projectPath) {
        if (projectPath == null) {
            return false;
        }
        if (!projectPath.exists()) {
            return false;
        }
        if (!projectPath.isDirectory()) {
            return false;
        }
        for (String filename : this.triggerFilenames) {
            File f = new File(projectPath, filename);
            if (!f.exists() || !f.isFile()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(this.triggerFilenames);
    }
}

