/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.StubNativeCollector;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

abstract class GlobBasedStubNativeCollector
extends StubNativeCollector {
    private final String[] triggerGlobs;

    GlobBasedStubNativeCollector(LogStream logStream, String ... triggerGlobs) {
        super(logStream);
        this.triggerGlobs = triggerGlobs;
    }

    @Override
    public boolean supports(File projectPath) {
        if (projectPath == null) {
            return false;
        }
        if (!projectPath.isDirectory()) {
            return false;
        }
        for (String glob : this.triggerGlobs) {
            String[] matches = projectPath.list(new GlobbingFilenameFilter(glob));
            if (matches == null) continue;
            for (String fn : matches) {
                if (!CollectorUtils.fileExistsWithinFolder(projectPath, fn)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        HashSet<Pattern> set = new HashSet<Pattern>();
        for (String glob : this.triggerGlobs) {
            set.add(Pattern.compile(glob.replace("*", ".*").replace('?', '.')));
        }
        return set;
    }

    private class GlobbingFilenameFilter
    implements FilenameFilter {
        private final Pattern glob;

        private GlobbingFilenameFilter(String glob) {
            this.glob = Pattern.compile(glob.replace("*", ".*").replace('?', '.'));
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.glob.matcher(name).matches();
        }
    }
}

