/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.GoPackageManagerCollector;
import com.sourceclear.engine.component.golang.GoDependencyGraph;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.golang.GodepJson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;

public class GodepNativeCollector
extends GoPackageManagerCollector {
    public static final String GODEPS_FOLDER = "Godeps";
    public static final String GODEPS_JSON_FILENAME = "Godeps.json";
    private static final String GODEPS_JSON = FilenameUtils.concat((String)"Godeps", (String)"Godeps.json");
    private static final String GODEP = "godep";
    private GodepJson godepJson = new GodepJson();

    public GodepNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, attributes);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(GODEPS_JSON);
    }

    @Override
    public String getName() {
        return "Godep";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<GoPackage> getResolvedImports(File projectRoot, GoDependencyGraph goDependencyGraph, List<String> goPaths) throws CollectionException {
        File dependencyFile = new File(projectRoot, GODEPS_JSON);
        try (InputStream inputStream = Files.newInputStream(dependencyFile.toPath(), new OpenOption[0]);){
            this.godepJson = GodepJson.parse(inputStream);
            List<GoPackage> list = this.godepJson.getImports();
            return list;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }

    @Override
    protected String getIdentityFilename() {
        return GODEPS_JSON;
    }

    @Override
    @Nullable
    protected String getPackageNameUnderScan() {
        return this.godepJson.getPackageName();
    }

    @Override
    @Nullable
    protected String getBinName() {
        return GODEP;
    }

    @Override
    @Nullable
    protected List<String> getInstallArgs() {
        return Lists.newArrayList((Object[])new String[]{"restore"});
    }
}

