/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.FeatureFlag;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.CollectionResult;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.dotnet.LibraryVersion;
import com.sourceclear.engine.component.dotnet.ProjectAssetsJSON;
import com.sourceclear.engine.component.dotnet.ProjectTarget;
import com.sourceclear.util.system.SystemInfo;
import com.sourceclear.util.system.SystemInfoResults;
import com.sourceclear.util.system.SystemItem;
import com.sourceclear.util.system.SystemItemRequirementNotMetException;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSBuildDotNetNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MSBuildDotNetNativeCollector.class);
    public static final ImmutableSet<String> PROJECT_EXTENSIONS = new ImmutableSet.Builder().add((Object[])new String[]{".csproj", ".fsproj", ".vbproj"}).build();
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;
    private final String failureAdviceMsg;
    private final boolean skipRestore;
    private Set<Path> buildFilesFound = new HashSet<Path>();
    private List<String> lastBuildCommand = new ArrayList<String>();
    private boolean lastBuildCommandSuccessful = true;
    private DotNetExec dotNetExecToUse;

    private static Coords toCoords(LibraryVersion libraryVersion) {
        return new Coords.Builder().withCoordinateType(CoordinateType.NUGET).withCoordinate1(libraryVersion.getName()).withVersion(libraryVersion.getVersion()).build();
    }

    private static Map<LibraryVersion, Coords> buildCoordsMap(Map<String, Set<ProjectTarget>> projectTargetMap) {
        return projectTargetMap.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().filter(projectTarget -> projectTarget.getType().equalsIgnoreCase("package")).map(ProjectTarget::getLibraryVersion).distinct().map(libraryVersion -> new AbstractMap.SimpleEntry<LibraryVersion, Coords>((LibraryVersion)libraryVersion, MSBuildDotNetNativeCollector.toCoords(libraryVersion)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean isExecInstalled(DotNetExec dotNetExec) {
        SystemItem systemItem = dotNetExec.systemItem;
        try {
            SystemInfoResults systemInfoResults = SystemInfo.performOnItems(Collections.singleton(systemItem));
            systemItem.assess(systemInfoResults);
            return true;
        }
        catch (SystemItemRequirementNotMetException | IOException ex) {
            LOGGER.debug("Exception while finding {}: ", (Object)systemItem.getExecutable(), (Object)ex);
            return false;
        }
    }

    public MSBuildDotNetNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
        this.failureAdviceMsg = String.format("1. Set '%s' in %s (%s%s if you are using environment variables) to your preferred build executable. Possible values are: '%s'.%n2. If you build the project before scanning and project.assets.json files are generated during the build, you can set '%s: true' in %s (%s%s=true if you are using environment variables).", "USE_DOTNET_EXEC", "srcclr.yml", "SRCCLR_", "USE_DOTNET_EXEC", StringUtils.join((Object[])DotNetExec.values(), (String)", "), "SKIP_DOTNET_RESTORE", "srcclr.yml", "SRCCLR_", "SKIP_DOTNET_RESTORE");
        this.skipRestore = Boolean.valueOf(String.valueOf(attributes.get((Object)"SKIP_DOTNET_RESTORE")));
    }

    @Override
    public String getName() {
        return "MSBuildDotNet";
    }

    @Override
    public boolean supports(File projectPath) {
        if (!FeatureFlag.featureIsOn(FeatureFlag.Flag.ENABLE_DOTNET, this.attributes)) {
            return false;
        }
        FileTypeVisitor projFilesVisitor = new FileTypeVisitor((Set<String>)PROJECT_EXTENSIONS, (Set<String>)new HashSet<String>(), LOGGER);
        try {
            Files.walkFileTree(projectPath.toPath(), projFilesVisitor);
        }
        catch (IOException ioex) {
            throw new RuntimeException(String.format("Unable to scan project directory '%s' for build files.", projectPath), ioex);
        }
        this.buildFilesFound = projFilesVisitor.getFiles();
        return !this.buildFilesFound.isEmpty();
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return PROJECT_EXTENSIONS.stream().map(extension -> Pattern.compile(".+" + Pattern.quote(extension))).collect(Collectors.toSet());
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        ArrayList execsToCheck;
        if (this.skipRestore) {
            LOGGER.debug("skipping restore. not checking for executables for system readiness.");
            return true;
        }
        String useDotNetExecString = (String)this.attributes.get((Object)"USE_DOTNET_EXEC");
        if (StringUtils.isBlank((String)useDotNetExecString)) {
            execsToCheck = Arrays.asList(DotNetExec.values());
        } else {
            LOGGER.debug("USE_DOTNET_EXEC provided: {}", (Object)useDotNetExecString);
            try {
                execsToCheck = Lists.newArrayList((Object[])new DotNetExec[]{DotNetExec.valueOf(useDotNetExecString.toUpperCase())});
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(String.format("'%s' is not a valid %s value. Permitted values are: '%s'.", useDotNetExecString, "USE_DOTNET_EXEC", StringUtils.join((Object[])DotNetExec.values(), (String)", ")), ex);
            }
        }
        List execsFound = execsToCheck.stream().filter(MSBuildDotNetNativeCollector::isExecInstalled).collect(Collectors.toList());
        if (!execsFound.isEmpty()) {
            this.dotNetExecToUse = (DotNetExec)((Object)execsFound.get(0));
            LOGGER.debug("Found executables '{}'. Using {} as build executable.", execsFound, (Object)this.dotNetExecToUse);
            return true;
        }
        this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, String.format("None of these executables - '%s' - are found for %s. Unable to run collector for dependencies analysis.", StringUtils.join((Collection)execsToCheck, (String)", "), this.getName()));
        return false;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        if (this.skipRestore) {
            LOGGER.debug("skipping restore");
        } else {
            this.checkDotNetExecInfo();
            HashSet<Path> filesToRestoreOn = new HashSet<Path>();
            Optional<Path> slnFile = this.findSolutionFile(projectRoot);
            if (slnFile.isPresent()) {
                LOGGER.debug(".sln exists at project root. Running restore command at the root.");
                filesToRestoreOn.add(slnFile.get());
            } else {
                LOGGER.debug(".sln does not exist at project root. Running restore command individually on proj files.");
                filesToRestoreOn.addAll(this.buildFilesFound);
            }
            LOGGER.debug("filesToRestoreOn: {}", filesToRestoreOn);
            this.runRestore(filesToRestoreOn, slnFile.isPresent());
        }
        Set<Path> projectAssetsJSONFiles = this.getProjectAssetsJSONFiles();
        LOGGER.debug("project.assets.json found: {}", projectAssetsJSONFiles);
        Set libraryGraphs = projectAssetsJSONFiles.stream().flatMap(path -> {
            try {
                return this.projectAssetsJSONToLibraryGraphs(projectRoot, (Path)path).stream();
            }
            catch (CollectionException ex) {
                LOGGER.debug("Unable to read file '{}': ", path, (Object)ex);
                this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, String.format("Unable to read '%s'. Results may be incomplete. Run with --debug for details.", path));
                return Stream.empty();
            }
        }).collect(Collectors.toSet());
        return new LibraryGraphContainer.Builder().withGraph(new LibraryGraph.Builder().withDirects(libraryGraphs).build()).build();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setBuildCommandType(BuildCommandType.DEFAULT).setCollectorName(this.getName()).setBuildCommand(StringUtils.join(this.lastBuildCommand, (String)" ")).setBuildCommandSuccessful(this.lastBuildCommandSuccessful).build();
    }

    @Override
    public Optional<CollectionResult.Advice> adviseOnFailure() {
        String advice = String.format("SourceClear currently only supports projects using PackageReference format to declare dependencies in .*proj files. If you are using packages.config to declare dependencies, SourceClear may not be able to find the dependencies.%nIf you are already using PackageReference format, you may try the following:%n%s", this.failureAdviceMsg);
        return Optional.of(new CollectionResult.Advice(this.getName(), advice));
    }

    private void checkDotNetExecInfo() throws CollectionException {
        if (this.dotNetExecToUse == null) {
            throw new RuntimeException("Unexpected error: Dotnet executable is not set.");
        }
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        String executable = this.dotNetExecToUse.systemItem.getExecutable();
        List<String> command = Arrays.asList(executable, this.dotNetExecToUse.infoOption);
        List<String> output = CollectorUtils.launchProcess(command, new File(System.getProperty("user.dir")), new HashMap<String, String>(), LOGGER, String.format("An error occurred while running '%s' to check for the executable's info.", StringUtils.join(command, (String)" ")));
        LOGGER.debug("{} info: {}", (Object)executable, (Object)StringUtils.join(output, (String)String.format("%n", new Object[0])));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Path> findSolutionFile(File projectRoot) throws CollectionException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(projectRoot.toPath(), "*.sln");){
            Path path;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
            } while (Files.isDirectory(path = iterator.next(), new LinkOption[0]));
            Optional<Path> optional = Optional.of(path);
            return optional;
        }
        catch (IOException ioex) {
            throw new CollectionException(CollectionErrorType.IO, "IOException occurred while looking for .sln in project directory.").initCause(ioex);
        }
    }

    private void runRestore(Set<Path> filesToRestoreOn, boolean throwEx) throws CollectionException {
        LOGGER.debug("using {} for restore", (Object)this.dotNetExecToUse);
        for (Path file : filesToRestoreOn) {
            ArrayList command = Lists.newArrayList((Object[])new String[]{this.dotNetExecToUse.systemItem.getExecutable(), this.dotNetExecToUse.restoreCommand, file.getFileName().toString()});
            String errorMsg = String.format("SourceClear was unable to resolve the project's dependencies because the restore command '%s' failed. Run with --debug for details.%nYou may also wish to try the following:%n%s", StringUtils.join((Collection)command, (String)" "), this.failureAdviceMsg);
            try {
                CollectorUtils.launchProcess(command, file.getParent().toFile(), new HashMap<String, String>(), LOGGER, errorMsg);
                if (!this.lastBuildCommandSuccessful) continue;
                this.lastBuildCommand = command;
            }
            catch (CollectionException ce) {
                this.lastBuildCommand = command;
                this.lastBuildCommandSuccessful = false;
                if (throwEx) {
                    throw ce;
                }
                LOGGER.debug("Command {} failed: ", (Object)command, (Object)ce);
                this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, String.format("Unable to restore dependencies for subproject '%s'. Results may be incomplete. Run with --debug for details.", file));
            }
        }
    }

    private Set<Path> getProjectAssetsJSONFiles() {
        return this.buildFilesFound.stream().map(path -> path.getParent().resolve("obj").resolve("project.assets.json")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Set<LibraryGraph> projectAssetsJSONToLibraryGraphs(File projectRoot, Path file) throws CollectionException {
        ProjectAssetsJSON projectAssetsJSON;
        try {
            projectAssetsJSON = ProjectAssetsJSON.fromFile(file);
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, String.format("IOException while reading '%s'", file)).initCause(ex);
        }
        ImmutableMap<String, Set<ProjectTarget>> projectTargetMap = projectAssetsJSON.getTargets();
        Map<LibraryVersion, Coords> coordsMap = MSBuildDotNetNativeCollector.buildCoordsMap(projectTargetMap);
        String filename = projectRoot.toPath().relativize(file).toString();
        return projectAssetsJSON.getDirects().stream().flatMap(libraryName -> projectTargetMap.containsKey(libraryName) ? ((Set)projectTargetMap.get(libraryName)).stream().map(ProjectTarget::getLibraryVersion).distinct() : Stream.empty()).map(libraryVersion -> MSBuildDotNetNativeCollector.buildLibraryGraph(filename, libraryVersion, (Map<String, Set<ProjectTarget>>)projectTargetMap, coordsMap, new HashSet<LibraryVersion>(), new HashMap<LibraryVersion, LibraryGraph>())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static Optional<LibraryGraph> buildLibraryGraph(String filename, LibraryVersion libraryVersion, Map<String, Set<ProjectTarget>> projectTargetMap, Map<LibraryVersion, Coords> coordsMap, Set<LibraryVersion> seen, Map<LibraryVersion, LibraryGraph> graphsBuilt) {
        if (seen.contains(libraryVersion)) {
            return Optional.empty();
        }
        LibraryGraph existing = graphsBuilt.get(libraryVersion);
        if (existing != null) {
            return Optional.of(existing);
        }
        Coords coords = coordsMap.get(libraryVersion);
        if (coords == null) {
            LOGGER.debug("{} not present in coordsMap. Ignoring this coord.", (Object)libraryVersion);
            return Optional.empty();
        }
        HashSet directs = new HashSet();
        Set<ProjectTarget> projectTargets = projectTargetMap.get(libraryVersion.getName());
        if (projectTargets == null) {
            LOGGER.debug("{} not present in projectTargetMap. Unable to find transitives for this library if there are any.", (Object)libraryVersion);
        } else {
            seen.add(libraryVersion);
            directs.addAll(projectTargets.stream().flatMap(projectTarget -> projectTarget.getDependencies().stream().map(dependency -> MSBuildDotNetNativeCollector.buildLibraryGraph(filename, dependency, projectTargetMap, coordsMap, seen, graphsBuilt)).filter(Optional::isPresent).map(Optional::get)).collect(Collectors.toSet()));
            seen.remove(libraryVersion);
        }
        LibraryGraph libraryGraph = new LibraryGraph.Builder().withFilename(filename).withCoords(coords).withDirects(directs).build();
        graphsBuilt.put(libraryVersion, libraryGraph);
        return Optional.of(libraryGraph);
    }

    private static enum DotNetExec {
        DOTNET(SystemItem.DOTNET, "restore", "--info"),
        NUGET(SystemItem.NUGET, "restore", "help"),
        MSBUILD(SystemItem.MSBUILD, "/restore:true", "/version");

        private final SystemItem systemItem;
        private final String restoreCommand;
        private final String infoOption;

        private DotNetExec(SystemItem systemItem, String restoreCommand, String infoOption) {
            this.systemItem = systemItem;
            this.restoreCommand = restoreCommand;
            this.infoOption = infoOption;
        }
    }
}

