/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.collectors.StubNativeCollector;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public class MSBuildNativeCollector
extends StubNativeCollector {
    private static final ImmutableSet<String> PROJECT_EXTENSIONS = new ImmutableSet.Builder().add((Object[])new String[]{"proj", "vcxproj"}).build();

    public MSBuildNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream);
    }

    @Override
    public boolean supports(File projectPath) {
        if (projectPath == null) {
            return false;
        }
        Path project = projectPath.toPath();
        if (!Files.isDirectory(project, new LinkOption[0])) {
            return false;
        }
        for (String extension : PROJECT_EXTENSIONS) {
            if (!MSBuildNativeCollector.filePatternFound(project, "*." + extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        HashSet<Pattern> set = new HashSet<Pattern>();
        for (String extension : PROJECT_EXTENSIONS) {
            set.add(Pattern.compile(".+\\." + extension));
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean filePatternFound(Path project, String pattern) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(project, pattern);){
            Path path;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (Files.isDirectory(path = iterator.next(), new LinkOption[0]));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

