/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.api.data.generation.BuildSystemClientType;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.PythonFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.JsonComponentGraphNativeCollector;
import com.sourceclear.util.io.IO;
import com.sourceclear.util.system.SystemInfo;
import com.sourceclear.util.system.SystemInfoResults;
import com.sourceclear.util.system.SystemItem;
import com.sourceclear.util.system.SystemItemRequirementNotMetException;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIPNativeCollector
extends JsonComponentGraphNativeCollector {
    private static final ImmutableSet<String> FILES_OF_INTEREST = new ImmutableSet.Builder().add((Object[])new String[]{"setup.py", "requirements.txt", "requirements-dev.txt", "dev-requirements.txt"}).build();
    private static Logger LOGGER = LoggerFactory.getLogger(PIPNativeCollector.class);
    private static final String DEPY = "https://download.srcclr.com/depy/%s/depy.py";
    private static File srcclrHome = Paths.get(System.getProperty("user.home"), ".srcclr").toFile();
    public static final String DEPY_LOGGING_LEVEL = "DEPY_LOGGING_LEVEL";
    public static final String DEPY_EXTRA_PIP_FLAGS = "DEPY_EXTRA_PIP_FLAGS";
    private static final Set<SystemItem> systemItems = Sets.newHashSet((Object[])new SystemItem[]{SystemItem.PYTHON, SystemItem.PIP});

    public PIPNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, "PIP", attributes);
    }

    private void testRequirements() throws CollectionException {
        SystemInfoResults results;
        try {
            results = SystemInfo.performOnItems(systemItems);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't check the PIP collector's requirements, trying to continue anyway.");
            return;
        }
        try {
            SystemItem.PYTHON.assess(results);
            SystemItem.PIP.assess(results);
        }
        catch (SystemItemRequirementNotMetException e) {
            throw new CollectionException(CollectionErrorType.SYSTEM, "Some system requirements for PIP scanning not met: " + e.getMessage(), "");
        }
    }

    private String getDepyVersion() throws IOException {
        String depyVersion = System.getenv("SRCCLR_DEPY_VERSION");
        if (depyVersion != null) {
            return depyVersion;
        }
        return this.client.getGenerationVersion(BuildSystemClientType.PIP, LibraryGraphSerializer.getCurrentGeneration());
    }

    @Override
    protected Process makeGraphBuildingProcess(File projectRoot, File graphFile, boolean useFallback) throws CollectionException, IOException {
        String exeName = "python";
        File pythonExe = CollectorUtils.resolveExeOrThrow("python");
        this.testRequirements();
        String depyVersion = this.getDepyVersion();
        URL depyURL = new URL(String.format(DEPY, depyVersion));
        File depyFile = this.getDepyFile(depyURL, depyVersion);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        CollectorUtils.populateEnvVars((Map<String, Object>)this.attributes, processBuilder);
        processBuilder.directory(projectRoot);
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.addAll(Arrays.asList(pythonExe.getAbsolutePath(), depyFile.toString(), "--out", graphFile.getAbsolutePath()));
        PIPNativeCollector.maybeAddPipRequirementsArgument(commandPieces, (Map<String, Object>)this.attributes);
        PIPNativeCollector.maybeAddSystemSitePackages(commandPieces, (Map<String, Object>)this.attributes);
        PIPNativeCollector.maybeAddUseSystemPipArgument(commandPieces, (Map<String, Object>)this.attributes);
        PIPNativeCollector.maybeAddPipRequirementsArgument(commandPieces, (Map<String, Object>)this.attributes);
        commandPieces.add(projectRoot.getAbsolutePath());
        LOGGER.debug("Command: {}", commandPieces);
        processBuilder.command(commandPieces);
        PIPNativeCollector.maybeAddDebugEnvironmentVariable(processBuilder.environment(), LOGGER.isDebugEnabled());
        this.maybeAddExtraFlagsEnvironmentVariable(processBuilder.environment());
        return processBuilder.start();
    }

    void maybeAddExtraFlagsEnvironmentVariable(Map<String, String> environment) {
        if (this.attributes.containsKey((Object)"PIP_EXTRA_FLAGS")) {
            environment.put(DEPY_EXTRA_PIP_FLAGS, (String)this.attributes.get((Object)"PIP_EXTRA_FLAGS"));
        }
    }

    static void maybeAddDebugEnvironmentVariable(Map<String, String> environment, boolean debug) {
        if (debug) {
            environment.put(DEPY_LOGGING_LEVEL, "DEBUG");
        }
    }

    @Override
    public String getName() {
        return "PIP";
    }

    @Override
    public boolean supports(File projectPath) {
        for (String filename : FILES_OF_INTEREST) {
            if (!CollectorUtils.fileExistsWithinFolder(projectPath, filename)) continue;
            return true;
        }
        return this.attributesRequirementsFileExists();
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(FILES_OF_INTEREST);
    }

    @Override
    public boolean systemIsReady(File dir) {
        String exeName = "python";
        try {
            String flavorText = "Please run:\n  srcclr test --pip\nto confirm that your system can build and scan Python projects.";
            CollectorUtils.resolveExeOrThrow("python", "Please run:\n  srcclr test --pip\nto confirm that your system can build and scan Python projects.");
            this.testRequirements();
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        return true;
    }

    private boolean attributesRequirementsFileExists() {
        File file = PIPNativeCollector.attributeToFile((Map<String, Object>)this.attributes, "PIP_REQUIREMENTS_FILE");
        return file != null && file.exists();
    }

    @Override
    protected void handleNonZeroProcessExit(int exitCode, String projectRoot, String output) throws CollectionException {
        String errMsg;
        CollectionErrorType errType;
        switch (exitCode) {
            case 2: {
                errType = CollectionErrorType.SYSTEM;
                errMsg = "SourceClear couldn't scan the project located at:\n" + projectRoot + "\n\nA configuration error occurred while attempting to run a Python scan.\nWe suggest the following:\n1) Ensure that your dependencies file (e.g. requirements.txt) is not corrupted and can be read.\n2) Check that your network is working.";
                break;
            }
            case 3: {
                errType = CollectionErrorType.PACKAGE_MANAGER;
                errMsg = "SourceClear couldn't scan the project located at:\n" + projectRoot + "\n\nAn error occurred while attempting to collect Python package information.\nWe suggest the following:\n1) Ensure that your dependencies file (e.g. requirements.txt) is not corrupted and can be read.\n2) Check that your network is working and you can access PyPi.";
                break;
            }
            case 100: {
                errType = CollectionErrorType.SYSTEM;
                errMsg = "SourceClear couldn't scan the project located at:\n" + projectRoot + "\n\nThe SourceClear scan was not able to run Python on the machine.\nWe suggest the following:\n1) Ensure that Python is executable and not corrupted.";
                break;
            }
            case 101: {
                errType = CollectionErrorType.SYSTEM;
                errMsg = "SourceClear couldn't scan the project located at:\n" + projectRoot + "\n\nThe SourceClear scan requires Python 2.6 or later and we could not find\na compatible version on the machine.\nWe suggest the following:\n1) Ensure a compatible version of Python is installed.\n2) The Python binary can be found on PATH.";
                break;
            }
            default: {
                errType = CollectionErrorType.UNKNOWN;
                errMsg = "An error occurred during Python component scanning for the project located at:\n" + projectRoot + "\n\nWhile we are unsure of the exact reasons for this error, we suggest the following:\n1) Ensure Python>=2.6 is installed and can be found on PATH.\n2) Ensure that your dependencies file (e.g. requirements.txt) is not corrupted and can be read.\n3) Check that your network is working and you can access PyPi.";
            }
        }
        throw new CollectionException(errType, errMsg, output);
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        try {
            FileTypeVisitor visitor = PythonFileVisitor.getVisitor();
            Files.walkFileTree(Paths.get(projectRoot.getCanonicalPath(), new String[0]), visitor);
            return !visitor.getFiles().isEmpty();
        }
        catch (Exception ex) {
            this.logStream.log("com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION, "Unable to determine vulnerable methods support, skipping.");
            LOGGER.error("Couldn't scan for python files.", (Throwable)ex);
            return false;
        }
    }

    static void maybeAddSystemSitePackages(List<String> commandPieces, Map<String, Object> attributes) {
        Boolean includeSystemSitePackages = PIPNativeCollector.attributeToBoolean(attributes, "SYSTEM_SITE_PACKAGES");
        if (includeSystemSitePackages != null && includeSystemSitePackages.booleanValue()) {
            commandPieces.add("--system-site-packages");
        }
    }

    static void maybeAddUseSystemPipArgument(List<String> commandPieces, Map<String, Object> attributes) {
        Boolean useSystemPIP = PIPNativeCollector.attributeToBoolean(attributes, "USE_SYSTEM_PIP");
        if (useSystemPIP != null && useSystemPIP.booleanValue()) {
            commandPieces.add("--use-system-pip");
        }
    }

    static void maybeAddPipRequirementsArgument(List<String> commandPieces, Map<String, Object> attributes) throws IOException {
        File pipRequirementsFile = PIPNativeCollector.attributeToFile(attributes, "PIP_REQUIREMENTS_FILE");
        if (pipRequirementsFile == null) {
            return;
        }
        String pipRequirementsFileStr = pipRequirementsFile.toString();
        if (!pipRequirementsFile.exists()) {
            throw new IOException(String.format("The pip requirements path %s specified to the SourceClear scan does not exist.", pipRequirementsFileStr));
        }
        if (!pipRequirementsFile.isFile()) {
            throw new IOException(String.format("The pip requirements path \"%s\" specified to the SourceClear scan is not a file.%nPlease point this path at the PIP requirements file itself.", pipRequirementsFileStr));
        }
        if (!pipRequirementsFile.canRead()) {
            throw new IOException(String.format("The pip requirements path \"%s\" specified to the SourceClear scan cannot be read.%nPlease check its read permissions.", pipRequirementsFileStr));
        }
        commandPieces.add("-r");
        commandPieces.add(pipRequirementsFileStr);
    }

    File getDepyFile(URL depyURL, String depyVersion) throws IOException {
        File depyDirFile = new File(srcclrHome, "depy");
        return IO.downloadFileIntoDir(depyURL, String.format("depy-%s.py", depyVersion), depyDirFile, EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE), false);
    }

    private static Boolean attributeToBoolean(Map<String, Object> attributes, String key) {
        Object obj = attributes.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.getBoolean((String)obj);
        }
        throw new IllegalArgumentException(String.format("Expected a String or Boolean for %s, but found %s", key, obj.getClass()));
    }

    private static File attributeToFile(Map<String, Object> attributes, String key) {
        Object obj = attributes.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        if (obj instanceof String) {
            String str = obj.toString();
            return str.isEmpty() ? null : new File(str);
        }
        throw new IllegalArgumentException(String.format("Expected a String or File for %s, but found %s", key, obj.getClass()));
    }
}

