/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.natives.parsing.PackageDotJson;
import com.sourceclear.engine.component.yarn.AbstractYarnCollector;
import com.sourceclear.engine.component.yarn.YarnLockFile;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnNativeCollector
extends AbstractYarnCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnNativeCollector.class);
    private static final String COLLECTOR_NAME = "Yarn";
    private static final String YARN_BIN = "yarn";
    private final ImmutableMap<String, Object> attributes;
    private final LogStream logStream;

    public YarnNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.attributes = attributes;
        this.logStream = logStream;
    }

    @Override
    public String getName() {
        return COLLECTOR_NAME;
    }

    @Override
    public boolean supports(File projectPath) {
        return CollectorUtils.fileExistsWithinFolder(projectPath, "yarn.lock") && CollectorUtils.fileExistsWithinFolder(projectPath, "package.json");
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames("yarn.lock");
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        boolean yarnBinExists = true;
        try {
            CollectorUtils.resolveExeOrThrow(YARN_BIN);
        }
        catch (CollectionException e) {
            yarnBinExists = false;
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage() + ". Yarn collection requires yarn to be installed.");
        }
        return CollectorUtils.fileExistsWithinFolder(projectDir, "yarn.lock") && CollectorUtils.fileExistsWithinFolder(projectDir, "package.json") && yarnBinExists;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        YarnLockFile yarnLockFile = this.getYarnLockFile(projectRoot);
        PackageDotJson packageDotJson = this.getPackageDotJson(projectRoot);
        LOGGER.debug("In package.json, no. of dependencies: {}, no. of optionalDependencies: {}, no. of devDependencies: {}, no. of peerDependencies: {}", new Object[]{packageDotJson.getDependencies().size(), packageDotJson.getOptionalDependencies().size(), packageDotJson.getDevDependencies().size(), packageDotJson.getPeerDependencies().size()});
        LibraryGraph.Builder builder = new LibraryGraph.Builder();
        builder.withFilename("yarn.lock");
        String projectName = packageDotJson.getName();
        String projectVersion = packageDotJson.getVersion();
        if (StringUtils.isNotBlank((CharSequence)projectName) && StringUtils.isNotBlank((CharSequence)projectVersion)) {
            builder.withCoords(new Coords.Builder().withCoordinateType(CoordinateType.NPM).withCoordinate1(projectName).withVersion(projectVersion).build());
        }
        return this.buildGraph(this.attributes, builder, packageDotJson, yarnLockFile);
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

