/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.composer;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ComposerLockPackage {
    private String name;
    private String version;
    private Map<String, String> requires = new HashMap<String, String>();
    private Map<String, String> requireDevs = new HashMap<String, String>();
    private String scope;

    public ComposerLockPackage(String name, String version, String scope) {
        this.name = name;
        this.version = version;
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposerLockPackage that = (ComposerLockPackage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.scope, that.scope);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.scope);
    }

    public String toString() {
        return "ComposerLockPackage{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", scope='" + this.scope + '\'' + '}';
    }

    public void addAllToRequires(@Nonnull Map<String, String> map) {
        this.requires.putAll(map);
    }

    public void addAllToRequireDevs(@Nonnull Map<String, String> map) {
        this.requireDevs.putAll(map);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public ImmutableMap<String, String> getRequires() {
        return ImmutableMap.copyOf(this.requires);
    }

    public ImmutableMap<String, String> getRequireDevs() {
        return ImmutableMap.copyOf(this.requireDevs);
    }
}

