/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.composer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ComposerTreeNode {
    private final String name;
    private final Collection<ComposerTreeNode> children = new ArrayList<ComposerTreeNode>();

    public ComposerTreeNode(@Nonnull String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Cannot create ComposerTreeNode with blank name.");
        }
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposerTreeNode that = (ComposerTreeNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.children);
    }

    public String toString() {
        return "ComposerTreeNode{name='" + this.name + '\'' + ", children=" + this.children + '}';
    }

    public String getName() {
        return this.name;
    }

    public Collection<ComposerTreeNode> getChildren() {
        return this.children;
    }

    public void addChild(ComposerTreeNode child) {
        this.children.add(child);
    }
}

