/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.dllutils;

import com.sourceclear.analysis.dotnet.Executable;
import com.srcclr.sdk.LibraryGraph;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLLAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DLLAnalyzer.class);
    private final Executable srcdotExecutable;

    public DLLAnalyzer(Executable srcdotExecutable) {
        this.srcdotExecutable = srcdotExecutable;
    }

    public Set<LibraryGraph> analyze(Path dll, String relativeFileName) {
        HashSet<LibraryGraph> graphs = new HashSet<LibraryGraph>();
        try {
            LibraryGraph.Builder builder = new LibraryGraph.Builder().withFilename(relativeFileName);
            try (InputStream dllInputStream = Files.newInputStream(dll, new OpenOption[0]);){
                builder.withSha2(DigestUtils.sha256Hex((InputStream)dllInputStream));
            }
            catch (Exception ex) {
                LOGGER.info("Could not compute sha2 for {}: ", (Object)relativeFileName, (Object)ex);
            }
            builder.withBytecodeHash(this.srcdotExecutable.hash(dll));
            LibraryGraph graph = builder.build();
            graphs.add(graph);
            LOGGER.debug("Analyzed {} (sha2={}, bytecode={})", new Object[]{relativeFileName, graph.getSha2(), graph.getBytecodeHash()});
        }
        catch (Exception ex) {
            LOGGER.info("Could not compute bytecode hash for {}: ", (Object)relativeFileName, (Object)ex);
        }
        return graphs;
    }
}

