/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.gem;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Gem {
    private final String name;
    private final String version;
    private final Set<String> platforms;
    private final String path;
    private final boolean require;
    private final String requireAs;
    private final Set<String> groups;

    public Gem(String name, String version, Set<String> platforms, String path, boolean require, String requireAs, Set<String> groups) {
        this.name = name;
        this.version = version;
        this.platforms = platforms;
        this.path = path;
        this.require = require;
        this.requireAs = requireAs;
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gem gem = (Gem)o;
        return Objects.equals(this.name, gem.name) && Objects.equals(this.version, gem.version) && Objects.equals(this.platforms, gem.platforms) && Objects.equals(this.path, gem.path) && Objects.equals(this.require, gem.require) && Objects.equals(this.requireAs, gem.requireAs) && Objects.equals(this.groups, gem.groups);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.platforms, this.path, this.requireAs, this.groups);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Gem{");
        sb.append("name='").append(this.name).append('\'');
        if (this.version != null) {
            sb.append(", version='").append(this.version).append('\'');
        }
        if (this.platforms != null && !this.platforms.isEmpty()) {
            sb.append(", platforms=").append(this.platforms);
        }
        if (this.path != null) {
            sb.append(", path='").append(this.path).append('\'');
        }
        if (!this.require) {
            sb.append(", require='").append(this.require).append('\'');
        }
        if (this.requireAs != null) {
            sb.append(", requireAs='").append(this.requireAs).append('\'');
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append(", groups='").append(this.groups).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public static GemBuilder builder() {
        return new GemBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getPlatforms() {
        return this.platforms;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequireAs() {
        return this.requireAs;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public static class GemBuilder {
        private String name;
        private String version;
        private Set<String> platforms = new HashSet<String>();
        private String path;
        private boolean require = true;
        private String requireAs;
        private Set<String> groups = new HashSet<String>();

        public GemBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public GemBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public GemBuilder withPlatform(String platform) {
            this.platforms.add(platform);
            return this;
        }

        public GemBuilder withPath(String path) {
            this.path = path;
            return this;
        }

        public GemBuilder withRequire(boolean require) {
            this.require = require;
            return this;
        }

        public GemBuilder withRequireAs(String requireAs) {
            this.requireAs = requireAs;
            return this;
        }

        public GemBuilder withGroup(String group) {
            this.groups.add(group);
            return this;
        }

        public Gem build() {
            return new Gem(this.name, this.version, this.platforms, this.path, this.require, this.requireAs, this.groups);
        }
    }
}

