/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.golang;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class GoPackage {
    private static Pattern PROTOCOL_PATTERN = Pattern.compile("[a-zA-Z]+://");
    private static Pattern REPO_AUTHORITY_PATTERN = Pattern.compile(".+@(.+):(.+)");
    private final String importPath;
    private String revision;
    private final String repository;
    private final String repositoryImportPath;
    private int lineNumber;

    public static boolean isSameMainPackage(@Nonnull String importPath1, @Nonnull String importPath2) {
        if (importPath1.startsWith(".") || importPath2.startsWith(".")) {
            return true;
        }
        String importPath1WithoutSubModules = GoPackage.removeSubModulesIfPresent(importPath1);
        String importPath2WithoutSubModules = GoPackage.removeSubModulesIfPresent(importPath2);
        return importPath1WithoutSubModules.equals(importPath2WithoutSubModules);
    }

    public static String removeSubModulesIfPresent(String importPath) {
        String[] tokens = importPath.split("/");
        if (tokens.length <= 3) {
            return importPath;
        }
        return String.format("%s/%s/%s", tokens[0], tokens[1], tokens[2]);
    }

    public static String removeSubModulesAndProtocolIfPresent(String uriString) throws URISyntaxException {
        Matcher protocolMatcher = PROTOCOL_PATTERN.matcher(uriString);
        if (protocolMatcher.find()) {
            URI uri = new URI(uriString);
            if (uri.getScheme().equalsIgnoreCase("ssh")) {
                return GoPackage.getPackageNameFromRepoWithoutProtocol(uri.getAuthority() + uri.getPath());
            }
            String[] tokens = uri.getPath().split("/");
            String pathWithoutSubModules = tokens.length < 3 ? uri.getPath() : String.format("/%s/%s", tokens[1], tokens[2]);
            String packageName = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), pathWithoutSubModules, uri.getQuery(), uri.getFragment()).toString().replaceFirst(uri.getScheme() + "://", "").toLowerCase();
            return GoPackage.removeGitExtensionIfPresent(packageName);
        }
        return GoPackage.getPackageNameFromRepoWithoutProtocol(uriString);
    }

    public GoPackage(String importPath, String revision, int lineNumber) throws URISyntaxException {
        this(importPath, revision, lineNumber, null);
    }

    public GoPackage(String importPath, String revision, int lineNumber, String repository) throws URISyntaxException {
        if (StringUtils.isBlank((String)importPath)) {
            throw new IllegalArgumentException("importPath cannot be empty when initializing GoPackage class.");
        }
        if (revision == null) {
            throw new IllegalArgumentException("revision cannot be null when initializing GoPackage class.");
        }
        this.importPath = GoPackage.removeSubModulesIfPresent(importPath);
        this.revision = revision;
        this.lineNumber = lineNumber;
        if (repository != null) {
            this.repository = repository;
            this.repositoryImportPath = GoPackage.removeSubModulesAndProtocolIfPresent(repository);
        } else {
            this.repository = null;
            this.repositoryImportPath = null;
        }
    }

    public boolean revisionIsCommitHash() {
        return this.revision.matches("[a-fA-F0-9]{7,40}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoPackage goPackage = (GoPackage)o;
        return Objects.equals(this.importPath, goPackage.importPath) && Objects.equals(this.revision, goPackage.revision) && Objects.equals(this.lineNumber, goPackage.lineNumber) && Objects.equals(this.repository, goPackage.repository) && Objects.equals(this.repositoryImportPath, goPackage.repositoryImportPath);
    }

    public int hashCode() {
        return Objects.hash(this.importPath, this.revision, this.lineNumber, this.repository, this.repositoryImportPath);
    }

    public String toString() {
        return "GoPackage{importPath=" + this.importPath + ", revision=" + this.revision + ", lineNumber=" + this.lineNumber + ", repository=" + this.repository + ", repositoryImportPath=" + this.repositoryImportPath + ", }";
    }

    private static String getPackageNameFromRepoWithoutProtocol(String repoWithoutProtocol) {
        Matcher matcher = REPO_AUTHORITY_PATTERN.matcher(repoWithoutProtocol);
        if (matcher.find()) {
            String domain = matcher.group(1);
            String orgAndRepo = matcher.group(2);
            return GoPackage.removeGitExtensionIfPresent(String.format("%s/%s", domain, orgAndRepo));
        }
        throw new RuntimeException("Unable to determine package name from repo: " + repoWithoutProtocol);
    }

    private static String removeGitExtensionIfPresent(String input) {
        return input.endsWith(".git") ? input.substring(0, input.length() - 4) : input;
    }

    public String getCoord1() {
        return StringUtils.isNotBlank((String)this.repositoryImportPath) ? this.repositoryImportPath : this.importPath;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public String getRepositoryImportPath() {
        return this.repositoryImportPath;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getRepository() {
        return this.repository;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setRevision(String revision) {
        if (revision == null) {
            throw new IllegalArgumentException("revision cannot be null.");
        }
        this.revision = revision;
    }
}

