/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.golang;

import com.moandjiezana.toml.Toml;
import com.sourceclear.engine.component.golang.GoPackage;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class GopkgLockFile {
    private List<Project> projects;

    public static GopkgLockFile parse(InputStream inputStream) {
        return (GopkgLockFile)new Toml().read(inputStream).to(GopkgLockFile.class);
    }

    private GopkgLockFile() {
    }

    public List<GoPackage> getGoPackages() {
        if (this.projects == null) {
            return new ArrayList<GoPackage>();
        }
        ArrayList<GoPackage> goPackages = new ArrayList<GoPackage>(this.projects.size());
        for (Project project : this.projects) {
            goPackages.add(this.toGoPackage(project));
        }
        return goPackages;
    }

    private GoPackage toGoPackage(Project project) {
        String importPath = project.name;
        String revision = StringUtils.isNotBlank((CharSequence)project.version) ? project.version : project.revision;
        String repository = project.source;
        try {
            return new GoPackage(importPath, revision, -1, repository);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(String.format("Invalid source URI format: %s", repository), ex);
        }
    }

    private static class Project {
        @Nullable
        private String branch;
        @Nullable
        private String name;
        @Nullable
        private String revision;
        @Nullable
        private String source;
        @Nullable
        private String version;
        @Nullable
        private List<String> packages;

        private Project() {
        }
    }
}

