/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.linecount;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.client.Client;
import com.sourceclear.engine.component.linecount.Counter;
import com.sourceclear.engine.component.linecount.DotNetDLLCounter;
import com.sourceclear.engine.component.linecount.SourceFileCounter;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineCounter.class);

    public static long countLOC(File projectRoot, Client client) throws IOException {
        ImmutableSet<Counter> counters = LineCounter.getCounters(projectRoot, client);
        long count = 0L;
        for (Counter counter : counters) {
            if (!counter.shouldCount(projectRoot)) continue;
            String counterName = counter.getName();
            LOGGER.debug("'{}' counting LOC.", (Object)counterName);
            long currentCount = counter.count(projectRoot);
            LOGGER.debug("'{}' returned {} LOC.", (Object)counterName, (Object)currentCount);
            count += currentCount;
        }
        return count;
    }

    private static ImmutableSet<Counter> getCounters(File projectRoot, Client client) throws IOException {
        return new ImmutableSet.Builder().add((Object)new SourceFileCounter()).add((Object)new DotNetDLLCounter(client)).build();
    }
}

