/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.natives.parsing;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NPMTreeParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(NPMTreeParser.class);

    public static LibraryGraph parse(String filename, String jsonTree) throws CollectionException {
        return new NPMTreeParser().parseFile(filename, jsonTree);
    }

    private NPMTreeParser() {
    }

    private LibraryGraph parseFile(String filename, String jsonTree) throws CollectionException {
        try {
            return this.toLibraryGraph(filename, (NPMDependency)MAPPER.readValue(jsonTree, NPMDependency.class));
        }
        catch (Exception ex) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "Invalid NPM dependency tree", jsonTree, ex);
        }
    }

    private LibraryGraph toLibraryGraph(String filename, NPMDependency root) {
        HashMap globalDependencies = Maps.newHashMap();
        HashSet transitive = Sets.newHashSet();
        for (Map.Entry e : root.dependencies.entrySet()) {
            if (!NPMTreeParser.isInstalledAndhasValidVersion((NPMDependency)e.getValue())) continue;
            this.flatten((String)e.getKey(), (NPMDependency)e.getValue(), new HashSet<Coords>(), globalDependencies, transitive);
        }
        HashSet direct = new HashSet(globalDependencies.keySet());
        direct.removeAll(transitive);
        LibraryGraph.Builder builder = new LibraryGraph.Builder().withFilename(filename);
        if (!Strings.isNullOrEmpty((String)root.name) && !Strings.isNullOrEmpty((String)root.version)) {
            builder.withCoords(NPMTreeParser.coords(root.name, root.version));
        }
        for (Coords coords : direct) {
            Optional<LibraryGraph> subgraph = this.rebuildGraph(filename, coords, new HashSet<Coords>(), globalDependencies, new HashMap<Coords, LibraryGraph>());
            if (!subgraph.isPresent()) continue;
            builder.withDirect((LibraryGraph)subgraph.get());
        }
        return builder.build();
    }

    private void flatten(String name, NPMDependency node, Set<Coords> seen, Map<Coords, Set<Coords>> globalDependencies, Set<Coords> transitive) {
        Coords c = NPMTreeParser.coords(name, node.version);
        if (seen.contains(c)) {
            return;
        }
        seen.add(c);
        Set<Object> deps = globalDependencies.containsKey(c) ? globalDependencies.get(c) : Sets.newHashSet();
        for (Map.Entry e : node.requires.entrySet()) {
            deps.add(NPMTreeParser.coords((String)e.getKey(), (String)e.getValue()));
        }
        for (Map.Entry e : node.dependencies.entrySet()) {
            deps.add(NPMTreeParser.coords((String)e.getKey(), ((NPMDependency)e.getValue()).version));
        }
        globalDependencies.put(c, (Set<Coords>)deps);
        transitive.addAll(deps);
        for (Map.Entry e : node.dependencies.entrySet()) {
            if (!NPMTreeParser.isInstalledAndhasValidVersion((NPMDependency)e.getValue())) continue;
            this.flatten((String)e.getKey(), (NPMDependency)e.getValue(), seen, globalDependencies, transitive);
        }
        seen.remove(c);
    }

    private Optional<LibraryGraph> rebuildGraph(String filename, Coords coords, Set<Coords> seen, Map<Coords, Set<Coords>> globalDependencies, Map<Coords, LibraryGraph> cache) {
        LibraryGraph result;
        if (seen.contains(coords)) {
            return Optional.absent();
        }
        seen.add(coords);
        if (cache.containsKey(coords)) {
            result = cache.get(coords);
        } else {
            LibraryGraph.Builder builder = new LibraryGraph.Builder().withFilename(filename).withCoords(coords);
            Set deps = globalDependencies.getOrDefault(coords, Collections.emptySet());
            for (Coords dep : deps) {
                Optional<LibraryGraph> child;
                if (!NPMTreeParser.hasValidVersion(dep) || !(child = this.rebuildGraph(filename, dep, seen, globalDependencies, cache)).isPresent()) continue;
                builder.withDirect((LibraryGraph)child.get());
            }
            result = builder.build();
            cache.put(coords, result);
        }
        seen.remove(coords);
        return Optional.of((Object)result);
    }

    private static boolean hasValidVersion(Coords coords) {
        return coords.getVersion() != null;
    }

    private static boolean isInstalledAndhasValidVersion(NPMDependency npmDependency) {
        return !npmDependency.missing && StringUtils.isNotBlank((String)npmDependency.version);
    }

    private static Coords coords(String name, String version) {
        return new Coords.Builder().withCoordinateType(CoordinateType.NPM).withCoordinate1(name).withVersion(version).build();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class NPMDependency {
        @JsonProperty
        private String name;
        @JsonProperty
        private String version;
        @JsonProperty
        private boolean missing;
        private Map<String, String> requires = Maps.newHashMap();
        @JsonProperty
        private Map<String, NPMDependency> dependencies = Maps.newHashMap();

        private NPMDependency() {
        }

        @JsonProperty(value="requires")
        @JsonDeserialize(using=Deserializer.class)
        public void setRequires(Map<String, String> requires) {
            this.requires = requires;
        }

        private static class Deserializer
        extends JsonDeserializer<Map<String, String>> {
            private static final TypeReference<Map<String, String>> DEPENDENCY_VERSION_MAP = new TypeReference<Map<String, String>>(){};

            private Deserializer() {
            }

            public Map<String, String> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                if (JsonToken.START_OBJECT.equals((Object)parser.getCurrentToken())) {
                    return (Map)MAPPER.readValue(parser, DEPENDENCY_VERSION_MAP);
                }
                return Maps.newHashMap();
            }
        }
    }
}

