/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.pipenv;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.engine.component.pipenv.PipPackageDetailsDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PipfileDotLock {
    public static final String PIPFILE = "Pipfile";
    public static final String PIPFILE_LOCK = "Pipfile.lock";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Map<String, PipPackageDetails> defaults = new HashMap<String, PipPackageDetails>();
    private Map<String, PipPackageDetails> develop = new HashMap<String, PipPackageDetails>();

    public static PipfileDotLock parse(InputStream inputStream) throws IOException {
        return (PipfileDotLock)MAPPER.readValue(inputStream, PipfileDotLock.class);
    }

    @JsonProperty(value="default")
    private void setDefaults(Map<String, PipPackageDetails> map) {
        for (Map.Entry<String, PipPackageDetails> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            this.defaults.put(entry.getKey(), entry.getValue());
        }
    }

    @JsonProperty(value="develop")
    private void setDevelop(Map<String, PipPackageDetails> map) {
        for (Map.Entry<String, PipPackageDetails> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            this.develop.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, PipPackageDetails> getDefaultPackages() {
        return new ImmutableMap.Builder().putAll(this.defaults).build();
    }

    public Map<String, PipPackageDetails> getDevelopPackages() {
        return new ImmutableMap.Builder().putAll(this.develop).build();
    }

    @JsonDeserialize(using=PipPackageDetailsDeserializer.class)
    public static class PipPackageDetails {
        private final String version;
        private final int lineNumber;

        public PipPackageDetails(@Nonnull String version, int lineNumber) {
            this.version = version;
            this.lineNumber = lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipPackageDetails that = (PipPackageDetails)o;
            return Objects.equals(this.version, that.version) && Objects.equals(this.lineNumber, that.lineNumber);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.lineNumber);
        }

        public String toString() {
            return "PipPackage{version='" + this.version + '\'' + ", lineNumber='" + this.lineNumber + '\'' + '}';
        }

        public String getVersion() {
            return this.version;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

