/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.gem.GemfileDotLockToGraph;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class GemfileDotLockQuickscanCollector
implements QuickscanCollector {
    @Override
    @Nonnull
    public String getName() {
        return "Gemfile.lock Quickscan";
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        Path path = scanTarget.toPath();
        Path gemlockFile = Files.isDirectory(path, new LinkOption[0]) ? path.resolve("Gemfile.lock") : path;
        LibraryGraph graph = GemfileDotLockToGraph.convert(gemlockFile);
        return new LibraryGraphContainer.Builder().withGraph(graph).build();
    }

    @Override
    public boolean supports(File file) {
        Path path = file.toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return Files.exists(path.resolve("Gemfile.lock"), new LinkOption[0]);
        }
        return Files.exists(path, new LinkOption[0]) && path.getFileName().toString().equals("Gemfile.lock");
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

