/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.GoPackageManagerCollector;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class GoQuickscanCollector
implements QuickscanCollector {
    private Path lockfile;

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        if (this.lockfile == null) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, String.format("'%s' does not support this project but evidence collection was attempted.", this.getName()));
        }
        List<GoPackage> goPackages = this.dependencies(this.lockfile);
        HashSet<LibraryGraph> directs = new HashSet<LibraryGraph>();
        for (GoPackage goPackage : goPackages) {
            LibraryGraph.Builder builder = new LibraryGraph.Builder().withCoords(GoPackageManagerCollector.toCoords(goPackage)).withFilename(this.lockfile.getFileName().toString());
            if (goPackage.getLineNumber() > 0) {
                builder.withLineNumber(Integer.valueOf(goPackage.getLineNumber()));
            }
            directs.add(builder.build());
        }
        LibraryGraph root = new LibraryGraph.Builder().withFilename(this.lockfile.getFileName().toString()).withDirects(directs).build();
        return new LibraryGraphContainer.Builder().withGraph(root).build();
    }

    @Override
    public boolean supports(File file) {
        boolean exists;
        Path path = file.toPath();
        String fileDir = this.lockDir();
        String filename = this.lockFile();
        Path checkPath = Files.isDirectory(path, new LinkOption[0]) ? (StringUtils.isNotBlank((CharSequence)fileDir) && !path.getFileName().toString().equals(fileDir) ? path.resolve(Paths.get(fileDir, filename)) : path.resolve(filename)) : path;
        boolean bl = exists = Files.exists(checkPath, new LinkOption[0]) && checkPath.getFileName().toString().equals(filename);
        if (exists) {
            this.lockfile = checkPath;
        }
        return exists;
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }

    @Nonnull
    abstract String lockDir();

    @Nonnull
    abstract String lockFile();

    @Nonnull
    abstract List<GoPackage> dependencies(Path var1) throws CollectionException;
}

