/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.BaseMethodsEngine;
import com.sourceclear.engine.methods.GradleModuleAwareScanBatcher;
import com.sourceclear.engine.methods.MavenModuleAwareScanBatcher;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.engine.methods.SimpleFileMethodScanBatcher;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.JavaMethodScannerFactory;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.PermissiveEntryPointResolver;
import com.sourceclear.methods.VulnMethodsConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassMethodsEngine
extends BaseMethodsEngine {
    private static final EntryPointResolver ENTRY_POINT_RESOLVER = new PermissiveEntryPointResolver();
    private final MethodScannerFactory methodScannerFactory = new JavaMethodScannerFactory();

    @Override
    public Collection<MethodCallData> scanMethods(Path scanRoot, Collection<MethodCallData> inputMethodData, LogStream logStream) {
        try {
            return this.innerScanMethods(scanRoot, inputMethodData, logStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodsEngine withVulnMethodsConfig(VulnMethodsConfig config) {
        this.methodScannerFactory.withVulnMethodsConfig(config);
        return this;
    }

    @Override
    public VulnMethodsConfig.Builder defaultConfig() {
        return this.methodScannerFactory.defaultVulnMethodsConfig().parallel(true);
    }

    @Override
    MethodScanBatcher setupBatcher(Path scanRoot, LogStream logStream) {
        Path pomFile = scanRoot.resolve("pom.xml");
        if (Files.exists(pomFile, new LinkOption[0])) {
            return new MavenModuleAwareScanBatcher(this.methodScannerFactory, logStream);
        }
        Path buildFile = scanRoot.resolve("build.gradle");
        if (Files.exists(buildFile, new LinkOption[0])) {
            return new GradleModuleAwareScanBatcher(this.methodScannerFactory, logStream);
        }
        return new SimpleFileMethodScanBatcher(this.methodScannerFactory, logStream, ClassFileVisitor.getVisitor());
    }
}

