/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AdjacencyList {
    private Map<Integer, MethodInfo> vertices = new HashMap<Integer, MethodInfo>();
    private Map<Integer, List<Edge>> edges = new HashMap<Integer, List<Edge>>();

    public AdjacencyList() {
    }

    public AdjacencyList(CallGraph graph) {
        int i = 0;
        HashMap<MethodInfo, Integer> vertexMappings = new HashMap<MethodInfo, Integer>();
        for (MethodInfo node : graph.verticesIt()) {
            vertexMappings.put(node, i);
            this.vertices.put(i, node);
            ++i;
        }
        for (CallSite callSite : graph.edgesIt()) {
            if (!this.edges.containsKey(vertexMappings.get(callSite.getCaller()))) {
                this.edges.put((Integer)vertexMappings.get(callSite.getCaller()), new ArrayList());
            }
            List<Edge> callees = this.edges.get(vertexMappings.get(callSite.getCaller()));
            callees.add(new Edge((Integer)vertexMappings.get(callSite.getCallee()), callSite.getFileName(), callSite.getLineNumber()));
        }
    }

    public CallGraph toGraph() {
        CallGraph result = new CallGraph();
        for (Map.Entry<Integer, MethodInfo> entry : this.vertices.entrySet()) {
            result.addVertex(entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : this.edges.entrySet()) {
            for (Edge edge : (List)entry.getValue()) {
                MethodInfo from = this.vertices.get(entry.getKey());
                MethodInfo to = this.vertices.get(edge.vertex);
                CallSite callSite = new CallSite(from, to, edge.fileName, edge.line);
                result.addEdge(callSite);
            }
        }
        return result;
    }

    public Map<Integer, MethodInfo> getVertices() {
        return this.vertices;
    }

    public Map<Integer, List<Edge>> getEdges() {
        return this.edges;
    }

    @JsonSerialize(using=Serializer.class)
    @JsonDeserialize(using=Deserializer.class)
    public static class Edge {
        private int vertex;
        private String fileName;
        private int line;

        public Edge() {
        }

        public Edge(int vertex, String fileName, int line) {
            this.vertex = vertex;
            this.fileName = fileName;
            this.line = line;
        }

        public static class Deserializer
        extends StdDeserializer<Edge> {
            public Deserializer() {
                this(null);
            }

            public Deserializer(Class<Edge> t) {
                super(t);
            }

            public Edge deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                if (!node.isArray()) {
                    throw new IOException("Not an array: " + node);
                }
                Iterator it = node.iterator();
                int vertex = ((JsonNode)it.next()).asInt();
                int line = ((JsonNode)it.next()).asInt();
                String filename = ((JsonNode)it.next()).asText();
                return new Edge(vertex, filename, line);
            }
        }

        public static class Serializer
        extends StdSerializer<Edge> {
            public Serializer() {
                this(null);
            }

            public Serializer(Class<Edge> t) {
                super(t);
            }

            public void serialize(Edge edge, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartArray();
                jsonGenerator.writeNumber(edge.vertex);
                jsonGenerator.writeNumber(edge.line);
                jsonGenerator.writeString(edge.fileName);
                jsonGenerator.writeEndArray();
            }
        }
    }
}

