/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.sgl.TinkerPop;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class ReachabilityInspector {
    private final CallGraph callGraph;

    ReachabilityInspector(CallGraph callGraph) {
        this.callGraph = callGraph;
    }

    public Set<MethodInfo> findPossibleCallers(Set<MethodInfo> targets, Set<MethodInfo> entry) {
        HashSet<MethodInfo> calledTargets = new HashSet<MethodInfo>();
        for (MethodInfo target : targets) {
            if (this.callGraph.callersFor(target).isEmpty()) continue;
            calledTargets.add(target);
        }
        if (calledTargets.isEmpty()) {
            return Collections.emptySet();
        }
        Graph graph = this.callGraph.getGraph();
        Set<Map<String, Object>> ids = targets.stream().filter(this.callGraph::containsVertex).map(this.callGraph::getVertex).map(v -> (Map)v.id()).collect(Collectors.toSet());
        return TinkerPop.withStartingVertices(graph, ids, "called_by*", t -> t.toStream().map(this.callGraph::getMethodInfo).filter(entry::contains).collect(Collectors.toSet()));
    }
}

