/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.CallChainsInspector;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallGraphBuilder;
import com.sourceclear.methods.Cleaner;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.ReachabilityInspector;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VulnerablePartsDetector
implements MethodScanner {
    private final Collection<MethodInfo> vulnerableMethods;
    private final EntryPointResolver entryPointResolver;
    private final CallGraphBuilder callGraphBuilder;
    private final Cleaner cleaner;

    public VulnerablePartsDetector(Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver, CallGraphBuilder callGraphBuilder, Cleaner cleaner) throws IOException {
        this.vulnerableMethods = vulnerableMethods;
        this.entryPointResolver = entryPointResolver;
        this.callGraphBuilder = callGraphBuilder;
        this.cleaner = cleaner;
    }

    @Override
    public MethodScanner stubPublicMethods(Collection<MethodInfo> publicMethods) {
        return this;
    }

    @Override
    public Map<MethodInfo, Collection<CallChain>> scan() throws IOException {
        this.callGraphBuilder.build();
        return this.getVulnerableMethodsCallChain();
    }

    @Override
    public Set<MethodInfo> reachableMethods(Set<MethodInfo> reachableFrom) throws IOException {
        this.callGraphBuilder.build();
        return new ReachabilityInspector(this.getCallGraph()).findPossibleCallers(new HashSet<MethodInfo>(this.vulnerableMethods), reachableFrom);
    }

    @Override
    public boolean vulnerableMethodsAreDefined() throws IOException {
        Set<MethodInfo> methodsDefined = this.callGraphBuilder.getMethodsDefined();
        if (methodsDefined.isEmpty()) {
            this.callGraphBuilder.build();
        }
        return methodsDefined.containsAll(this.vulnerableMethods);
    }

    private Map<MethodInfo, Collection<CallChain>> getVulnerableMethodsCallChain() {
        CallGraph callGraph = this.callGraphBuilder.getCallGraph();
        CallChainsInspector inspector = new CallChainsInspector(callGraph);
        Map<MethodInfo, Collection<CallChain>> callChains = inspector.callChainsFrom(this.vulnerableMethods);
        HashMap vulnerableMethodsCallChains = Maps.newHashMap();
        for (Map.Entry<MethodInfo, Collection<CallChain>> entry : callChains.entrySet()) {
            MethodInfo startOfCallChain = entry.getKey();
            boolean methodHasNoCallerAndIsEntryPoint = callGraph.callersFor(startOfCallChain).isEmpty() && this.entryPointResolver.isEntryPoint(startOfCallChain);
            if (!methodHasNoCallerAndIsEntryPoint) continue;
            for (CallChain callChain : entry.getValue()) {
                MethodInfo vulnerableMethod = callChain.last().getCallee();
                if (vulnerableMethodsCallChains.get(vulnerableMethod) == null) {
                    vulnerableMethodsCallChains.put(vulnerableMethod, Sets.newHashSet((Object[])new CallChain[]{callChain}));
                    continue;
                }
                ((Collection)vulnerableMethodsCallChains.get(vulnerableMethod)).add(callChain);
            }
        }
        return vulnerableMethodsCallChains;
    }

    @Override
    public void close() {
        this.cleaner.clean();
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraphBuilder.getCallGraph();
    }
}

