/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.plugins;

import com.sourceclear.api.client.SourceClearClient;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import org.apache.maven.settings.Proxy;

public class Utils {
    static void maybeSetProxy(SourceClearClient.Builder clientBuilder, List<Proxy> proxies) {
        final Proxy proxy = Utils.findActiveProxy(proxies);
        if (proxy == null) {
            return;
        }
        String protocol = proxy.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            java.net.Proxy javaNetProxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHost(), proxy.getPort()));
            if (proxy.getUsername() != null && proxy.getPassword() != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxy.getUsername(), proxy.getPassword().toCharArray());
                    }
                });
            }
            clientBuilder.withProxy(javaNetProxy);
        }
    }

    private static Proxy findActiveProxy(List<Proxy> proxies) {
        if (proxies == null) {
            return null;
        }
        for (Proxy proxy : proxies) {
            if (!proxy.isActive()) continue;
            return proxy;
        }
        return null;
    }
}

