/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.ast;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.ast.Alias;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.NodeType;
import com.sourceclear.pysonar.types.ListType;
import com.sourceclear.pysonar.types.Type;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportFrom
extends Node {
    public List<Name> module;
    public List<Alias> names;
    public int level;

    public ImportFrom(Analyzer analyzer, @Nullable List<Name> module, @Nullable List<Alias> names, int level, Path file, int lineNumber, int start, int end) {
        super(analyzer, NodeType.IMPORTFROM, file, lineNumber, start, end);
        this.module = module == null ? new ArrayList() : module;
        this.names = names == null ? new ArrayList() : names;
        this.level = level;
        this.addChildren(names);
    }

    public boolean isImportStar() {
        return this.names.size() == 1 && "*".equals(this.names.get((int)0).name.get((int)0).id);
    }

    public void importStar(@NotNull State s, @Nullable Type mt) throws IOException {
        if (mt == null || mt.file == null) {
            return;
        }
        Node node = this.analyzer.getAstForFile(mt.file);
        if (node == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        Type allType = mt.table.lookupType("__all__");
        if (allType != null && allType instanceof ListType) {
            ListType lt = (ListType)allType;
            for (Object o : lt.values) {
                if (!(o instanceof String)) continue;
                names.add((String)o);
            }
        }
        if (!names.isEmpty()) {
            int start = this.start;
            for (String name : names) {
                Set<Binding> b = mt.table.lookupLocal(name);
                if (b != null) {
                    s.update(name, b);
                    continue;
                }
                ArrayList<Name> m2 = new ArrayList<Name>(this.module);
                Name fakeName = new Name(this.analyzer, name, this.getFile(), this.lineNumber, start, start + name.length());
                m2.add(fakeName);
                Type type = this.analyzer.loadModule(m2, s);
                if (type == null) continue;
                start += name.length();
                s.insert(name, fakeName, type, Binding.Kind.VARIABLE);
            }
        } else {
            for (Map.Entry<String, Set<Binding>> e : mt.table.entrySet()) {
                if (e.getKey().startsWith("_")) continue;
                s.update(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "<FromImport:" + this.module + ":" + this.names + ">";
    }
}

