/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.ast;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.SerializablePath;
import com.sourceclear.pysonar.ast.Block;
import com.sourceclear.pysonar.ast.ClassDef;
import com.sourceclear.pysonar.ast.Expr;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.ast.Module;
import com.sourceclear.pysonar.ast.NodeType;
import com.sourceclear.pysonar.ast.Str;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Node
implements Serializable,
Comparable<Object> {
    public NodeType nodeType;
    protected SerializablePath file;
    public int lineNumber;
    public int start;
    public int end;
    public String name;
    public Node parent = null;
    protected final transient Analyzer analyzer;

    public Node(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Node(Analyzer analyzer, NodeType nodeType, Path file, int lineNumber, int start, int end) {
        this.analyzer = analyzer;
        this.nodeType = nodeType;
        this.file = file == null ? null : new SerializablePath(file);
        this.lineNumber = lineNumber;
        this.start = start;
        this.end = end;
    }

    @Nullable
    public Path getFile() {
        return this.file == null ? null : this.file.get();
    }

    public void setFile(Path path) {
        this.file = path == null ? null : new SerializablePath(path);
    }

    public Path getFullPath() {
        if (!this.file.toString().startsWith("/")) {
            return this.analyzer.projectDir.resolve(this.file.get());
        }
        return this.file.get();
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    @NotNull
    public Node getAstRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getAstRoot();
    }

    public int length() {
        return this.end - this.start;
    }

    public void addChildren(Node ... nodes) {
        if (nodes != null) {
            for (Node n : nodes) {
                if (n == null) continue;
                n.setParent(this);
            }
        }
    }

    public void addChildren(@Nullable Collection<? extends Node> nodes) {
        if (nodes != null) {
            for (Node node : nodes) {
                if (node == null) continue;
                node.setParent(this);
            }
        }
    }

    @Nullable
    public Str getDocString() {
        Node docstrNode;
        Node firstExpr;
        Node body = null;
        if (this instanceof FunctionDef) {
            body = ((FunctionDef)this).body;
        } else if (this instanceof ClassDef) {
            body = ((ClassDef)this).body;
        } else if (this instanceof Module) {
            body = ((Module)this).body;
        }
        if (body instanceof Block && ((Block)body).seq.size() >= 1 && (firstExpr = ((Block)body).seq.get(0)) instanceof Expr && (docstrNode = ((Expr)firstExpr).value) != null && docstrNode instanceof Str) {
            return (Str)docstrNode;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Node)) {
            return false;
        }
        Node node = (Node)obj;
        return this.start == node.start && this.end == node.end && Objects.equals(this.file, node.file);
    }

    public int hashCode() {
        return (this.file + ":" + this.start + ":" + this.end).hashCode();
    }

    @Override
    public int compareTo(@NotNull Object o) {
        if (o instanceof Node) {
            return this.start - ((Node)o).start;
        }
        return -1;
    }

    public String toDisplay() {
        return "";
    }

    @NotNull
    public String toString() {
        return "(node:" + this.file + ":" + this.name + ":" + this.start + ")";
    }
}

