/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.hash;

import com.sourceclear.pysonar.hash.EqualFunction;
import com.sourceclear.pysonar.hash.GenericEqualFunction;
import com.sourceclear.pysonar.hash.GenericHashFunction;
import com.sourceclear.pysonar.hash.HashFunction;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MyHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 1;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    int size;
    int threshold;
    final float loadFactor;
    int modCount;
    private Set<Map.Entry<K, V>> entrySet = null;
    volatile Set<K> keySet = null;
    volatile Collection<V> values = null;
    HashFunction hashFunction;
    EqualFunction equalFunction;

    public MyHashMap(int initialCapacity, float loadFactor, HashFunction hashFunction, EqualFunction equalFunction) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.table = new Entry[0];
        this.loadFactor = loadFactor;
        this.hashFunction = hashFunction;
        this.equalFunction = equalFunction;
        this.threshold = initialCapacity;
    }

    public MyHashMap(int initialCapacity, HashFunction hashFunction, EqualFunction equalFunction) {
        this(initialCapacity, 0.75f, hashFunction, equalFunction);
    }

    public MyHashMap(HashFunction hashFunction, EqualFunction equalFunction) {
        this(1, 0.75f, hashFunction, equalFunction);
    }

    public MyHashMap() {
        this(1, 0.75f, new GenericHashFunction(), new GenericEqualFunction());
    }

    public MyHashMap(Map<? extends K, ? extends V> m, HashFunction hashFunction, EqualFunction equalFunction) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 1), 0.75f, hashFunction, equalFunction);
        this.putAll(m);
    }

    private static int roundup(int number) {
        int n;
        if (number >= 0x40000000) {
            return 0x40000000;
        }
        for (n = 1; n < number; n <<= 1) {
        }
        return n;
    }

    private void initTable(int size) {
        size = MyHashMap.roundup(size);
        this.threshold = (int)Math.min((float)size * this.loadFactor, 1.0737418E9f);
        this.table = new Entry[size];
    }

    final int hash(Object k) {
        int h = this.hashFunction.hash(k);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int slot(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(@NotNull Object key) {
        Entry<K, V> entry = this.getEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        return this.getEntry(key) != null;
    }

    final Entry<K, V> getEntry(@NotNull Object key) {
        if (this.isEmpty()) {
            return null;
        }
        int h = this.hash(key);
        Entry<K, V> e = this.table[MyHashMap.slot(h, this.table.length)];
        while (e != null) {
            if (this.equalFunction.equals(e.key, key)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public V put(@NotNull K key, V value) {
        if (this.isEmpty()) {
            this.initTable(this.threshold);
        }
        int h = this.hash(key);
        int i = MyHashMap.slot(h, this.table.length);
        Entry<K, V> e = this.table[i];
        while (e != null) {
            if (this.equalFunction.equals(e.key, key)) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(h, key, value, i);
        return null;
    }

    void resize(int size) {
        if (size > 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
        } else {
            Entry[] table2 = new Entry[size];
            for (Entry<K, V> e : this.table) {
                while (e != null) {
                    Entry next = e.next;
                    int i = MyHashMap.slot(e.hash, size);
                    e.next = table2[i];
                    table2[i] = e;
                    e = next;
                }
            }
            this.table = table2;
            this.threshold = (int)Math.min((float)size * this.loadFactor, 1.0737418E9f);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e = this.removeEntry(key);
        return e == null ? null : (V)e.value;
    }

    Entry<K, V> removeEntry(Object key) {
        Entry<K, V> prev;
        if (this.isEmpty()) {
            return null;
        }
        int h = key == null ? 0 : this.hash(key);
        int i = MyHashMap.slot(h, this.table.length);
        Entry<K, V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (this.equalFunction.equals(e.key, key)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry<K, V> removeMapping(Map.Entry entry) {
        Entry<K, V> prev;
        Object key = entry.getKey();
        int hash = key == null ? 0 : this.hash(key);
        int i = MyHashMap.slot(hash, this.table.length);
        Entry<K, V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (this.equalFunction.equals(value, e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    void addEntry(int h, @NotNull K key, V value, int bucketIndex) {
        if (this.size >= this.threshold && this.table[bucketIndex] != null) {
            this.resize(2 * this.table.length);
            h = this.hash(key);
            bucketIndex = MyHashMap.slot(h, this.table.length);
        }
        this.createEntry(h, key, value, bucketIndex);
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K, V>(hash, key, value, e);
        ++this.size;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = MyHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            if (this.isEmpty() || !(o instanceof Map.Entry)) {
                return false;
            }
            return MyHashMap.this.removeMapping((Map.Entry)o) != null;
        }

        @Override
        public int size() {
            return MyHashMap.this.size;
        }

        @Override
        public void clear() {
            MyHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return MyHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return MyHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            MyHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return MyHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return MyHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return MyHashMap.this.removeEntry(o) != null;
        }

        @Override
        public void clear() {
            MyHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = MyHashMap.this.modCount;
            if (MyHashMap.this.size > 0) {
                Entry<K, V>[] t = MyHashMap.this.table;
                for (int i = 0; i < t.length; ++i) {
                    if (t[i] == null) continue;
                    this.next = t[i];
                    this.index = i;
                    break;
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (MyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Entry ret = this.next;
            this.next = ret.next;
            if (this.next == null) {
                Entry<K, V>[] t = MyHashMap.this.table;
                for (int i = this.index + 1; i < t.length; ++i) {
                    if (t[i] == null) continue;
                    this.index = i;
                    this.next = t[i];
                    break;
                }
            }
            this.current = ret;
            return ret;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (MyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            MyHashMap.this.removeEntry(k);
            this.expectedModCount = MyHashMap.this.modCount;
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        Entry<K, V> next;
        int hash;

        Entry(int h, K k, V v, Entry<K, V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

