/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.types.TupleType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListType
extends Type {
    public Type eltType;
    @NotNull
    public List<Type> positional = new ArrayList<Type>();
    @NotNull
    public List<Object> values = new ArrayList<Object>();

    public ListType(Analyzer analyzer) {
        this(analyzer, analyzer.TYPE_UNKNOWN);
    }

    public ListType(Analyzer analyzer, Type elt0) {
        super(analyzer);
        this.eltType = elt0;
        this.table.addSuper(analyzer.builtins.BaseList.table);
        this.table.setPath(analyzer.builtins.BaseList.table.path);
    }

    public void setElementType(Type eltType) {
        this.eltType = eltType;
    }

    public void add(@NotNull Type another) {
        this.eltType = this.analyzer.union(this.eltType, another);
        this.positional.add(another);
    }

    public void addValue(Object v) {
        this.values.add(v);
    }

    public Type get(int i) {
        return this.positional.get(i);
    }

    @NotNull
    public TupleType toTupleType(int n) {
        TupleType ret = new TupleType(this.analyzer);
        for (int i = 0; i < n; ++i) {
            ret.add(this.eltType);
        }
        return ret;
    }

    @NotNull
    public TupleType toTupleType() {
        return new TupleType(this.analyzer, this.positional);
    }

    @Override
    public boolean typeEquals(Object other) {
        if (this.analyzer.state.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof ListType) {
            ListType co = (ListType)other;
            this.analyzer.state.typeStack.push(this, other);
            boolean result = co.eltType.typeEquals(this.eltType);
            this.analyzer.state.typeStack.pop(this, other);
            return result;
        }
        return false;
    }

    public int hashCode() {
        return "ListType".hashCode();
    }

    @Override
    protected String printType(@NotNull Type.CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            ctr.push(this);
            sb.append("[");
            sb.append(this.eltType.printType(ctr));
            sb.append("]");
            ctr.pop(this);
        }
        return sb.toString();
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

