/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.visitor;

import com.google.common.base.Joiner;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.Utils;
import com.sourceclear.pysonar.ast.Alias;
import com.sourceclear.pysonar.ast.Assert;
import com.sourceclear.pysonar.ast.Assign;
import com.sourceclear.pysonar.ast.Attribute;
import com.sourceclear.pysonar.ast.Await;
import com.sourceclear.pysonar.ast.BinOp;
import com.sourceclear.pysonar.ast.Block;
import com.sourceclear.pysonar.ast.Break;
import com.sourceclear.pysonar.ast.Bytes;
import com.sourceclear.pysonar.ast.Call;
import com.sourceclear.pysonar.ast.ClassDef;
import com.sourceclear.pysonar.ast.Comprehension;
import com.sourceclear.pysonar.ast.Continue;
import com.sourceclear.pysonar.ast.Delete;
import com.sourceclear.pysonar.ast.Dict;
import com.sourceclear.pysonar.ast.DictComp;
import com.sourceclear.pysonar.ast.Dummy;
import com.sourceclear.pysonar.ast.Ellipsis;
import com.sourceclear.pysonar.ast.Exec;
import com.sourceclear.pysonar.ast.Expr;
import com.sourceclear.pysonar.ast.ExtSlice;
import com.sourceclear.pysonar.ast.For;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.ast.GeneratorExp;
import com.sourceclear.pysonar.ast.Global;
import com.sourceclear.pysonar.ast.Handler;
import com.sourceclear.pysonar.ast.If;
import com.sourceclear.pysonar.ast.IfExp;
import com.sourceclear.pysonar.ast.Import;
import com.sourceclear.pysonar.ast.ImportFrom;
import com.sourceclear.pysonar.ast.Index;
import com.sourceclear.pysonar.ast.Keyword;
import com.sourceclear.pysonar.ast.ListComp;
import com.sourceclear.pysonar.ast.Module;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.Pass;
import com.sourceclear.pysonar.ast.Print;
import com.sourceclear.pysonar.ast.PyComplex;
import com.sourceclear.pysonar.ast.PyFloat;
import com.sourceclear.pysonar.ast.PyInt;
import com.sourceclear.pysonar.ast.PyList;
import com.sourceclear.pysonar.ast.PySet;
import com.sourceclear.pysonar.ast.Raise;
import com.sourceclear.pysonar.ast.Repr;
import com.sourceclear.pysonar.ast.Return;
import com.sourceclear.pysonar.ast.SetComp;
import com.sourceclear.pysonar.ast.Slice;
import com.sourceclear.pysonar.ast.Starred;
import com.sourceclear.pysonar.ast.Str;
import com.sourceclear.pysonar.ast.Subscript;
import com.sourceclear.pysonar.ast.Try;
import com.sourceclear.pysonar.ast.Tuple;
import com.sourceclear.pysonar.ast.UnaryOp;
import com.sourceclear.pysonar.ast.Unsupported;
import com.sourceclear.pysonar.ast.Url;
import com.sourceclear.pysonar.ast.While;
import com.sourceclear.pysonar.ast.With;
import com.sourceclear.pysonar.ast.Withitem;
import com.sourceclear.pysonar.ast.Yield;
import com.sourceclear.pysonar.ast.YieldFrom;
import com.sourceclear.pysonar.types.ClassType;
import com.sourceclear.pysonar.types.FunType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.UnionType;
import com.sourceclear.pysonar.visitor.Visitor1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallGraphVisitor
extends Visitor1 {
    private Stack<String> classes = new Stack();
    private String module = null;
    private Stack<FunctionDef> functions = new Stack();
    private final Analyzer analyzer;
    private final Set<MethodInfo> methods;

    public CallGraphVisitor(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.methods = new HashSet<MethodInfo>();
    }

    @Override
    public void visit(Alias node) {
    }

    @Override
    public void visit(Assert node) {
        this.visit(node.msg);
        this.visit(node.test);
    }

    @Override
    public void visit(Assign node) {
        this.visit(node.value);
    }

    @Override
    public void visit(Attribute node) {
        this.visit(node.target);
    }

    @Override
    public void visit(Await node) {
        this.visit(node.value);
    }

    @Override
    public void visit(BinOp node) {
        boolean isOverriden;
        this.visit(node.left);
        this.visit(node.right);
        Type type = this.analyzer.state.getOverriddenOperatorTypes().get(node);
        boolean bl = isOverriden = type != null;
        if (isOverriden) {
            // empty if block
        }
    }

    @Override
    public void visit(Block node) {
        this.visit(node.seq);
    }

    @Override
    public void visit(Break node) {
    }

    @Override
    public void visit(Bytes node) {
    }

    @Override
    public void visit(Call node) {
        this.visit(node.func);
        this.visit(node.args);
        int lineNumber = node.lineNumber;
        MethodInfo caller = this.methodFromFunctionDef(this.currentFunction());
        List<Binding> bindings = this.bindingsFromNode(node.func);
        List<MethodInfo> callees = this.bindingsToMethodInfos(bindings);
        String fileName = this.analyzer.projectDir.relativize(node.getFile()).toString();
        for (MethodInfo callee : callees) {
            this.analyzer.state.addCallSite(new CallSite(caller, callee, fileName, lineNumber));
        }
    }

    @Override
    public void visit(ClassDef node) {
        if (node != null) {
            this.classes.push(node.name.id);
            this.visit(node.body);
            this.classes.pop();
        }
    }

    @Override
    public void visit(Comprehension node) {
        this.visit(node.target);
        this.visit(node.iter);
        this.visit(node.ifs);
    }

    @Override
    public void visit(Continue node) {
    }

    @Override
    public void visit(Delete node) {
        this.visit(node.targets);
    }

    @Override
    public void visit(Dict node) {
        this.visit(node.keys);
        this.visit(node.values);
    }

    @Override
    public void visit(DictComp node) {
        this.visit(node.key);
        this.visit(node.value);
        this.visit(node.generators);
    }

    @Override
    public void visit(Dummy node) {
    }

    @Override
    public void visit(Ellipsis node) {
    }

    @Override
    public void visit(Exec node) {
    }

    @Override
    public void visit(Expr node) {
        this.visit(node.value);
    }

    @Override
    public void visit(ExtSlice node) {
        this.visit(node.dims);
    }

    @Override
    public void visit(For node) {
        this.visit(node.iter);
        this.visit(node.target);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    @Override
    public void visit(FunctionDef node) {
        this.visit(node.defaults);
        MethodInfo methodInfo = this.methodFromFunctionDef(node);
        this.methods.add(methodInfo);
        this.functions.push(node);
        this.visit(node.body);
        this.functions.pop();
    }

    @Override
    public void visit(GeneratorExp node) {
        this.visit(node.generators);
        this.visit(node.elt);
    }

    @Override
    public void visit(Global node) {
    }

    @Override
    public void visit(Handler node) {
        this.visit(node.exceptions);
        this.visit(node.binder);
        this.visit(node.body);
    }

    @Override
    public void visit(If node) {
        this.visit(node.test);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    @Override
    public void visit(IfExp node) {
        this.visit(node.test);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    @Override
    public void visit(Import node) {
    }

    @Override
    public void visit(ImportFrom node) {
    }

    @Override
    public void visit(Index node) {
        this.visit(node.value);
    }

    @Override
    public void visit(Keyword node) {
        this.visit(node.value);
    }

    @Override
    public void visit(ListComp node) {
        this.visit(node.elt);
        this.visit(node.generators);
    }

    @Override
    public void visit(Module node) {
        if (node.body != null) {
            this.module = Utils.relativizeQname(this.analyzer.projectDir, Utils.moduleQname(node.getFile()));
            this.visit(node.body);
        }
    }

    @Override
    public void visit(Name node) {
    }

    @Override
    public void visit(Pass node) {
    }

    @Override
    public void visit(Print node) {
        this.visit(node.dest);
        this.visit(node.values);
    }

    @Override
    public void visit(PyComplex node) {
    }

    @Override
    public void visit(PyFloat node) {
    }

    @Override
    public void visit(PyInt node) {
    }

    @Override
    public void visit(PyList node) {
        this.visit(node.elts);
    }

    @Override
    public void visit(PySet node) {
        this.visit(node.elts);
    }

    @Override
    public void visit(Raise node) {
        this.visit(node.exceptionType);
        this.visit(node.inst);
        this.visit(node.traceback);
    }

    @Override
    public void visit(Repr node) {
        this.visit(node.value);
    }

    @Override
    public void visit(Return node) {
        this.visit(node.value);
    }

    @Override
    public void visit(SetComp node) {
        this.visit(node.elt);
        this.visit(node.generators);
    }

    @Override
    public void visit(Slice node) {
        this.visit(node.lower);
        this.visit(node.step);
        this.visit(node.upper);
    }

    @Override
    public void visit(Starred node) {
        this.visit(node.value);
    }

    @Override
    public void visit(Str node) {
    }

    @Override
    public void visit(Subscript node) {
        this.visit(node.value);
        this.visit(node.slice);
    }

    @Override
    public void visit(Try node) {
        this.visit(node.handlers);
        if (node.body != null) {
            this.visit(node.body);
        }
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
        if (node.finalbody != null) {
            this.visit(node.finalbody);
        }
    }

    @Override
    public void visit(Tuple node) {
        this.visit(node.elts);
    }

    @Override
    public void visit(UnaryOp node) {
        this.visit(node.operand);
    }

    @Override
    public void visit(Unsupported node) {
    }

    @Override
    public void visit(Url node) {
    }

    @Override
    public void visit(While node) {
        this.visit(node.test);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    @Override
    public void visit(With node) {
        for (Withitem item : node.items) {
            this.visit(item.context_expr);
        }
        this.visit(node.body);
    }

    @Override
    public void visit(Withitem node) {
    }

    @Override
    public void visit(Yield node) {
        this.visit(node.value);
    }

    @Override
    public void visit(YieldFrom node) {
        this.visit(node.value);
    }

    @NotNull
    private MethodInfo methodFromFunctionDef(FunctionDef functionDef) {
        String className = this.classes.isEmpty() ? null : Joiner.on((String)".").join(this.classes);
        String methodName = functionDef != null && functionDef.name != null ? functionDef.name.id : null;
        MethodInfo methodInfo = Utils.makeMethodInfo(this.module, className, methodName);
        return methodInfo;
    }

    @Nullable
    private FunctionDef currentFunction() {
        return this.functions.isEmpty() ? null : this.functions.peek();
    }

    @NotNull
    private List<MethodInfo> bindingsToMethodInfos(List<Binding> bindings) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (Binding binding : bindings) {
            Type type = binding.type;
            result.addAll(this.typeToMethodInfo(type, binding));
        }
        return result;
    }

    private List<MethodInfo> typeToMethodInfo(Type type, Binding binding) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        if (type instanceof FunType) {
            result.add(this.funTypeToMethodInfo((FunType)type, binding));
        } else if (type instanceof ClassType) {
            result.add(this.classTypeToMethodInfo((ClassType)type));
        } else if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            for (Type t : unionType.types) {
                result.addAll(this.typeToMethodInfo(t, binding));
            }
        }
        return result;
    }

    private MethodInfo classTypeToMethodInfo(ClassType type) {
        String className = type.name;
        String methodName = "__init__";
        String moduleName = Utils.relativizeQname(this.analyzer.projectDir, Utils.getQnameParent(type.table.path));
        return Utils.makeMethodInfo(moduleName, className, "__init__");
    }

    private MethodInfo funTypeToMethodInfo(FunType type, Binding binding) {
        FunctionDef func = type.func;
        if (func != null) {
            String className = type.cls != null ? type.cls.name : null;
            String methodName = func.name != null ? func.name.id : null;
            String moduleName = Utils.relativizeQname(this.analyzer.projectDir, type.env.path);
            return Utils.makeMethodInfo(moduleName, className, methodName);
        }
        String methodName = binding.name;
        String moduleName = Utils.getQnameParent(binding.qname);
        return Utils.makeMethodInfo(moduleName, null, methodName);
    }

    @NotNull
    private List<Binding> bindingsFromNode(@Nullable Node node) {
        if (node == null) {
            return Collections.emptyList();
        }
        switch (node.nodeType) {
            case ATTRIBUTE: {
                Attribute attribute = (Attribute)node;
                node = attribute.attr;
            }
            case NAME: {
                List<Binding> bindings = this.analyzer.state.getReferences().get(node);
                if (bindings == null) {
                    return Collections.emptyList();
                }
                return bindings;
            }
        }
        return Collections.emptyList();
    }

    public Set<MethodInfo> getMethods() {
        return this.methods;
    }
}

