/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import com.sourceclear.rubysonar.ArgsFlattener;
import com.sourceclear.rubysonar.Binder;
import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.CodeGenerator;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.Visitor;
import com.sourceclear.rubysonar.option.Option;
import com.sourceclear.rubysonar.option.Options;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.FunType;
import com.sourceclear.rubysonar.types.HashType;
import com.sourceclear.rubysonar.types.InstanceType;
import com.sourceclear.rubysonar.types.IntType;
import com.sourceclear.rubysonar.types.ListType;
import com.sourceclear.rubysonar.types.ModuleType;
import com.sourceclear.rubysonar.types.TupleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.Types;
import com.sourceclear.rubysonar.types.UnionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.AndNode;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgsPushNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.AttrAssignNode;
import org.jrubyparser.ast.BackRefNode;
import org.jrubyparser.ast.BeginNode;
import org.jrubyparser.ast.BignumNode;
import org.jrubyparser.ast.BinaryOperatorNode;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.BlockPassNode;
import org.jrubyparser.ast.BreakNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.CaseNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ComplexNode;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DRegexpNode;
import org.jrubyparser.ast.DStrNode;
import org.jrubyparser.ast.DSymbolNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.DXStrNode;
import org.jrubyparser.ast.DefinedNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.DotNode;
import org.jrubyparser.ast.EmptyArgsNode;
import org.jrubyparser.ast.EncodingNode;
import org.jrubyparser.ast.EnsureNode;
import org.jrubyparser.ast.EvStrNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.FalseNode;
import org.jrubyparser.ast.FixnumNode;
import org.jrubyparser.ast.FlipNode;
import org.jrubyparser.ast.FloatNode;
import org.jrubyparser.ast.ForNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.KeywordArgNode;
import org.jrubyparser.ast.KeywordRestArgNode;
import org.jrubyparser.ast.LambdaNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LiteralNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.Match2Node;
import org.jrubyparser.ast.Match3Node;
import org.jrubyparser.ast.MatchNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.NextNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NthRefNode;
import org.jrubyparser.ast.OpAsgnAndNode;
import org.jrubyparser.ast.OpAsgnConstDeclNode;
import org.jrubyparser.ast.OpAsgnNode;
import org.jrubyparser.ast.OpAsgnOrNode;
import org.jrubyparser.ast.OpElementAsgnNode;
import org.jrubyparser.ast.OptArgNode;
import org.jrubyparser.ast.OrNode;
import org.jrubyparser.ast.PostExeNode;
import org.jrubyparser.ast.PreExeNode;
import org.jrubyparser.ast.RationalNode;
import org.jrubyparser.ast.RedoNode;
import org.jrubyparser.ast.RegexpNode;
import org.jrubyparser.ast.RequiredKeywordArgumentValueNode;
import org.jrubyparser.ast.RescueBodyNode;
import org.jrubyparser.ast.RescueNode;
import org.jrubyparser.ast.RestArgNode;
import org.jrubyparser.ast.RetryNode;
import org.jrubyparser.ast.ReturnNode;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SValueNode;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.ast.StarNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SuperNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.SyntaxNode;
import org.jrubyparser.ast.TrueNode;
import org.jrubyparser.ast.UndefNode;
import org.jrubyparser.ast.UntilNode;
import org.jrubyparser.ast.VAliasNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.WhenNode;
import org.jrubyparser.ast.WhileNode;
import org.jrubyparser.ast.XStrNode;
import org.jrubyparser.ast.YieldNode;
import org.jrubyparser.ast.ZArrayNode;
import org.jrubyparser.ast.ZSuperNode;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.util.KeyValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeInferencer
extends Visitor<Type> {
    private static final EmptyArgsNode EMPTY_ARGS = new EmptyArgsNode();
    private State state;
    private boolean isStatic;
    private boolean shouldLookupLocal;
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeInferencer.class);

    public TypeInferencer(State state) {
        this(state, false, false);
    }

    public TypeInferencer(State state, boolean isStatic) {
        this(state, isStatic, false);
    }

    public TypeInferencer(State state, boolean isStatic, boolean shouldLookupLocal) {
        this.state = state;
        this.isStatic = isStatic;
        this.shouldLookupLocal = shouldLookupLocal;
    }

    @Override
    public Type visitAliasNode(AliasNode iVisited) {
        Type valueType = this.visitNode(iVisited.getOldName());
        Binder.bind(this.state, iVisited, valueType);
        return valueType;
    }

    @Override
    public Type visitAndNode(AndNode andNode) {
        Type firstType = this.visitNode(andNode.getFirstNode());
        Type secondType = this.visitNode(andNode.getSecondNode());
        return UnionType.union(firstType, secondType);
    }

    @Override
    public Type visitArgsNode(ArgsNode iVisited) {
        LOGGER.debug("Visiting ArgsNode {} in {}. This should not happen.", (Object)iVisited, (Object)this.state.path);
        return Types.UNKNOWN;
    }

    @Override
    public Type visitArgsCatNode(ArgsCatNode iVisited) {
        List<Node> nodes = iVisited.accept(ArgsFlattener.INSTANCE);
        ListType.ListTypeBuilder listTypeBuilder = new ListType.ListTypeBuilder().withGlobalTable(this.state.getGlobalTable());
        for (Node node : nodes) {
            if (node instanceof SplatNode) {
                Type type = this.visitSplatNode((SplatNode)node);
                for (Type t : ((ListType)type).getPositional()) {
                    listTypeBuilder.addElementType(t);
                }
                continue;
            }
            listTypeBuilder.addElementType(this.visitNode(node));
        }
        return listTypeBuilder.build();
    }

    @Override
    public Type visitArgsPushNode(ArgsPushNode iVisited) {
        List<Node> nodes = iVisited.accept(ArgsFlattener.INSTANCE);
        return this.createListType(nodes);
    }

    @Override
    public Type visitArgumentNode(ArgumentNode iVisited) {
        LOGGER.debug("Visiting ArugmentNode {}, in {}. This should not happen.", (Object)iVisited, (Object)this.state.path);
        return Types.UNKNOWN;
    }

    @Override
    public Type visitArrayNode(ArrayNode arrayNode) {
        List<Node> elements = Arrays.asList(arrayNode.children());
        return this.createListType(elements);
    }

    @Override
    public Type visitAttrAssignNode(AttrAssignNode attrAssignNode) {
        Type receiverType = this.visitNode(attrAssignNode.getReceiverNode());
        if (receiverType == Types.UNKNOWN) {
            return Types.UNKNOWN;
        }
        List<Binding> attrBindings = receiverType.getTable().lookupAttr(attrAssignNode.getName());
        if (attrBindings == null && (attrBindings = receiverType.getTable().lookup(attrAssignNode.getName())) == null) {
            return Types.UNKNOWN;
        }
        for (Binding binding : attrBindings) {
            if (!(binding.type instanceof FunType)) continue;
            ((FunType)binding.type).setSelfType(receiverType);
        }
        Type attrType = State.makeUnion(attrBindings);
        if (!(attrType instanceof FunType)) {
            return Types.UNKNOWN;
        }
        return this.apply((FunType)attrType, attrAssignNode.getArgsNode(), Options.none());
    }

    @Override
    public Type visitBackRefNode(BackRefNode iVisited) {
        return Types.STR;
    }

    @Override
    public Type visitBeginNode(BeginNode beingNode) {
        return this.visitNode(beingNode.getBodyNode());
    }

    @Override
    public Type visitBignumNode(BignumNode iVisited) {
        return this.intType();
    }

    @Override
    public Type visitBlockArgNode(BlockArgNode iVisited) {
        LOGGER.debug("Visiting BlockArgNode {}, in {}. This should not happen.", (Object)iVisited, (Object)this.state.path);
        return Types.UNKNOWN;
    }

    @Override
    public Type visitBlockNode(BlockNode iVisited) {
        boolean returned = false;
        Type returnType = Types.UNKNOWN;
        Iterator<Node> nodesIterator = iVisited.childNodes().iterator();
        boolean wasStatic = this.isStatic;
        while (nodesIterator.hasNext()) {
            boolean isLastNode;
            Node node = nodesIterator.next();
            Type type = this.visitNode(node);
            boolean bl = isLastNode = !nodesIterator.hasNext();
            if (isLastNode) {
                returnType = UnionType.remove(type, Types.CONT);
                continue;
            }
            if (!returned) {
                assert (type != null) : String.format("type of node %s is null", node);
                returnType = UnionType.union(returnType, type);
                if (type.equals(Types.UNKNOWN) || UnionType.contains(type, Types.CONT)) continue;
                returned = true;
                returnType = UnionType.remove(returnType, Types.CONT);
                continue;
            }
            if (this.state.getStateType() == State.StateType.GLOBAL || this.state.getStateType() == State.StateType.MODULE) continue;
            LOGGER.trace("Unreachable code in {}", (Object)node);
        }
        this.isStatic = wasStatic;
        return returnType;
    }

    @Override
    public Type visitBlockPassNode(BlockPassNode iVisited) {
        Type type = this.visitNode(iVisited.getBodyNode());
        return type;
    }

    @Override
    public Type visitBreakNode(BreakNode iVisited) {
        if (iVisited.hasValue()) {
            return this.visitNode(iVisited.getValueNode());
        }
        return Types.NIL;
    }

    @Override
    public Type visitConstDeclNode(ConstDeclNode iVisited) {
        State s;
        Type valueType = this.visitNode(iVisited.getValueNode());
        Node constNode = iVisited.getConstNode();
        if (constNode instanceof Colon2Node) {
            Colon2Node colon2Node = (Colon2Node)constNode;
            Type leftType = this.visitNode(colon2Node.getLeftNode());
            if (Types.UNKNOWN.equals(leftType)) {
                return Types.UNKNOWN;
            }
            s = leftType.getTable();
        } else {
            s = this.state;
        }
        Binder.bind(s, iVisited, valueType);
        return valueType;
    }

    @Override
    public Type visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        Type valueType = this.visitNode(iVisited.getValueNode());
        this.state.insertTagged(iVisited.getLexicalName(), "class", iVisited, valueType, Binding.Kind.ATTRIBUTE);
        return valueType;
    }

    @Override
    public Type visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        Type valueType = this.visitNode(iVisited.getValueNode());
        this.state.insertTagged(iVisited.getName(), "class", iVisited, valueType, Binding.Kind.ATTRIBUTE);
        return valueType;
    }

    @Override
    public Type visitClassVarNode(ClassVarNode iVisited) {
        return this.lookupTagged(iVisited.getLexicalName(), "class");
    }

    @Override
    public Type visitCallNode(CallNode callNode) {
        String functionName = callNode.getName();
        Option<Type> iterType = Options.none();
        Node iterNode = callNode.getIterNode();
        if (iterNode != null) {
            iterType = Options.of(this.visitNode(iterNode));
        }
        Type receiverType = this.visitNode(callNode.getReceiverNode());
        if ("new".equals(functionName)) {
            if (receiverType instanceof UnionType) {
                ArrayList<Type> instanceTypes = new ArrayList<Type>();
                for (Type type : ((UnionType)receiverType).getTypes()) {
                    if (!(type instanceof ClassType)) continue;
                    InstanceType instanceType = new InstanceType((ClassType)type, callNode.getArgsNode(), this.state);
                    ((ClassType)type).setCanon(instanceType);
                    instanceTypes.add(instanceType);
                }
                return UnionType.newUnion(instanceTypes);
            }
            if (receiverType instanceof ClassType) {
                InstanceType instanceType = new InstanceType((ClassType)receiverType, callNode.getArgsNode(), this.state);
                ((ClassType)receiverType).setCanon(instanceType);
                return instanceType;
            }
            LOGGER.trace("new called on a non-ClassType");
            return Types.UNKNOWN;
        }
        if (receiverType instanceof UnionType) {
            ArrayList<Type> returnTypes = new ArrayList<Type>();
            for (Type type : ((UnionType)receiverType).getTypes()) {
                Type returnType = this.callMethod(type, functionName, callNode.getArgsNode(), iterType);
                returnTypes.add(returnType);
            }
            return UnionType.newUnion(returnTypes);
        }
        return this.callMethod(receiverType, functionName, callNode.getArgsNode(), iterType);
    }

    @Override
    public Type visitCaseNode(CaseNode caseNode) {
        this.visitNode(caseNode.getCaseNode());
        ArrayList<Type> caseTypes = new ArrayList<Type>();
        caseTypes.add(Types.UNKNOWN);
        ListNode cases = caseNode.getCases();
        for (Node node : cases.children()) {
            caseTypes.add(this.visitNode(node));
        }
        Node elseNode = caseNode.getElseNode();
        if (elseNode != null) {
            caseTypes.add(this.visitNode(elseNode));
        }
        return UnionType.newUnion(caseTypes);
    }

    @Override
    public Type visitClassNode(ClassNode classNode) {
        ClassType classType = this.lookupOrCreateClass(classNode);
        classType.getTable().setParent(this.state);
        Type superType = this.visitNode(classNode.getSuperNode());
        classType.addSuper(superType);
        TypeInferencer classTypeInferencer = new TypeInferencer(classType.getTable(), this.isStatic);
        classTypeInferencer.visitNode(classNode.getBodyNode());
        return Types.CONT;
    }

    @Override
    public Type visitColon2Node(Colon2Node colon2Node) {
        Node leftNode = colon2Node.getLeftNode();
        String lexicalName = colon2Node.getLexicalName();
        if (leftNode == null) {
            return this.lookup(lexicalName);
        }
        boolean savedLookupLocal = this.shouldLookupLocal;
        this.shouldLookupLocal = false;
        Type leftNodeType = this.visitNode(leftNode);
        this.shouldLookupLocal = savedLookupLocal;
        if (leftNodeType.equals(Types.UNKNOWN)) {
            return Types.UNKNOWN;
        }
        return leftNodeType.getTable().lookupLocalType(lexicalName);
    }

    @Override
    public Type visitColon3Node(Colon3Node colon3Node) {
        String lexicalName = colon3Node.getLexicalName();
        return this.lookup(lexicalName);
    }

    @Override
    public Type visitConstNode(ConstNode constNode) {
        String lexicalName = constNode.getLexicalName();
        return this.lookup(lexicalName);
    }

    @Override
    public Type visitDAsgnNode(DAsgnNode iVisited) {
        Type valueType = this.visitNode(iVisited.getValueNode());
        Binder.bind(this.state, iVisited, valueType);
        return valueType;
    }

    @Override
    public Type visitDRegxNode(DRegexpNode iVisited) {
        for (Node node : iVisited.children()) {
            this.visitNode(node);
        }
        return Types.REGEXP;
    }

    @Override
    public Type visitDStrNode(DStrNode iVisited) {
        for (Node node : iVisited.children()) {
            if (node == null) continue;
            this.visitNode(node);
        }
        return Types.STR;
    }

    @Override
    public Type visitDSymbolNode(DSymbolNode iVisited) {
        for (Node node : iVisited.children()) {
            this.visitNode(node);
        }
        return Types.SYMBOL;
    }

    @Override
    public Type visitDVarNode(DVarNode iVisited) {
        String lexicalName = iVisited.getName();
        return this.lookup(lexicalName);
    }

    @Override
    public Type visitDXStrNode(DXStrNode iVisited) {
        for (Node node : iVisited.children()) {
            this.visitNode(node);
        }
        return Types.STR;
    }

    @Override
    public Type visitDefinedNode(DefinedNode iVisited) {
        this.visitNode(iVisited.getExpressionNode());
        return Types.BOOL;
    }

    @Override
    public Type visitDefnNode(DefnNode defnNode) {
        FunType funType = new FunType(this.state.getGlobalTable(), defnNode, this.state);
        funType.getTable().setParent(this.state);
        boolean isMethod = this.state.type instanceof ClassType;
        if (isMethod) {
            funType.setClassType((ClassType)this.state.type);
        }
        this.state.insert(defnNode.getName(), defnNode, funType, Binding.Kind.METHOD);
        funType.getTable().setPath(this.state.extendPath(defnNode.getName(), "#"));
        this.state.addUncalledMethod(funType);
        return Types.CONT;
    }

    @Override
    public Type visitDefsNode(DefsNode defsNode) {
        Node receiver = defsNode.getReceiverNode();
        Type receiverType = this.visitNode(receiver);
        State s = !receiverType.equals(Types.UNKNOWN) ? receiverType.getTable() : this.state;
        FunType funType = new FunType(this.state.getGlobalTable(), defsNode, s);
        funType.getTable().setParent(s);
        Type outType = s.type;
        boolean isMethod = outType instanceof ClassType;
        if (isMethod) {
            funType.setClassType((ClassType)outType);
        }
        funType.setClassMethod(true);
        String methodName = defsNode.getName();
        s.insertTagged(methodName, "class", defsNode, funType, Binding.Kind.CLASS_METHOD);
        funType.getTable().setPath(s.extendPath(methodName, "."));
        this.state.addUncalledMethod(funType);
        return Types.CONT;
    }

    @Override
    public Type visitDotNode(DotNode iVisited) {
        Type beginType = this.visitNode(iVisited.getBeginNode());
        Type endType = this.visitNode(iVisited.getEndNode());
        Type union = UnionType.union(beginType, endType);
        return new ListType(this.state.getGlobalTable(), union);
    }

    @Override
    public Type visitEmptyArgsNode(EmptyArgsNode node) {
        return new ListType(this.state.getGlobalTable());
    }

    @Override
    public Type visitEncodingNode(EncodingNode iVisited) {
        return new InstanceType(new ClassType("Encoding", this.state));
    }

    @Override
    public Type visitEnsureNode(EnsureNode iVisited) {
        Node bodyNode = iVisited.getBodyNode();
        Type bodyType = this.visitNode(bodyNode);
        Type bodyOrUnknown = UnionType.union((Type)Types.UNKNOWN, bodyType);
        Node ensureNode = iVisited.getEnsureNode();
        Type ensureType = Types.UNKNOWN;
        if (ensureNode != null) {
            ensureType = this.visitNode(ensureNode);
        }
        return UnionType.union(ensureType, bodyOrUnknown);
    }

    @Override
    public Type visitEvStrNode(EvStrNode iVisited) {
        Node body = iVisited.getBody();
        this.visitNode(body);
        return Types.STR;
    }

    @Override
    public Type visitFCallNode(FCallNode functionCallNode) {
        String functionName = functionCallNode.getName();
        ArrayList<Node> arguments = new ArrayList<Node>(functionCallNode.getArgsNode().childNodes());
        Option<Node> iterNode = Options.of(functionCallNode.getIterNode());
        switch (functionName) {
            case "attr_writer": {
                for (String attrName : TypeInferencer.argumentValues(functionCallNode)) {
                    DefnNode defnNode = CodeGenerator.generateWriterMethod(attrName, functionCallNode.getPosition());
                    this.visitNode(defnNode);
                }
                return Types.CONT;
            }
            case "attr_reader": {
                for (String attrName : TypeInferencer.argumentValues(functionCallNode)) {
                    DefnNode defnNode = CodeGenerator.generateReaderMethod(attrName, functionCallNode.getPosition());
                    this.visitNode(defnNode);
                }
                return Types.CONT;
            }
            case "attr_accessor": {
                for (String attrName : TypeInferencer.argumentValues(functionCallNode)) {
                    DefnNode writer = CodeGenerator.generateWriterMethod(attrName, functionCallNode.getPosition());
                    this.visitNode(writer);
                    DefnNode reader = CodeGenerator.generateReaderMethod(attrName, functionCallNode.getPosition());
                    this.visitNode(reader);
                }
                return Types.CONT;
            }
            case "attr": {
                Node firstArgument;
                if (arguments.size() > 0 && (firstArgument = (Node)arguments.get(0)) != null && (firstArgument instanceof SymbolNode || firstArgument instanceof StrNode)) {
                    Type secondArgument;
                    String attrName = TypeInferencer.valueOf(firstArgument);
                    DefnNode reader = CodeGenerator.generateReaderMethod(attrName, functionCallNode.getPosition());
                    this.visitNode(reader);
                    if (arguments.size() > 1 && (secondArgument = this.visitNode((Node)arguments.get(1))).equals(Types.TRUE)) {
                        DefnNode writer = CodeGenerator.generateWriterMethod(attrName, functionCallNode.getPosition());
                        this.visitNode(writer);
                    }
                }
                return Types.CONT;
            }
        }
        return this.inferFunctionCall(functionName, functionCallNode.getArgsNode(), iterNode);
    }

    @Override
    public Type visitFalseNode(FalseNode iVisited) {
        return Types.FALSE;
    }

    @Override
    public Type visitFixnumNode(FixnumNode iVisited) {
        return this.intType();
    }

    @Override
    public Type visitFlipNode(FlipNode iVisited) {
        return Types.BOOL;
    }

    @Override
    public Type visitFloatNode(FloatNode iVisited) {
        return Types.FLOAT;
    }

    @Override
    public Type visitForNode(ForNode iVisited) {
        Type iterType = this.visitNode(iVisited.getIterNode());
        this.visitNode(iVisited.getBodyNode());
        return iterType;
    }

    @Override
    public Type visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        Type valueType = this.visitNode(iVisited.getValueNode());
        Binder.bind(this.state, iVisited, valueType, Binding.Kind.SCOPE);
        return valueType;
    }

    @Override
    public Type visitGlobalVarNode(GlobalVarNode iVisited) {
        return this.state.lookupType(iVisited.getName());
    }

    @Override
    public Type visitHashNode(HashNode iVisited) {
        List<KeyValuePair<Node, Node>> pairs = iVisited.getPairs();
        ArrayList<Node> keys = new ArrayList<Node>();
        ArrayList<Node> values = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : pairs) {
            keys.add(pair.getKey());
            values.add(pair.getValue());
        }
        return new HashType(this.state.getGlobalTable(), this.union(keys), this.union(values));
    }

    @Override
    public Type visitInstAsgnNode(InstAsgnNode instAsgnNode) {
        Type valueType = this.visitNode(instAsgnNode.getValueNode());
        if (this.state.getParent() != null) {
            Binder.bind(this.state.getParent(), instAsgnNode, valueType, Binding.Kind.ATTRIBUTE);
        } else {
            LOGGER.trace("Unable to bind an instance attribute. State's parent is null");
        }
        return valueType;
    }

    @Override
    public Type visitInstVarNode(InstVarNode instVarNode) {
        String lexicalName = instVarNode.getLexicalName();
        return this.lookup(lexicalName);
    }

    @Override
    public Type visitIfNode(IfNode iVisited) {
        State thenState = this.state.copy();
        State elseState = this.state.copy();
        Type conditionType = this.visitNode(iVisited.getCondition());
        Node thenBody = iVisited.getThenBody();
        Type thenType = thenBody != null ? new TypeInferencer(thenState, this.isStatic).visitNode(thenBody) : Types.CONT;
        Node elseBody = iVisited.getElseBody();
        Type elseType = elseBody != null ? new TypeInferencer(elseState, this.isStatic).visitNode(elseBody) : Types.CONT;
        boolean thenContinues = UnionType.contains(thenType, Types.CONT);
        boolean elseContinues = UnionType.contains(elseType, Types.CONT);
        if (thenContinues && elseContinues) {
            this.state.overwrite(State.merge(thenState, elseState));
        } else if (thenContinues) {
            this.state.overwrite(thenState);
        } else if (elseContinues) {
            this.state.overwrite(elseState);
        }
        if (conditionType.equals(Types.TRUE)) {
            return thenType;
        }
        if (conditionType.equals(Types.FALSE)) {
            return elseType;
        }
        return UnionType.union(thenType, elseType);
    }

    @Override
    public Type visitIterNode(IterNode iterNode) {
        String name = this.state.freshLambdaName();
        this.visitNode(CodeGenerator.generateLambdaClass(name, iterNode.getPosition(), iterNode));
        Type type = this.visitNode(CodeGenerator.generateLambdaNewCallNode(name, iterNode.getPosition()));
        return type;
    }

    @Override
    public Type visitKeywordArgNode(KeywordArgNode iVisited) {
        return null;
    }

    @Override
    public Type visitKeywordRestArgNode(KeywordRestArgNode iVisited) {
        return null;
    }

    @Override
    public Type visitLambdaNode(LambdaNode lambdaNode) {
        return this.visitIterNode(lambdaNode);
    }

    @Override
    public Type visitListNode(ListNode iVisited) {
        return null;
    }

    @Override
    public Type visitLiteralNode(LiteralNode literalNode) {
        String name = literalNode.getName();
        return this.lookup(name);
    }

    @Override
    public Type visitLocalAsgnNode(LocalAsgnNode iVisited) {
        Type valueType = this.visitNode(iVisited.getValueNode());
        Binder.bind(this.state, iVisited, valueType);
        return valueType;
    }

    @Override
    public Type visitLocalVarNode(LocalVarNode localVarNode) {
        String lexicalName = localVarNode.getLexicalName();
        return this.lookup(lexicalName);
    }

    @Override
    public Type visitMultipleAsgnNode(MultipleAsgnNode multiAsgn) {
        List preNodes = multiAsgn.getPreCount() == 0 ? Collections.emptyList() : Arrays.asList(multiAsgn.getPre().children());
        Node rest = multiAsgn.getRest();
        List postNodes = multiAsgn.getPostCount() == 0 ? Collections.emptyList() : Arrays.asList(multiAsgn.getPost().children());
        Node valueNode = multiAsgn.getValueNode();
        Type valueType = this.visitNode(valueNode);
        ArrayList preAndPost = new ArrayList(preNodes);
        preAndPost.addAll(postNodes);
        if (valueType instanceof ListType) {
            ListType listType = (ListType)valueType;
            if (listType.getElementType().equals(Types.UNKNOWN)) {
                return valueType;
            }
            List<Type> positional = listType.getPositional();
            if (positional.isEmpty()) {
                return Types.UNKNOWN;
            }
            int preCount = preNodes.size();
            int postCount = postNodes.size();
            int startOfPost = positional.size() - postCount;
            List<Type> postTypes = positional.subList(startOfPost, positional.size());
            List<Object> preTypes = preCount > positional.size() ? Collections.emptyList() : positional.subList(0, preCount);
            ArrayList preAndPostTypes = new ArrayList(preTypes);
            preAndPostTypes.addAll(postTypes);
            Iterator typesIterator = preAndPostTypes.iterator();
            for (Node node : preAndPost) {
                if (typesIterator.hasNext()) {
                    Type type = (Type)typesIterator.next();
                    Binder.bind(this.state, node, type);
                    continue;
                }
                Binder.bind(this.state, node, Types.NIL);
            }
            if (rest != null) {
                List<Object> restTypes = preCount < 0 || startOfPost > positional.size() || preCount > startOfPost ? Collections.emptyList() : positional.subList(preCount, startOfPost);
                if (!restTypes.isEmpty()) {
                    Binder.bind(this.state, rest, new ListType(this.state.getGlobalTable(), UnionType.newUnion(restTypes), restTypes));
                } else {
                    Binder.bind(this.state, rest, Types.NIL);
                }
            }
            return valueType;
        }
        if (rest != null) {
            Binder.bind(this.state, rest, new ListType(this.state.getGlobalTable()));
        }
        boolean first = true;
        for (Node node : preAndPost) {
            if (first) {
                Binder.bind(this.state, node, valueType);
                first = false;
                continue;
            }
            Binder.bind(this.state, node, Types.NIL);
        }
        return valueType;
    }

    @Override
    public Type visitMatch2Node(Match2Node iVisited) {
        this.visitNode(iVisited.getValueNode());
        this.visitNode(iVisited.getReceiverNode());
        return this.intType();
    }

    @Override
    public Type visitMatch3Node(Match3Node iVisited) {
        this.visitNode(iVisited.getValueNode());
        this.visitNode(iVisited.getReceiverNode());
        return this.intType();
    }

    @Override
    public Type visitMatchNode(MatchNode iVisited) {
        this.visitNode(iVisited.getRegexpNode());
        return this.intType();
    }

    @Override
    public Type visitModuleNode(ModuleNode moduleNode) {
        Colon3Node cPath = moduleNode.getCPath();
        ModuleType moduleType = this.lookupOrCreateModule(cPath);
        moduleType.getTable().insert("self", cPath, moduleType, Binding.Kind.SCOPE);
        new TypeInferencer(moduleType.getTable(), this.isStatic).visitNode(moduleNode.getBodyNode());
        return moduleType;
    }

    @Override
    public Type visitNewlineNode(NewlineNode iVisited) {
        return this.visitNode(iVisited.getNextNode());
    }

    @Override
    public Type visitNextNode(NextNode nextNode) {
        return Types.NIL;
    }

    @Override
    public Type visitNilNode(NilNode iVisited) {
        return Types.NIL;
    }

    @Override
    public Type visitNthRefNode(NthRefNode iVisited) {
        return Types.STR;
    }

    @Override
    public Type visitOpElementAsgnNode(OpElementAsgnNode iVisited) {
        Node receiverNode = iVisited.getReceiverNode();
        Node valueNode = iVisited.getValueNode();
        Node argsNode = iVisited.getArgsNode();
        CallNode bracketsGetCall = new CallNode(iVisited.getPosition(), receiverNode, "[]", valueNode, null);
        CallNode opCall = new CallNode(iVisited.getPosition(), bracketsGetCall, iVisited.getOperatorName(), argsNode, null);
        ArrayNode argArray = new ArrayNode(iVisited.getPosition());
        argArray.add(valueNode);
        argArray.add(opCall);
        AttrAssignNode bracketsAssignCall = new AttrAssignNode(iVisited.getPosition(), receiverNode, "[]=", argArray, false);
        return this.visitAttrAssignNode(bracketsAssignCall);
    }

    @Override
    public Type visitOpAsgnNode(OpAsgnNode iVisited) {
        Node receiverNode = iVisited.getReceiverNode();
        ISourcePosition pos = iVisited.getPosition();
        CallNode readCall = new CallNode(pos, receiverNode, iVisited.getVariableName(), EMPTY_ARGS, null);
        CallNode opCall = new CallNode(pos, readCall, iVisited.getOperatorName(), iVisited.getValueNode(), null);
        CallNode writeCall = new CallNode(pos, receiverNode, iVisited.getVariableNameAsgn(), opCall, null);
        return this.visitCallNode(writeCall);
    }

    @Override
    public Type visitOpAsgnAndNode(OpAsgnAndNode iVisited) {
        return this.inferOpAsgnOrAndNode(iVisited);
    }

    @Override
    public Type visitOpAsgnConstDeclNode(OpAsgnConstDeclNode opAsgnConstDeclNode) {
        String operator = opAsgnConstDeclNode.getOperator();
        Node lhs = opAsgnConstDeclNode.getFirstNode();
        Node rhs = opAsgnConstDeclNode.getSecondNode();
        CallNode call = new CallNode(opAsgnConstDeclNode.getPosition(), lhs, operator, rhs, null);
        if (lhs instanceof INameNode) {
            return this.visitConstDeclNode(new ConstDeclNode(opAsgnConstDeclNode.getPosition(), null, (INameNode)((Object)lhs), call));
        }
        return Types.UNKNOWN;
    }

    @Override
    public Type visitOpAsgnOrNode(OpAsgnOrNode iVisited) {
        return this.inferOpAsgnOrAndNode(iVisited);
    }

    @Override
    public Type visitOptArgNode(OptArgNode iVisited) {
        return null;
    }

    @Override
    public Type visitOrNode(OrNode orNode) {
        Type firstType = this.visitNode(orNode.getFirstNode());
        Type secondType = this.visitNode(orNode.getSecondNode());
        return UnionType.union(firstType, secondType);
    }

    @Override
    public Type visitPreExeNode(PreExeNode iVisited) {
        this.visitNode(iVisited.getBodyNode());
        return Types.CONT;
    }

    @Override
    public Type visitPostExeNode(PostExeNode iVisited) {
        this.visitNode(iVisited.getBodyNode());
        return Types.CONT;
    }

    @Override
    public Type visitComplexNode(ComplexNode node) {
        return Types.FLOAT;
    }

    @Override
    public Type visitRationalNode(RationalNode node) {
        return Types.FLOAT;
    }

    @Override
    public Type visitStarNode(StarNode node) {
        return Types.UNKNOWN;
    }

    @Override
    public Type visitRedoNode(RedoNode iVisited) {
        return Types.NIL;
    }

    @Override
    public Type visitRegexpNode(RegexpNode iVisited) {
        return Types.REGEXP;
    }

    @Override
    public Type visitRequiredKeywordArgumentValueNode(RequiredKeywordArgumentValueNode node) {
        LOGGER.debug("Visiting required keyword argument node {} in {}. This should not happen. >_<", (Object)node, (Object)node.getPosition());
        return Types.UNKNOWN;
    }

    @Override
    public Type visitRescueBodyNode(RescueBodyNode iVisited) {
        return this.union(Arrays.asList(iVisited.getBodyNode(), iVisited.getOptRescueNode()));
    }

    @Override
    public Type visitRescueNode(RescueNode iVisited) {
        List<Node> nodes = Arrays.asList(iVisited.getBodyNode(), iVisited.getElseNode(), iVisited.getRescueNode());
        return this.union(nodes);
    }

    @Override
    public Type visitRestArgNode(RestArgNode iVisited) {
        return null;
    }

    @Override
    public Type visitRetryNode(RetryNode iVisited) {
        return Types.NIL;
    }

    @Override
    public Type visitReturnNode(ReturnNode iVisited) {
        return this.visitNode(iVisited.getValueNode());
    }

    @Override
    public Type visitRootNode(RootNode iVisited) {
        return this.visitNode(iVisited.getBodyNode());
    }

    @Override
    public Type visitSClassNode(SClassNode iVisited) {
        List<DefsNode> defsNodes = CodeGenerator.sClassNodeToDefsNodes(iVisited);
        boolean wasStatic = this.isStatic;
        this.isStatic = true;
        for (DefsNode defsNode : defsNodes) {
            this.visitDefsNode(defsNode);
        }
        this.isStatic = wasStatic;
        return Types.CONT;
    }

    @Override
    public Type visitSelfNode(SelfNode iVisited) {
        String selfName = iVisited.getName();
        return this.lookup(selfName);
    }

    @Override
    public Type visitSplatNode(SplatNode iVisited) {
        Node value = iVisited.getValue();
        Type valueType = this.visitNode(value);
        if (valueType == null) {
            return Types.UNKNOWN;
        }
        if (valueType instanceof ListType) {
            return valueType;
        }
        return new ListType(this.state.getGlobalTable(), valueType);
    }

    @Override
    public Type visitStrNode(StrNode iVisited) {
        return Types.STR;
    }

    @Override
    public Type visitSuperNode(SuperNode iVisited) {
        Node argsNode;
        if (this.state.stateType != State.StateType.FUNCTION) {
            LOGGER.trace("super invoked in a non-function scope");
            return Types.UNKNOWN;
        }
        Option<String> functionName = this.state.getFunctionName();
        if (functionName.isEmpty()) {
            LOGGER.trace("Couldn't find current function's name");
            return Types.UNKNOWN;
        }
        if (this.state.getParent() == null || this.state.getParent().supers == null) {
            LOGGER.trace("Unable to get parent or supers.");
            return Types.UNKNOWN;
        }
        Type superType = this.state.getParent().supers.lookupAttrType(functionName.get());
        if (superType == null) {
            LOGGER.trace("Unable to get super's type");
            return Types.UNKNOWN;
        }
        if (!(superType instanceof FunType)) {
            LOGGER.trace("super is not a function");
            return Types.UNKNOWN;
        }
        Option<Type> iterType = Options.none();
        Node iterNode = iVisited.getIterNode();
        if (iterNode != null) {
            iterType = Options.of(this.visitNode(iterNode));
        }
        if ((argsNode = iVisited.getArgsNode()) == null) {
            argsNode = EMPTY_ARGS;
        }
        return this.apply((FunType)superType, argsNode, iterType);
    }

    @Override
    public Type visitSValueNode(SValueNode iVisited) {
        return this.visitNode(iVisited.getValue());
    }

    @Override
    public Type visitSymbolNode(SymbolNode iVisited) {
        return Types.SYMBOL;
    }

    @Override
    public Type visitSyntaxNode(SyntaxNode iVisited) {
        return Types.UNKNOWN;
    }

    @Override
    public Type visitTrueNode(TrueNode iVisited) {
        return Types.TRUE;
    }

    @Override
    public Type visitUndefNode(UndefNode iVisited) {
        return Types.CONT;
    }

    @Override
    public Type visitUntilNode(UntilNode untilNode) {
        this.visitNode(untilNode.getConditionNode());
        Node bodyNode = untilNode.getBodyNode();
        if (bodyNode != null) {
            this.visitNode(bodyNode);
        }
        return Types.NIL;
    }

    @Override
    public Type visitVAliasNode(VAliasNode iVisited) {
        String oldName = iVisited.getOldName();
        String newName = iVisited.getNewName();
        List<Binding> bindings = this.state.lookup(oldName);
        if (bindings != null) {
            for (Binding oldBinding : bindings) {
                Binding b = new Binding(iVisited, oldBinding.type, oldBinding.kind);
                b.setQname(newName);
                this.state.getGlobalTable().update(newName, b);
            }
        }
        return Types.NIL;
    }

    @Override
    public Type visitVCallNode(VCallNode iVisited) {
        return this.inferFunctionCall(iVisited.getName(), EMPTY_ARGS, Options.none());
    }

    @Override
    public Type visitWhenNode(WhenNode whenNode) {
        return this.visitNode(whenNode.getBodyNode());
    }

    @Override
    public Type visitWhileNode(WhileNode whileNode) {
        this.visitNode(whileNode.getConditionNode());
        Node bodyNode = whileNode.getBodyNode();
        if (bodyNode != null) {
            this.visitNode(bodyNode);
        }
        return Types.NIL;
    }

    @Override
    public Type visitXStrNode(XStrNode iVisited) {
        return Types.STR;
    }

    @Override
    public Type visitYieldNode(YieldNode iVisited) {
        if (this.state.blockGiven()) {
            String blockParameterName = this.state.getBlockParameterName();
            CallNode call = CodeGenerator.generateCallToLocalReceiverNode(blockParameterName, "call", iVisited.getArgsNode(), null, iVisited.getPosition());
            Type callType = this.visitCallNode(call);
            return callType;
        }
        LOGGER.trace("Block not given. Node: {}, Path: {}", (Object)iVisited, (Object)this.state.path);
        return Types.UNKNOWN;
    }

    @Override
    public Type visitZArrayNode(ZArrayNode iVisited) {
        return new ListType(this.state.getGlobalTable());
    }

    @Override
    public Type visitZSuperNode(ZSuperNode iVisited) {
        SuperNode superNode = new SuperNode(iVisited.getPosition(), EMPTY_ARGS, iVisited.getIterNode());
        return this.visitSuperNode(superNode);
    }

    @Override
    protected Type defaultVisit(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(State state) {
        this.state = state;
    }

    @Override
    public void finish() {
        Queue<FunType> uncalledMethods = this.state.getGlobalTable().getUncalledMethods();
        EmptyArgsNode emptyArgsNode = new EmptyArgsNode();
        while (!uncalledMethods.isEmpty()) {
            FunType funType = uncalledMethods.remove();
            this.apply(funType, emptyArgsNode, Options.none());
        }
    }

    private Type callMethod(Type receiverType, String methodName, Node argsNode, Option<Type> iterType) {
        boolean isStaticMethod;
        boolean bl = isStaticMethod = receiverType instanceof ClassType || receiverType instanceof ModuleType;
        List<Binding> bindings = isStaticMethod ? receiverType.getTable().lookupAttrTagged(methodName, "class") : (receiverType instanceof InstanceType ? ((InstanceType)receiverType).getClassType().getTable().lookupAttr(methodName) : receiverType.getTable().lookup(methodName));
        if (bindings == null) {
            return Types.UNKNOWN;
        }
        for (Binding binding : bindings) {
            if (!(binding.type instanceof FunType)) continue;
            ((FunType)binding.type).setSelfType(receiverType);
        }
        Type instanceMethodType = State.makeUnion(bindings);
        if (!(instanceMethodType instanceof FunType)) {
            LOGGER.trace("Method {}.{} is not a FunType", (Object)receiverType, (Object)methodName);
            return Types.UNKNOWN;
        }
        return this.apply((FunType)instanceMethodType, argsNode, iterType);
    }

    @NotNull
    private Type inferOpAsgnOrAndNode(BinaryOperatorNode iVisited) {
        Type lhsType = this.visitNode(iVisited.getFirstNode());
        AssignableNode secondNode = (AssignableNode)iVisited.getSecondNode();
        Type valueType = this.visitNode(secondNode.getValueNode());
        Type unifiedType = UnionType.newUnion(Arrays.asList(lhsType, valueType));
        Binder.bind(this.state, secondNode, unifiedType);
        return unifiedType;
    }

    private Type visitNode(Node node) {
        if (node != null) {
            return node.accept(this);
        }
        return Types.UNKNOWN;
    }

    public Type apply(@NotNull FunType func, Node argsNode, Option<Type> iterType) {
        String methodQualifiedName;
        boolean isBuiltinFunction;
        boolean bl = isBuiltinFunction = func.getMethodDefNode() == null;
        if (isBuiltinFunction) {
            return func.getReturnType();
        }
        State globalTable = func.getTable().getGlobalTable();
        State functionStateTable = new State(func.getEnv(), State.StateType.FUNCTION);
        if (!func.getTable().path.isEmpty()) {
            functionStateTable.path = func.getTable().path;
        }
        if (globalTable.inCallStack(methodQualifiedName = functionStateTable.path)) {
            func.setSelfType(null);
            return Types.UNKNOWN;
        }
        functionStateTable.setFunctionName(func.getMethodDefNode().getName());
        globalTable.pushCallStack(methodQualifiedName);
        Type fromType = this.bindParamsAndBlockParam(functionStateTable, func.getMethodDefNode().getArgsNode(), argsNode, iterType);
        TypeInferencer typeInferencer = new TypeInferencer(functionStateTable, true);
        Type toType = typeInferencer.visitNode(func.getMethodDefNode().getBodyNode());
        globalTable.popCallStack(methodQualifiedName);
        func.addMapping(fromType, toType);
        func.setSelfType(null);
        globalTable.getUncalledMethods().remove(func);
        return toType;
    }

    private Type inferFunctionCall(String functionName, Node argsNode, Option<Node> iterNode) {
        List<Binding> functionBinding = this.state.lookup(functionName);
        if (this.isStatic) {
            functionBinding = this.state.lookupTagged(functionName, "class");
        }
        if (functionBinding == null) {
            return Types.UNKNOWN;
        }
        Type funType = State.makeUnion(functionBinding);
        if (!(funType instanceof FunType)) {
            return Types.UNKNOWN;
        }
        Option<Type> iterType = iterNode.isDefined() ? Options.of(this.visitNode(iterNode.get())) : Options.none();
        return this.apply((FunType)funType, argsNode, iterType);
    }

    private static List<String> argumentValues(FCallNode functionCallNode) {
        ArrayList<String> values = new ArrayList<String>();
        for (Node node : functionCallNode.getArgsNode().childNodes()) {
            if (!(node instanceof SymbolNode) && !(node instanceof StrNode)) continue;
            String value = TypeInferencer.valueOf(node);
            values.add(value);
        }
        return values;
    }

    private static String valueOf(Node node) {
        String value = node instanceof SymbolNode ? ((SymbolNode)node).getName() : (node instanceof StrNode ? ((StrNode)node).getValue().toString() : null);
        return value;
    }

    private Type bindParamsAndBlockParam(State functionStateTable, ArgsNode formalArgs, Node argsNode, Option<Type> iterType) {
        TupleType fromType = this.bindParams(functionStateTable, formalArgs, argsNode);
        boolean blockGiven = iterType.isDefined();
        if (blockGiven) {
            String name;
            BlockArgNode blockArgument = formalArgs.getBlock();
            Type type = iterType.get();
            if (blockArgument != null) {
                Binder.bind(functionStateTable, blockArgument, type, Binding.Kind.PARAMETER);
                name = blockArgument.getName();
            } else {
                name = functionStateTable.freshLambdaName();
                Binder.bind(functionStateTable, new BlockArgNode(formalArgs.getPosition(), 0, name), type, Binding.Kind.PARAMETER);
            }
            functionStateTable.setBlockParameterName(name);
            fromType.add(type);
        }
        return fromType;
    }

    /*
     * WARNING - void declaration
     */
    private TupleType bindParams(State functionStateTable, ArgsNode formalArgs, Node suppliedArgs) {
        void var17_45;
        TupleType fromType = new TupleType();
        Node[] pre = formalArgs.getPre().children();
        Node[] opt = formalArgs.getOptArgs().children();
        Node[] post = formalArgs.getPost().children();
        Node[] keywords = formalArgs.getKeywords().children();
        ArgumentNode restArgNode = formalArgs.getRestArgNode();
        List<Node> suppliedArgsList = suppliedArgs.accept(ArgsFlattener.INSTANCE);
        Iterator<Node> iterator = suppliedArgsList.iterator();
        for (Node node : pre) {
            InstanceType instanceType = iterator.hasNext() ? this.visitNode(iterator.next()) : Types.UNKNOWN;
            Binder.bind(functionStateTable, node, (Type)instanceType, Binding.Kind.PARAMETER);
            fromType.add(instanceType);
        }
        TypeInferencer funcInferencer = new TypeInferencer(functionStateTable, true);
        for (Node node : opt) {
            void var17_32;
            if (iterator.hasNext()) {
                Type type = this.visitNode(iterator.next());
            } else if (node instanceof OptArgNode) {
                Type type = ((OptArgNode)node).getValue().accept(funcInferencer);
            } else {
                InstanceType instanceType = Types.UNKNOWN;
            }
            Binder.bind(functionStateTable, node, (Type)var17_32, Binding.Kind.PARAMETER);
            fromType.add((Type)var17_32);
        }
        if (restArgNode == null) {
            for (Node node : post) {
                InstanceType instanceType = iterator.hasNext() ? this.visitNode(iterator.next()) : Types.UNKNOWN;
                Binder.bind(functionStateTable, node, (Type)instanceType, Binding.Kind.PARAMETER);
                fromType.add(instanceType);
            }
        } else {
            void var17_42;
            int n;
            int postArgCount = post.length;
            int startOfPost = suppliedArgsList.size() - postArgCount;
            ArrayList<InstanceType> postTypes = new ArrayList<InstanceType>();
            if (startOfPost < 0) {
                for (Node node : post) {
                    Binder.bind(functionStateTable, node, (Type)Types.UNKNOWN, Binding.Kind.PARAMETER);
                    postTypes.add(Types.UNKNOWN);
                }
            } else {
                ListIterator<Node> listIterator = suppliedArgsList.listIterator(startOfPost);
                for (Node node : post) {
                    InstanceType instanceType = listIterator.hasNext() ? this.visitNode(listIterator.next()) : Types.UNKNOWN;
                    Binder.bind(functionStateTable, node, (Type)instanceType, Binding.Kind.PARAMETER);
                    postTypes.add(instanceType);
                }
            }
            if ((n = pre.length + opt.length) > startOfPost || startOfPost > suppliedArgsList.size()) {
                List list = Collections.emptyList();
            } else {
                List<Node> list = suppliedArgsList.subList(n, startOfPost);
            }
            ArrayList<Type> restTypes = new ArrayList<Type>();
            for (Node node : var17_42) {
                restTypes.add(this.visitNode(node));
            }
            ListType restType = new ListType(this.state.getGlobalTable(), UnionType.newUnion(restTypes));
            Binder.bind(functionStateTable, restArgNode, (Type)restType, Binding.Kind.PARAMETER);
            fromType.add(restType);
            for (Type type : postTypes) {
                fromType.add(type);
            }
        }
        Node nextArg = iterator.hasNext() ? iterator.next() : null;
        boolean keywordArgSupplied = nextArg instanceof HashNode;
        Node[] nodeArray = keywords;
        int n = nodeArray.length;
        boolean bl = false;
        while (var17_45 < n) {
            Node keyword = nodeArray[var17_45];
            if (keyword instanceof KeywordArgNode) {
                Type keywordType;
                KeywordArgNode keywordArgNode = (KeywordArgNode)keyword;
                AssignableNode assignableNode = keywordArgNode.getAssignable();
                if (keywordArgSupplied) {
                    Type argType = this.visitNode(nextArg);
                    if (argType instanceof HashType) {
                        HashType hash = (HashType)argType;
                        keywordType = hash.getValueType();
                    } else {
                        keywordType = argType;
                    }
                } else {
                    Node valueNode = assignableNode.getValueNode();
                    if (valueNode instanceof RequiredKeywordArgumentValueNode) {
                        LOGGER.trace("Required keyword argument {} not supplied at {}", (Object)valueNode, (Object)valueNode.getPosition());
                        keywordType = Types.UNKNOWN;
                    } else {
                        keywordType = assignableNode.accept(funcInferencer);
                    }
                }
                Binder.bind(functionStateTable, assignableNode, keywordType, Binding.Kind.PARAMETER);
                fromType.add(keywordType);
            }
            ++var17_45;
        }
        return fromType;
    }

    @NotNull
    private Type union(Collection<Node> nodes) {
        Type result = Types.UNKNOWN;
        for (Node node : nodes) {
            if (node == null) continue;
            Type type = this.visitNode(node);
            result = UnionType.union(result, type);
        }
        return result;
    }

    private ClassType lookupOrCreateClass(ClassNode classNode) {
        boolean shouldLookupLocal;
        Type existing;
        State selfTable;
        State.StateType stateType;
        Colon2Node colon2Node;
        Node leftNode;
        Colon3Node colon3Node = classNode.getCPath();
        State parentState = this.state;
        boolean stateTableChanged = false;
        if (colon3Node instanceof Colon2Node && (leftNode = (colon2Node = (Colon2Node)colon3Node).getLeftNode()) != null) {
            Type type = this.visitNode(leftNode);
            if (type instanceof ModuleType || type instanceof ClassType) {
                parentState = type.getTable();
            } else {
                ModuleType moduleType = this.lookupOrCreateModule(leftNode);
                parentState = moduleType.getTable();
            }
            stateTableChanged = true;
        }
        if (!(stateTableChanged || (stateType = (selfTable = this.state.lookupLocalType("self").getTable()).getStateType()) != State.StateType.MODULE && stateType != State.StateType.CLASS)) {
            parentState = selfTable;
            stateTableChanged = true;
        }
        if ((existing = colon3Node.accept(new TypeInferencer(parentState, false, shouldLookupLocal = stateTableChanged))) instanceof ModuleType) {
            ModuleType module = (ModuleType)existing;
            State parent = module.getTable().getParent();
            ClassType classType = new ClassType(module.getName(), parent);
            if (parent != null) {
                parent.table.remove(module.getName());
                parent.insert(classType.getName(), classNode, classType, Binding.Kind.CLASS);
            }
            State classTable = classType.getTable();
            classTable.table = module.getTable().table;
            classTable.setPath(module.getTable().path);
            return classType;
        }
        boolean found = existing instanceof ClassType;
        if (found && !this.inParentChain(parentState, existing.getTable())) {
            return (ClassType)existing;
        }
        String name = colon3Node.getLexicalName();
        ClassType classType = new ClassType(name, parentState);
        parentState.insert(name, classNode, classType, Binding.Kind.CLASS);
        return classType;
    }

    private ModuleType lookupOrCreateModule(Node node) {
        ClassType classType;
        Colon2Node colon2Node;
        Node leftNode;
        ModuleType existingModule = this.lookupModule(node);
        if (existingModule != null) {
            return existingModule;
        }
        String name = node instanceof Colon3Node ? ((Colon3Node)node).getLexicalName() : (node instanceof ConstNode ? ((ConstNode)node).getLexicalName() : "RubySonarUnknown");
        State parent = node instanceof Colon2Node ? ((leftNode = (colon2Node = (Colon2Node)node).getLeftNode()) != null ? ((classType = this.lookupClass(leftNode)) != null ? classType.getTable() : this.lookupOrCreateModule(leftNode).getTable()) : this.state) : this.state;
        String file = node.getPosition().getFile();
        ModuleType moduleType = new ModuleType(name, file, parent);
        parent.insert(name, node, moduleType, Binding.Kind.MODULE);
        return moduleType;
    }

    @Nullable
    private ClassType lookupClass(Node node) {
        Type existing = node.accept(new TypeInferencer(this.state, this.isStatic, true));
        boolean found = existing instanceof ClassType;
        if (found && !this.inParentChain(this.state, existing.getTable())) {
            return (ClassType)existing;
        }
        return null;
    }

    @Nullable
    private ModuleType lookupModule(Node node) {
        Type existing = node.accept(new TypeInferencer(this.state, this.isStatic, true));
        boolean found = existing instanceof ModuleType;
        if (found && !this.inParentChain(this.state, existing.getTable())) {
            return (ModuleType)existing;
        }
        return null;
    }

    private boolean inParentChain(@NotNull State start, @NotNull State state) {
        State current;
        State global = current.getGlobalTable();
        for (current = start; current != global; current = current.getParent()) {
            if (current == state) {
                return true;
            }
            if (current.getParent() != null) continue;
            return false;
        }
        return false;
    }

    private IntType intType() {
        return new IntType(this.state.getGlobalTable());
    }

    private Type createListType(List<Node> elements) {
        if (elements.isEmpty()) {
            return new ListType(this.state.getGlobalTable());
        }
        ListType.ListTypeBuilder builder = ListType.builder();
        for (Node element : elements) {
            builder.addElementType(this.visitNode(element));
        }
        builder.withGlobalTable(this.state.getGlobalTable());
        return builder.build();
    }

    private Type lookup(String name) {
        if (this.shouldLookupLocal) {
            return this.state.lookupLocalType(name);
        }
        return this.state.lookupType(name);
    }

    private Type lookupTagged(String name, String tag) {
        if (this.shouldLookupLocal) {
            return this.state.lookupLocalTypeTagged(name, tag);
        }
        return this.state.lookupTypeTagged(name, tag);
    }
}

