/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.TypeInferencer;
import com.sourceclear.rubysonar.option.Options;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.FunType;
import com.sourceclear.rubysonar.types.Type;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jrubyparser.ast.Node;

public class InstanceType
implements Type {
    @NotNull
    private final ClassType classType;
    @NotNull
    private final State table;

    public InstanceType(@NotNull ClassType classType) {
        this.table = new State(classType.getTable(), State.StateType.INSTANCE);
        this.table.setStateType(State.StateType.INSTANCE);
        this.table.setParent(classType.getTable().getParent());
        this.table.setPath(classType.getTable().path);
        this.classType = classType;
        for (Map.Entry<String, List<Binding>> e : classType.getTable().table.entrySet()) {
            for (Binding b : e.getValue()) {
                if (b.kind == Binding.Kind.CLASS_METHOD) continue;
                this.table.update(e.getKey(), b);
            }
        }
    }

    public InstanceType(@NotNull ClassType classType, Node argsNode, State state) {
        this(classType);
        Type initFunc = this.table.lookupAttrType("initialize");
        if (initFunc != null && initFunc instanceof FunType && ((FunType)initFunc).getMethodDefNode() != null) {
            ((FunType)initFunc).setSelfType(this);
            TypeInferencer typeInferencer = new TypeInferencer(state, true);
            typeInferencer.apply((FunType)initFunc, argsNode, Options.none());
            ((FunType)initFunc).setSelfType(null);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof InstanceType) {
            InstanceType iother = (InstanceType)other;
            if (this.classType.equals(iother.classType) && this.table.keySet().equals(iother.table.keySet())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.classType.hashCode();
    }

    @Override
    public String printType(CyclicTypeRecorder ctr) {
        return this.classType.getName();
    }

    @NotNull
    public ClassType getClassType() {
        return this.classType;
    }

    @Override
    @NotNull
    public State getTable() {
        return this.table;
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }
}

